/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.base.Joiner;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class Sets {
    private Sets() {
    }

    public static ColumnSpecification valueSpecOf(ColumnSpecification column) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier("value(" + column.name + ")", true), ((SetType)column.type).elements);
    }

    public static class Discarder
    extends Operation {
        public Discarder(ColumnIdentifier column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            Term.Terminal value = this.t.bind(params.variables);
            if (value == null) {
                return;
            }
            Set<ByteBuffer> toDiscard = value instanceof Constants.Value ? Collections.singleton(((Constants.Value)value).bytes) : ((Value)value).elements;
            ColumnNameBuilder column = prefix.add(this.columnName.key);
            for (ByteBuffer bb : toDiscard) {
                ByteBuffer cellName = column.copy().add(bb).build();
                cf.addColumn(params.makeTombstone(cellName));
            }
        }
    }

    public static class Adder
    extends Operation {
        public Adder(ColumnIdentifier column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            Adder.doAdd(this.t, cf, prefix.add(this.columnName.key), params);
        }

        static void doAdd(Term t, ColumnFamily cf, ColumnNameBuilder columnName, UpdateParameters params) throws InvalidRequestException {
            Term.Terminal value = t.bind(params.variables);
            if (value == null) {
                return;
            }
            assert (value instanceof Value) : value;
            Set<ByteBuffer> toAdd = ((Value)value).elements;
            for (ByteBuffer bb : toAdd) {
                ByteBuffer cellName = columnName.copy().add(bb).build();
                cf.addColumn(params.makeColumn(cellName, ByteBufferUtil.EMPTY_BYTE_BUFFER));
            }
        }
    }

    public static class Setter
    extends Operation {
        public Setter(ColumnIdentifier column, Term t) {
            super(column, t);
        }

        @Override
        public void execute(ByteBuffer rowKey, ColumnFamily cf, ColumnNameBuilder prefix, UpdateParameters params) throws InvalidRequestException {
            ColumnNameBuilder column = prefix.add(this.columnName.key);
            cf.addAtom(params.makeTombstoneForOverwrite(column.build(), column.buildAsEndOfRange()));
            Adder.doAdd(this.t, cf, column, params);
        }
    }

    public static class Marker
    extends AbstractMarker {
        protected Marker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
            assert (receiver.type instanceof SetType);
        }

        @Override
        public Value bind(List<ByteBuffer> values) throws InvalidRequestException {
            ByteBuffer value = values.get(this.bindIndex);
            return value == null ? null : Value.fromSerialized(value, (SetType)this.receiver.type);
        }
    }

    public static class Value
    extends Term.Terminal {
        public final Set<ByteBuffer> elements;

        public Value(Set<ByteBuffer> elements) {
            this.elements = elements;
        }

        public static Value fromSerialized(ByteBuffer value, SetType type) throws InvalidRequestException {
            try {
                Set s = (Set)type.compose(value);
                LinkedHashSet<ByteBuffer> elements = new LinkedHashSet<ByteBuffer>(s.size());
                for (Object element : s) {
                    elements.add(type.elements.decompose(element));
                }
                return new Value(elements);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        @Override
        public ByteBuffer get() {
            return CollectionType.pack(new ArrayList<ByteBuffer>(this.elements), this.elements.size());
        }
    }

    public static class Literal
    implements Term.Raw {
        private final List<Term.Raw> elements;

        public Literal(List<Term.Raw> elements) {
            this.elements = elements;
        }

        @Override
        public Term.Terminal prepare(ColumnSpecification receiver) throws InvalidRequestException {
            this.validateAssignableTo(receiver);
            if (receiver.type instanceof MapType && this.elements.isEmpty()) {
                return new Maps.Value(Collections.emptyMap());
            }
            ColumnSpecification valueSpec = Sets.valueSpecOf(receiver);
            TreeSet<ByteBuffer> values = new TreeSet<ByteBuffer>(((SetType)receiver.type).elements);
            for (Term.Raw rt : this.elements) {
                Term t = rt.prepare(valueSpec);
                if (t instanceof Term.NonTerminal) {
                    throw new InvalidRequestException(String.format("Invalid set literal for %s: bind variables are not supported inside collection literals", receiver));
                }
                assert (t instanceof Constants.Value);
                ByteBuffer bytes = ((Constants.Value)t).bytes;
                if (bytes == null) {
                    throw new InvalidRequestException("null is not supported inside collections");
                }
                if (bytes.remaining() > 65535) {
                    throw new InvalidRequestException(String.format("Set value is too long. Set values are limited to %d bytes but %d bytes value provided", 65535, bytes.remaining()));
                }
                if (values.add(bytes)) continue;
                throw new InvalidRequestException(String.format("Invalid set literal: duplicate value %s", rt));
            }
            return new Value(values);
        }

        private void validateAssignableTo(ColumnSpecification receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof SetType)) {
                if (receiver.type instanceof MapType && this.elements.isEmpty()) {
                    return;
                }
                throw new InvalidRequestException(String.format("Invalid set literal for %s of type %s", receiver, receiver.type.asCQL3Type()));
            }
            ColumnSpecification valueSpec = Sets.valueSpecOf(receiver);
            for (Term.Raw rt : this.elements) {
                if (rt.isAssignableTo(valueSpec)) continue;
                throw new InvalidRequestException(String.format("Invalid set literal for %s: value %s is not of type %s", receiver, rt, valueSpec.type.asCQL3Type()));
            }
        }

        @Override
        public boolean isAssignableTo(ColumnSpecification receiver) {
            try {
                this.validateAssignableTo(receiver);
                return true;
            }
            catch (InvalidRequestException e) {
                return false;
            }
        }

        public String toString() {
            return "{" + Joiner.on((String)", ").join(this.elements) + "}";
        }
    }
}

