/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.UUIDGen;
import org.jboss.netty.buffer.ChannelBuffer;

public class QueryMessage
extends Message.Request {
    public static final Message.Codec<QueryMessage> codec = new Message.Codec<QueryMessage>(){

        @Override
        public QueryMessage decode(ChannelBuffer body, int version) {
            String query = CBUtil.readLongString(body);
            ConsistencyLevel consistency = CBUtil.readConsistencyLevel(body);
            int resultPageSize = -1;
            ArrayList<ByteBuffer> values = Collections.emptyList();
            boolean skipMetadata = false;
            PagingState pagingState = null;
            if (version >= 2) {
                EnumSet<Flag> flags = Flag.deserialize(body.readByte());
                if (flags.contains((Object)Flag.PAGE_SIZE)) {
                    resultPageSize = body.readInt();
                }
                if (flags.contains((Object)Flag.VALUES)) {
                    int paramCount = body.readUnsignedShort();
                    values = paramCount == 0 ? Collections.emptyList() : new ArrayList<ByteBuffer>(paramCount);
                    for (int i = 0; i < paramCount; ++i) {
                        values.add(CBUtil.readValue(body));
                    }
                }
                skipMetadata = flags.contains((Object)Flag.SKIP_METADATA);
                if (flags.contains((Object)Flag.PAGING_STATE)) {
                    pagingState = PagingState.deserialize(CBUtil.readValue(body));
                }
            }
            return new QueryMessage(query, consistency, values, resultPageSize, skipMetadata, pagingState);
        }

        @Override
        public ChannelBuffer encode(QueryMessage msg, int version) {
            int vs = msg.values.size();
            EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
            if (msg.resultPageSize >= 0) {
                flags.add(Flag.PAGE_SIZE);
            }
            if (vs > 0) {
                flags.add(Flag.VALUES);
            }
            if (msg.skipMetadata) {
                flags.add(Flag.SKIP_METADATA);
            }
            if (msg.pagingState != null) {
                flags.add(Flag.PAGING_STATE);
            }
            assert (flags.isEmpty() || version >= 2) : "Version 1 of the protocol supports no option after the consistency level";
            int nbBuff = 2;
            if (version >= 2) {
                ++nbBuff;
                if (flags.contains((Object)Flag.PAGE_SIZE)) {
                    ++nbBuff;
                }
                if (flags.contains((Object)Flag.VALUES)) {
                    ++nbBuff;
                }
            }
            CBUtil.BufferBuilder builder = new CBUtil.BufferBuilder(nbBuff, 0, vs + (flags.contains((Object)Flag.PAGING_STATE) ? 1 : 0));
            builder.add(CBUtil.longStringToCB(msg.query));
            builder.add(CBUtil.consistencyLevelToCB(msg.consistency));
            if (version >= 2) {
                builder.add(CBUtil.byteToCB((byte)Flag.serialize(flags)));
                if (flags.contains((Object)Flag.PAGE_SIZE)) {
                    builder.add(CBUtil.intToCB(msg.resultPageSize));
                }
                if (flags.contains((Object)Flag.VALUES)) {
                    builder.add(CBUtil.shortToCB(vs));
                    for (ByteBuffer value : msg.values) {
                        builder.addValue(value);
                    }
                }
                if (flags.contains((Object)Flag.PAGING_STATE)) {
                    builder.addValue(msg.pagingState == null ? null : msg.pagingState.serialize());
                }
            }
            return builder.build();
        }
    };
    public final String query;
    public final ConsistencyLevel consistency;
    public final int resultPageSize;
    public final List<ByteBuffer> values;
    public final boolean skipMetadata;
    public final PagingState pagingState;

    public QueryMessage(String query, ConsistencyLevel consistency) {
        this(query, consistency, Collections.emptyList(), -1);
    }

    public QueryMessage(String query, ConsistencyLevel consistency, List<ByteBuffer> values, int resultPageSize) {
        this(query, consistency, values, resultPageSize, false, null);
    }

    public QueryMessage(String query, ConsistencyLevel consistency, List<ByteBuffer> values, int resultPageSize, boolean skipMetadata, PagingState pagingState) {
        super(Message.Type.QUERY);
        this.query = query;
        this.consistency = consistency;
        this.resultPageSize = resultPageSize;
        this.values = values;
        this.skipMetadata = skipMetadata;
        this.pagingState = pagingState;
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this, this.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message.Response execute(QueryState state) {
        try {
            if (this.resultPageSize == 0) {
                throw new ProtocolException("The page size cannot be 0");
            }
            UUID tracingId = null;
            if (this.isTracingRequested()) {
                tracingId = UUIDGen.getTimeUUID();
                state.prepareTracingSession(tracingId);
            }
            if (state.traceNextQuery()) {
                state.createTracingSession();
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)"query", (Object)this.query);
                if (this.resultPageSize > 0) {
                    builder.put((Object)"page_size", (Object)Integer.toString(this.resultPageSize));
                }
                Tracing.instance.begin("Execute CQL3 query", (Map<String, String>)builder.build());
            }
            ResultMessage response = QueryProcessor.process(this.query, this.values, this.consistency, state, this.resultPageSize, this.pagingState);
            if (tracingId != null) {
                response.setTracingId(tracingId);
            }
            ResultMessage resultMessage = response;
            return resultMessage;
        }
        catch (Exception e) {
            if (!(e instanceof RequestValidationException) && !(e instanceof RequestExecutionException)) {
                logger.error("Unexpected error during query", (Throwable)e);
            }
            ErrorMessage errorMessage = ErrorMessage.fromException(e);
            return errorMessage;
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public String toString() {
        return "QUERY " + this.query;
    }

    public static enum Flag {
        PAGE_SIZE,
        VALUES,
        SKIP_METADATA,
        PAGING_STATE;


        public static EnumSet<Flag> deserialize(int flags) {
            EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
            Flag[] values = Flag.values();
            for (int n = 0; n < values.length; ++n) {
                if ((flags & 1 << n) == 0) continue;
                set.add(values[n]);
            }
            return set;
        }

        public static int serialize(EnumSet<Flag> flags) {
            int i = 0;
            for (Flag flag : flags) {
                i |= 1 << flag.ordinal();
            }
            return i;
        }
    }
}

