/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.messages.CompleteMessage;
import org.apache.cassandra.streaming.messages.FileMessage;
import org.apache.cassandra.streaming.messages.PrepareMessage;
import org.apache.cassandra.streaming.messages.RetryMessage;
import org.apache.cassandra.streaming.messages.SessionFailedMessage;

public abstract class StreamMessage {
    public static final int CURRENT_VERSION = 1;
    public final Type type;

    public static void serialize(StreamMessage message, WritableByteChannel out, int version, StreamSession session) throws IOException {
        ByteBuffer buff = ByteBuffer.allocate(1);
        buff.put(message.type.type);
        buff.flip();
        out.write(buff);
        message.type.serializer.serialize(message, out, version, session);
    }

    public static StreamMessage deserialize(ReadableByteChannel in, int version, StreamSession session) throws IOException {
        ByteBuffer buff = ByteBuffer.allocate(1);
        in.read(buff);
        buff.flip();
        Type type = Type.get(buff.get());
        return type.serializer.deserialize(in, version, session);
    }

    protected StreamMessage(Type type) {
        this.type = type;
    }

    public int getPriority() {
        return this.type.priority;
    }

    public static enum Type {
        PREPARE(1, 5, PrepareMessage.serializer),
        FILE(2, 0, FileMessage.serializer),
        RETRY(3, 1, RetryMessage.serializer),
        COMPLETE(4, 4, CompleteMessage.serializer),
        SESSION_FAILED(5, 5, SessionFailedMessage.serializer);

        private final byte type;
        public final int priority;
        public final Serializer<StreamMessage> serializer;

        public static Type get(byte type) {
            for (Type t : Type.values()) {
                if (t.type != type) continue;
                return t;
            }
            throw new IllegalArgumentException("Unknown type " + type);
        }

        private Type(int type, int priority, Serializer serializer) {
            this.type = (byte)type;
            this.priority = priority;
            this.serializer = serializer;
        }
    }

    public static interface Serializer<V extends StreamMessage> {
        public V deserialize(ReadableByteChannel var1, int var2, StreamSession var3) throws IOException;

        public void serialize(V var1, WritableByteChannel var2, int var3, StreamSession var4) throws IOException;
    }
}

