/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.compress;

import com.google.common.base.Throwables;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.StreamReader;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.compress.CompressedInputStream;
import org.apache.cassandra.streaming.compress.CompressionInfo;
import org.apache.cassandra.streaming.messages.FileMessageHeader;
import org.apache.cassandra.utils.BytesReadTracker;
import org.apache.cassandra.utils.Pair;

public class CompressedStreamReader
extends StreamReader {
    protected final CompressionInfo compressionInfo;

    public CompressedStreamReader(FileMessageHeader header, StreamSession session) {
        super(header, session);
        this.compressionInfo = header.compressionInfo;
    }

    @Override
    public SSTableReader read(ReadableByteChannel channel) throws IOException {
        long totalSize = this.totalSize();
        CompressedInputStream cis = new CompressedInputStream(Channels.newInputStream(channel), this.compressionInfo);
        Pair<String, String> kscf = Schema.instance.getCF(this.cfId);
        ColumnFamilyStore cfs = Keyspace.open((String)kscf.left).getColumnFamilyStore((String)kscf.right);
        Directories.DataDirectory localDir = cfs.directories.getLocationCapableOfSize(totalSize);
        if (localDir == null) {
            throw new IOException("Insufficient disk space to store " + totalSize + " bytes");
        }
        this.desc = Descriptor.fromFilename(cfs.getTempSSTablePath(cfs.directories.getLocationForDisk(localDir)));
        SSTableWriter writer = new SSTableWriter(this.desc.filenameFor(Component.DATA), this.estimatedKeys);
        try {
            BytesReadTracker in = new BytesReadTracker(new DataInputStream(cis));
            for (Pair section : this.sections) {
                long length = (Long)section.right - (Long)section.left;
                cis.position((Long)section.left);
                in.reset(0L);
                while (in.getBytesRead() < length) {
                    this.writeRow(writer, in, cfs);
                    this.session.progress(this.desc, ProgressInfo.Direction.IN, cis.getTotalCompressedBytesRead(), totalSize);
                }
            }
            return writer.closeAndOpenReader();
        }
        catch (Throwable e) {
            writer.abort();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    protected long totalSize() {
        long size = 0L;
        for (CompressionMetadata.Chunk chunk : this.compressionInfo.chunks) {
            size += (long)(chunk.length + 4);
        }
        return size;
    }
}

