/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamTask;
import org.apache.cassandra.utils.Pair;

public class StreamReceiveTask
extends StreamTask {
    private final int totalFiles;
    private final long totalSize;
    protected Collection<SSTableReader> sstables;

    public StreamReceiveTask(StreamSession session, UUID cfId, int totalFiles, long totalSize) {
        super(session, cfId);
        this.totalFiles = totalFiles;
        this.totalSize = totalSize;
        this.sstables = new ArrayList<SSTableReader>(totalFiles);
    }

    public void received(SSTableReader sstable) {
        assert (this.cfId.equals(sstable.metadata.cfId));
        this.sstables.add(sstable);
        if (this.sstables.size() == this.totalFiles) {
            this.complete();
        }
    }

    @Override
    public int getTotalNumberOfFiles() {
        return this.totalFiles;
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete() {
        if (!SSTableReader.acquireReferences(this.sstables)) {
            throw new AssertionError((Object)"We shouldn't fail acquiring a reference on a sstable that has just been transferred");
        }
        try {
            Pair<String, String> kscf = Schema.instance.getCF(this.cfId);
            ColumnFamilyStore cfs = Keyspace.open((String)kscf.left).getColumnFamilyStore((String)kscf.right);
            cfs.addSSTables(this.sstables);
            cfs.indexManager.maybeBuildSecondaryIndexes(this.sstables, cfs.indexManager.allIndexesNames());
        }
        finally {
            SSTableReader.releaseReferences(this.sstables);
        }
        this.session.taskCompleted(this);
    }
}

