/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.util.ByteBufferOutputStream;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class PagingState {
    public final ByteBuffer partitionKey;
    public final ByteBuffer cellName;
    public final int remaining;

    public PagingState(ByteBuffer partitionKey, ByteBuffer cellName, int remaining) {
        this.partitionKey = partitionKey == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : partitionKey;
        this.cellName = cellName == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : cellName;
        this.remaining = remaining;
    }

    public static PagingState deserialize(ByteBuffer bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            DataInputStream in = new DataInputStream(ByteBufferUtil.inputStream(bytes));
            ByteBuffer pk = ByteBufferUtil.readWithShortLength(in);
            ByteBuffer cn = ByteBufferUtil.readWithShortLength(in);
            int remaining = in.readInt();
            return new PagingState(pk, cn, remaining);
        }
        catch (IOException e) {
            throw new ProtocolException("Invalid value for the paging state");
        }
    }

    public ByteBuffer serialize() {
        try {
            ByteBuffer result = ByteBuffer.allocate(this.serializedSize());
            DataOutputStream out = new DataOutputStream(new ByteBufferOutputStream(result));
            ByteBufferUtil.writeWithShortLength(this.partitionKey, out);
            ByteBufferUtil.writeWithShortLength(this.cellName, out);
            out.writeInt(this.remaining);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int serializedSize() {
        return 2 + this.partitionKey.remaining() + 2 + this.cellName.remaining() + 4;
    }
}

