/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.UUIDSerializer;

public class TimeUUIDSerializer
extends UUIDSerializer {
    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        super.validate(bytes);
        ByteBuffer slice = bytes.slice();
        if (bytes.remaining() > 0) {
            slice.position(6);
            if ((slice.get() & 0xF0) != 16) {
                throw new MarshalException("Invalid version for TimeUUID type.");
            }
        }
    }
}

