/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.CounterUpdateColumn;
import org.apache.cassandra.db.marshal.AbstractCommutativeType;
import org.apache.cassandra.serializers.CounterSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CounterColumnType
extends AbstractCommutativeType {
    public static final CounterColumnType instance = new CounterColumnType();

    CounterColumnType() {
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        return ByteBufferUtil.compareUnsigned(o1, o2);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return ByteBufferUtil.bytesToHex(bytes);
    }

    @Override
    public Column createColumn(ByteBuffer name, ByteBuffer value, long timestamp) {
        return new CounterUpdateColumn(name, value, timestamp);
    }

    @Override
    public ByteBuffer fromString(String source) {
        return ByteBufferUtil.hexToBytes(source);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 8 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("Expected 8 or 0 byte long (%d)", bytes.remaining()));
        }
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.COUNTER;
    }

    @Override
    public TypeSerializer<Long> getSerializer() {
        return CounterSerializer.instance;
    }
}

