/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.transport.messages.ResultMessage;

public class DropColumnFamilyStatement
extends SchemaAlteringStatement {
    private final boolean ifExists;

    public DropColumnFamilyStatement(CFName name, boolean ifExists) {
        super(name);
        this.ifExists = ifExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.DROP);
    }

    @Override
    public void announceMigration() throws ConfigurationException {
        block2: {
            try {
                MigrationManager.announceColumnFamilyDrop(this.keyspace(), this.columnFamily());
            }
            catch (ConfigurationException e) {
                if (this.ifExists) break block2;
                throw e;
            }
        }
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.DROPPED;
    }
}

