/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Operation;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.statements.ColumnGroupMap;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public class UpdateStatement
extends ModificationStatement {
    private CFDefinition cfDef;
    private final List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations;
    private final List<Relation> whereClause;
    private final List<ColumnIdentifier> columnNames;
    private final List<Term.Raw> columnValues;
    private final List<Operation> processedColumns = new ArrayList<Operation>();
    private final Map<ColumnIdentifier, List<Term>> processedKeys = new HashMap<ColumnIdentifier, List<Term>>();
    private static final Operation setToEmptyOperation = new Constants.Setter(null, new Constants.Value(ByteBufferUtil.EMPTY_BYTE_BUFFER));

    public UpdateStatement(CFName name, List<Pair<ColumnIdentifier, Operation.RawUpdate>> operations, List<Relation> whereClause, Attributes attrs) {
        super(name, attrs);
        this.operations = operations;
        this.whereClause = whereClause;
        this.columnNames = null;
        this.columnValues = null;
    }

    public UpdateStatement(CFName name, Attributes attrs, List<ColumnIdentifier> columnNames, List<Term.Raw> columnValues) {
        super(name, attrs);
        this.columnNames = columnNames;
        this.columnValues = columnValues;
        this.operations = null;
        this.whereClause = null;
    }

    @Override
    protected void validateConsistency(ConsistencyLevel cl) throws InvalidRequestException {
        if (this.type == ModificationStatement.Type.COUNTER) {
            cl.validateCounterForWrite(this.cfDef.cfm);
        } else {
            cl.validateForWrite(this.cfDef.cfm.ksName);
        }
    }

    public Collection<IMutation> getMutations(List<ByteBuffer> variables, boolean local, ConsistencyLevel cl, long now) throws RequestExecutionException, RequestValidationException {
        List<ByteBuffer> keys = UpdateStatement.buildKeyNames(this.cfDef, this.processedKeys, variables);
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        UpdateStatement.buildColumnNames(this.cfDef, this.processedKeys, builder, variables, true);
        TreeSet<ByteBuffer> toRead = null;
        for (Operation op : this.processedColumns) {
            if (!op.requiresRead()) continue;
            if (toRead == null) {
                toRead = new TreeSet<ByteBuffer>(UTF8Type.instance);
            }
            toRead.add(op.columnName.key);
        }
        Map<ByteBuffer, ColumnGroupMap> rows = toRead != null ? this.readRows(keys, builder, toRead, (CompositeType)this.cfDef.cfm.comparator, local, cl) : null;
        LinkedList<IMutation> mutations = new LinkedList<IMutation>();
        UpdateParameters params = new UpdateParameters(variables, this.getTimestamp(now), this.getTimeToLive(), rows);
        for (ByteBuffer key : keys) {
            mutations.add(this.mutationForKey(this.cfDef, key, builder, params, cl));
        }
        return mutations;
    }

    static CFDefinition.Name buildColumnNames(CFDefinition cfDef, Map<ColumnIdentifier, List<Term>> processed, ColumnNameBuilder builder, List<ByteBuffer> variables, boolean requireAllComponent) throws InvalidRequestException {
        CFDefinition.Name firstEmpty = null;
        for (CFDefinition.Name name : cfDef.columns.values()) {
            List<Term> values = processed.get(name.name);
            if (values == null || values.isEmpty()) {
                firstEmpty = name;
                if (!requireAllComponent || !cfDef.isComposite || cfDef.isCompact) continue;
                throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s", name));
            }
            if (firstEmpty != null) {
                throw new InvalidRequestException(String.format("Missing PRIMARY KEY part %s since %s is set", firstEmpty.name, name.name));
            }
            assert (values.size() == 1);
            builder.add(values.get(0).bindAndGet(variables));
        }
        return firstEmpty;
    }

    static List<ByteBuffer> buildKeyNames(CFDefinition cfDef, Map<ColumnIdentifier, List<Term>> processed, List<ByteBuffer> variables) throws InvalidRequestException {
        ColumnNameBuilder keyBuilder = cfDef.getKeyNameBuilder();
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>();
        for (CFDefinition.Name name : cfDef.keys.values()) {
            List<Term> values = processed.get(name.name);
            if (values == null || values.isEmpty()) {
                throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s", name));
            }
            if (keyBuilder.remainingCount() == 1) {
                for (Term t : values) {
                    keys.add(keyBuilder.copy().add(t.bindAndGet(variables)).build());
                }
                continue;
            }
            if (values.size() > 1) {
                throw new InvalidRequestException("IN is only supported on the last column of the partition key");
            }
            keyBuilder.add(values.get(0).bindAndGet(variables));
        }
        return keys;
    }

    private IMutation mutationForKey(CFDefinition cfDef, ByteBuffer key, ColumnNameBuilder builder, UpdateParameters params, ConsistencyLevel cl) throws InvalidRequestException {
        org.apache.cassandra.cql.QueryProcessor.validateKey(key);
        QueryProcessor.validateKey(key);
        RowMutation rm = new RowMutation(cfDef.cfm.ksName, key);
        ColumnFamily cf = rm.addOrGet(cfDef.cfm.cfName);
        if (cfDef.isComposite && !cfDef.isCompact) {
            ByteBuffer name = builder.copy().add(ByteBufferUtil.EMPTY_BYTE_BUFFER).build();
            cf.addColumn(params.makeColumn(name, ByteBufferUtil.EMPTY_BYTE_BUFFER));
        }
        if (cfDef.isCompact) {
            if (builder.componentCount() == 0) {
                throw new InvalidRequestException(String.format("Missing PRIMARY KEY part %s", cfDef.columns.values().iterator().next()));
            }
            if (cfDef.value == null) {
                assert (this.processedColumns.isEmpty());
                setToEmptyOperation.execute(key, cf, builder.copy(), params);
            } else {
                if (this.processedColumns.isEmpty()) {
                    throw new InvalidRequestException(String.format("Missing mandatory column %s", cfDef.value));
                }
                for (Operation op : this.processedColumns) {
                    op.execute(key, cf, builder.copy(), params);
                }
            }
        } else {
            for (Operation op : this.processedColumns) {
                op.execute(key, cf, builder.copy(), params);
            }
        }
        return this.type == ModificationStatement.Type.COUNTER ? new CounterMutation(rm, cl) : rm;
    }

    @Override
    public ParsedStatement.Prepared prepare(ColumnSpecification[] boundNames) throws InvalidRequestException {
        CFMetaData metadata = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        this.cfDef = metadata.getCfDef();
        ModificationStatement.Type type = this.type = metadata.getDefaultValidator().isCommutative() ? ModificationStatement.Type.COUNTER : ModificationStatement.Type.LOGGED;
        if (this.operations == null) {
            if (this.type == ModificationStatement.Type.COUNTER) {
                throw new InvalidRequestException("INSERT statement are not allowed on counter tables, use UPDATE instead");
            }
            if (this.columnNames.size() != this.columnValues.size()) {
                throw new InvalidRequestException("Unmatched column names/values");
            }
            if (this.columnNames.isEmpty()) {
                throw new InvalidRequestException("No columns provided to INSERT");
            }
            block8: for (int i = 0; i < this.columnNames.size(); ++i) {
                CFDefinition.Name name = this.cfDef.get(this.columnNames.get(i));
                if (name == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", this.columnNames.get(i)));
                }
                for (int j = 0; j < i; ++j) {
                    if (!name.name.equals(this.columnNames.get(j))) continue;
                    throw new InvalidRequestException(String.format("Multiple definitions found for column %s", name));
                }
                Term.Raw value = this.columnValues.get(i);
                switch (name.kind) {
                    case KEY_ALIAS: 
                    case COLUMN_ALIAS: {
                        Term t = value.prepare(name);
                        t.collectMarkerSpecification(boundNames);
                        if (this.processedKeys.put(name.name, Collections.singletonList(t)) == null) continue block8;
                        throw new InvalidRequestException(String.format("Multiple definitions found for PRIMARY KEY part %s", name));
                    }
                    case VALUE_ALIAS: 
                    case COLUMN_METADATA: {
                        Operation operation = new Operation.SetValue(value).prepare(name);
                        operation.collectMarkerSpecification(boundNames);
                        this.processedColumns.add(operation);
                    }
                }
            }
        } else {
            for (Pair<ColumnIdentifier, Operation.RawUpdate> entry : this.operations) {
                CFDefinition.Name name = this.cfDef.get((ColumnIdentifier)entry.left);
                if (name == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", entry.left));
                }
                Operation operation = ((Operation.RawUpdate)entry.right).prepare(name);
                operation.collectMarkerSpecification(boundNames);
                switch (name.kind) {
                    case KEY_ALIAS: 
                    case COLUMN_ALIAS: {
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s found in SET part", entry.left));
                    }
                    case VALUE_ALIAS: 
                    case COLUMN_METADATA: {
                        this.processedColumns.add(operation);
                    }
                }
            }
            UpdateStatement.processKeys(this.cfDef, this.whereClause, this.processedKeys, boundNames);
        }
        return new ParsedStatement.Prepared(this, Arrays.asList(boundNames));
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        ColumnSpecification[] names = new ColumnSpecification[this.getBoundsTerms()];
        return this.prepare(names);
    }

    static void processKeys(CFDefinition cfDef, List<Relation> keys, Map<ColumnIdentifier, List<Term>> processed, ColumnSpecification[] names) throws InvalidRequestException {
        for (Relation rel : keys) {
            CFDefinition.Name name = cfDef.get(rel.getEntity());
            if (name == null) {
                throw new InvalidRequestException(String.format("Unknown key identifier %s", rel.getEntity()));
            }
            switch (name.kind) {
                case KEY_ALIAS: 
                case COLUMN_ALIAS: {
                    List<Term.Raw> rawValues;
                    if (rel.operator() == Relation.Type.EQ) {
                        rawValues = Collections.singletonList(rel.getValue());
                    } else if (name.kind == CFDefinition.Name.Kind.KEY_ALIAS && rel.operator() == Relation.Type.IN) {
                        rawValues = rel.getInValues();
                    } else {
                        throw new InvalidRequestException(String.format("Invalid operator %s for PRIMARY KEY part %s", new Object[]{rel.operator(), name}));
                    }
                    ArrayList<Term> values = new ArrayList<Term>(rawValues.size());
                    for (Term.Raw raw : rawValues) {
                        Term t = raw.prepare(name);
                        t.collectMarkerSpecification(names);
                        values.add(t);
                    }
                    if (processed.put(name.name, values) == null) break;
                    throw new InvalidRequestException(String.format("Multiple definitions found for PRIMARY KEY part %s", name));
                }
                case VALUE_ALIAS: 
                case COLUMN_METADATA: {
                    throw new InvalidRequestException(String.format("Non PRIMARY KEY %s found in where clause", name));
                }
            }
        }
    }

    public String toString() {
        return String.format("UpdateStatement(name=%s, keys=%s, columns=%s, timestamp=%s, timeToLive=%s)", this.cfName, this.whereClause, this.operations, this.isSetTimestamp() ? Long.valueOf(this.getTimestamp(-1L)) : "<now>", this.getTimeToLive());
    }
}

