/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.service.StorageService;
import org.apache.commons.lang.StringUtils;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordAuthenticator
implements IAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(PasswordAuthenticator.class);
    private static final long DEFAULT_USER_SETUP_DELAY = 10L;
    private static final int GENSALT_LOG2_ROUNDS = 10;
    private static final String SALTED_HASH = "salted_hash";
    private static final String DEFAULT_USER_NAME = "cassandra";
    private static final String DEFAULT_USER_PASSWORD = "cassandra";
    private static final String CREDENTIALS_CF = "credentials";
    private static final String CREDENTIALS_CF_SCHEMA = String.format("CREATE TABLE %s.%s (username text,salted_hash text,options map<text,text>,PRIMARY KEY(username)) WITH gc_grace_seconds=%d", "system_auth", "credentials", 7776000);

    @Override
    public boolean requireAuthentication() {
        return true;
    }

    @Override
    public Set<IAuthenticator.Option> supportedOptions() {
        return ImmutableSet.of((Object)((Object)IAuthenticator.Option.PASSWORD));
    }

    @Override
    public Set<IAuthenticator.Option> alterableOptions() {
        return ImmutableSet.of((Object)((Object)IAuthenticator.Option.PASSWORD));
    }

    @Override
    public AuthenticatedUser authenticate(Map<String, String> credentials) throws AuthenticationException {
        UntypedResultSet result;
        String username = credentials.get("username");
        if (username == null) {
            throw new AuthenticationException(String.format("Required key '%s' is missing", "username"));
        }
        String password = credentials.get("password");
        if (password == null) {
            throw new AuthenticationException(String.format("Required key '%s' is missing", "password"));
        }
        try {
            result = PasswordAuthenticator.process(String.format("SELECT %s FROM %s.%s WHERE username = '%s'", SALTED_HASH, "system_auth", CREDENTIALS_CF, PasswordAuthenticator.escape(username)));
        }
        catch (RequestExecutionException e) {
            throw new AuthenticationException(e.toString());
        }
        if (result.isEmpty() || !BCrypt.checkpw((String)password, (String)result.one().getString(SALTED_HASH))) {
            throw new AuthenticationException("Username and/or password are incorrect");
        }
        return new AuthenticatedUser(username);
    }

    @Override
    public void create(String username, Map<IAuthenticator.Option, Object> options) throws InvalidRequestException, RequestExecutionException {
        String password = (String)options.get((Object)IAuthenticator.Option.PASSWORD);
        if (password == null) {
            throw new InvalidRequestException("PasswordAuthenticator requires PASSWORD option");
        }
        PasswordAuthenticator.process(String.format("INSERT INTO %s.%s (username, salted_hash) VALUES ('%s', '%s')", "system_auth", CREDENTIALS_CF, PasswordAuthenticator.escape(username), PasswordAuthenticator.escape(PasswordAuthenticator.hashpw(password))));
    }

    @Override
    public void alter(String username, Map<IAuthenticator.Option, Object> options) throws RequestExecutionException {
        PasswordAuthenticator.process(String.format("UPDATE %s.%s SET salted_hash = '%s' WHERE username = '%s'", "system_auth", CREDENTIALS_CF, PasswordAuthenticator.escape(PasswordAuthenticator.hashpw((String)options.get((Object)IAuthenticator.Option.PASSWORD))), PasswordAuthenticator.escape(username)));
    }

    @Override
    public void drop(String username) throws RequestExecutionException {
        PasswordAuthenticator.process(String.format("DELETE FROM %s.%s WHERE username = '%s'", "system_auth", CREDENTIALS_CF, PasswordAuthenticator.escape(username)));
    }

    public Set<DataResource> protectedResources() {
        return ImmutableSet.of((Object)DataResource.columnFamily("system_auth", CREDENTIALS_CF));
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
    }

    @Override
    public void setup() {
        this.setupCredentialsTable();
        StorageService.tasks.schedule(new Runnable(){

            @Override
            public void run() {
                PasswordAuthenticator.this.setupDefaultUser();
            }
        }, 10L, TimeUnit.SECONDS);
    }

    private void setupCredentialsTable() {
        if (Schema.instance.getCFMetaData("system_auth", CREDENTIALS_CF) == null) {
            try {
                PasswordAuthenticator.process(CREDENTIALS_CF_SCHEMA);
            }
            catch (RequestExecutionException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private void setupDefaultUser() {
        try {
            if (PasswordAuthenticator.process(String.format("SELECT * FROM %s.%s", "system_auth", CREDENTIALS_CF)).isEmpty()) {
                PasswordAuthenticator.process(String.format("INSERT INTO %s.%s (username, salted_hash) VALUES ('%s', '%s') USING TIMESTAMP 0", "system_auth", CREDENTIALS_CF, "cassandra", PasswordAuthenticator.escape(PasswordAuthenticator.hashpw("cassandra"))));
                logger.info("PasswordAuthenticator created default user '{}'", (Object)"cassandra");
            }
        }
        catch (RequestExecutionException e) {
            logger.warn("PasswordAuthenticator skipped default user setup: some nodes were not ready");
        }
    }

    private static String hashpw(String password) {
        return BCrypt.hashpw((String)password, (String)BCrypt.gensalt((int)10));
    }

    private static String escape(String name) {
        return StringUtils.replace((String)name, (String)"'", (String)"''");
    }

    private static UntypedResultSet process(String query) throws RequestExecutionException {
        return QueryProcessor.process(query, ConsistencyLevel.QUORUM);
    }
}

