/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.locator.SimpleStrategy;
import org.apache.cassandra.service.IMigrationListener;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Auth {
    private static final Logger logger = LoggerFactory.getLogger(Auth.class);
    public static final String DEFAULT_SUPERUSER_NAME = "cassandra";
    private static final long SUPERUSER_SETUP_DELAY = 10L;
    public static final String AUTH_KS = "system_auth";
    public static final String USERS_CF = "users";
    private static final String USERS_CF_SCHEMA = String.format("CREATE TABLE %s.%s (name text,super boolean,PRIMARY KEY(name)) WITH gc_grace_seconds=%d", "system_auth", "users", 7776000);

    public static boolean isExistingUser(String username) {
        String query = String.format("SELECT * FROM %s.%s WHERE name = '%s'", AUTH_KS, USERS_CF, Auth.escape(username));
        try {
            return !QueryProcessor.process(query, ConsistencyLevel.QUORUM).isEmpty();
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isSuperuser(String username) {
        String query = String.format("SELECT super FROM %s.%s WHERE name = '%s'", AUTH_KS, USERS_CF, Auth.escape(username));
        try {
            UntypedResultSet result = QueryProcessor.process(query, ConsistencyLevel.QUORUM);
            return !result.isEmpty() && result.one().getBoolean("super");
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void insertUser(String username, boolean isSuper) throws RequestExecutionException {
        QueryProcessor.process(String.format("INSERT INTO %s.%s (name, super) VALUES ('%s', %s)", AUTH_KS, USERS_CF, Auth.escape(username), isSuper), ConsistencyLevel.QUORUM);
    }

    public static void deleteUser(String username) throws RequestExecutionException {
        QueryProcessor.process(String.format("DELETE FROM %s.%s WHERE name = '%s'", AUTH_KS, USERS_CF, Auth.escape(username)), ConsistencyLevel.QUORUM);
    }

    public static void setup() {
        Auth.setupAuthKeyspace();
        Auth.setupUsersTable();
        DatabaseDescriptor.getAuthenticator().setup();
        DatabaseDescriptor.getAuthorizer().setup();
        MigrationManager.instance.register(new MigrationListener());
        StorageService.tasks.schedule(new Runnable(){

            @Override
            public void run() {
                Auth.setupDefaultSuperuser();
            }
        }, 10L, TimeUnit.SECONDS);
    }

    private static void setupAuthKeyspace() {
        if (Schema.instance.getKSMetaData(AUTH_KS) == null) {
            try {
                KSMetaData ksm = KSMetaData.newKeyspace(AUTH_KS, SimpleStrategy.class.getName(), (Map<String, String>)ImmutableMap.of((Object)"replication_factor", (Object)"1"), true);
                MigrationManager.announceNewKeyspace(ksm, 0L);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static void setupUsersTable() {
        if (Schema.instance.getCFMetaData(AUTH_KS, USERS_CF) == null) {
            try {
                QueryProcessor.process(USERS_CF_SCHEMA, ConsistencyLevel.ONE);
            }
            catch (RequestExecutionException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static void setupDefaultSuperuser() {
        try {
            if (QueryProcessor.process(String.format("SELECT * FROM %s.%s", AUTH_KS, USERS_CF), ConsistencyLevel.QUORUM).isEmpty()) {
                QueryProcessor.process(String.format("INSERT INTO %s.%s (name, super) VALUES ('%s', %s) USING TIMESTAMP 0", AUTH_KS, USERS_CF, DEFAULT_SUPERUSER_NAME, true), ConsistencyLevel.QUORUM);
                logger.info("Created default superuser '{}'", (Object)DEFAULT_SUPERUSER_NAME);
            }
        }
        catch (RequestExecutionException e) {
            logger.warn("Skipped default superuser setup: some nodes were not ready");
        }
    }

    private static String escape(String name) {
        return StringUtils.replace((String)name, (String)"'", (String)"''");
    }

    public static class MigrationListener
    implements IMigrationListener {
        @Override
        public void onDropKeyspace(String ksName) {
            DatabaseDescriptor.getAuthorizer().revokeAll(DataResource.keyspace(ksName));
        }

        @Override
        public void onDropColumnFamily(String ksName, String cfName) {
            DatabaseDescriptor.getAuthorizer().revokeAll(DataResource.columnFamily(ksName, cfName));
        }

        @Override
        public void onCreateKeyspace(String ksName) {
        }

        @Override
        public void onCreateColumnFamily(String ksName, String cfName) {
        }

        @Override
        public void onUpdateKeyspace(String ksName) {
        }

        @Override
        public void onUpdateColumnFamily(String ksName, String cfName) {
        }
    }
}

