/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.TokenSerializer;
import org.apache.cassandra.gms.VersionGenerator;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.StringUtils;

public class VersionedValue
implements Comparable<VersionedValue> {
    public static final IVersionedSerializer<VersionedValue> serializer = new VersionedValueSerializer();
    public static final char DELIMITER = ',';
    public static final String DELIMITER_STR = new String(new char[]{','});
    public static final String STATUS_BOOTSTRAPPING = "BOOT";
    public static final String STATUS_NORMAL = "NORMAL";
    public static final String STATUS_LEAVING = "LEAVING";
    public static final String STATUS_LEFT = "LEFT";
    public static final String STATUS_MOVING = "MOVING";
    public static final String REMOVING_TOKEN = "removing";
    public static final String REMOVED_TOKEN = "removed";
    public static final String HIBERNATE = "hibernate";
    public static final String REMOVAL_COORDINATOR = "REMOVER";
    public final int version;
    public final String value;

    private VersionedValue(String value, int version) {
        assert (value != null);
        this.value = value;
        this.version = version;
    }

    private VersionedValue(String value) {
        this(value, VersionGenerator.getNextVersion());
    }

    @Override
    public int compareTo(VersionedValue value) {
        return this.version - value.version;
    }

    public String toString() {
        return "Value(" + this.value + "," + this.version + ")";
    }

    private static String versionString(String ... args) {
        return StringUtils.join((Object[])args, (char)',');
    }

    private static class VersionedValueSerializer
    implements IVersionedSerializer<VersionedValue> {
        private VersionedValueSerializer() {
        }

        @Override
        public void serialize(VersionedValue value, DataOutput dos, int version) throws IOException {
            dos.writeUTF(this.outValue(value, version));
            dos.writeInt(value.version);
        }

        private String outValue(VersionedValue value, int version) {
            String outValue = value.value;
            if (version < 6) {
                String[] pieces = value.value.split(DELIMITER_STR, -1);
                String type = pieces[0];
                if (type.equals(VersionedValue.STATUS_NORMAL) || type.equals(VersionedValue.STATUS_BOOTSTRAPPING)) {
                    assert (pieces.length >= 2);
                    outValue = VersionedValue.versionString(new String[]{pieces[0], pieces[1]});
                }
                if (type.equals(VersionedValue.STATUS_LEFT)) {
                    assert (pieces.length >= 3);
                    String string = outValue = version < 3 ? VersionedValue.versionString(new String[]{pieces[0], pieces[2]}) : VersionedValue.versionString(new String[]{pieces[0], pieces[2], pieces[1]});
                }
                if (type.equals(VersionedValue.REMOVAL_COORDINATOR) || type.equals(VersionedValue.REMOVING_TOKEN) || type.equals(VersionedValue.REMOVED_TOKEN)) {
                    throw new RuntimeException(String.format("Unable to serialize %s(%s...) for nodes older than 1.2", VersionedValue.class.getName(), type));
                }
            }
            return outValue;
        }

        @Override
        public VersionedValue deserialize(DataInput dis, int version) throws IOException {
            String value = dis.readUTF();
            int valVersion = dis.readInt();
            return new VersionedValue(value, valVersion);
        }

        @Override
        public long serializedSize(VersionedValue value, int version) {
            return TypeSizes.NATIVE.sizeof(this.outValue(value, version)) + TypeSizes.NATIVE.sizeof(value.version);
        }
    }

    public static class VersionedValueFactory {
        final IPartitioner partitioner;

        public VersionedValueFactory(IPartitioner partitioner) {
            this.partitioner = partitioner;
        }

        public VersionedValue bootstrapping(Collection<Token> tokens) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.STATUS_BOOTSTRAPPING, this.makeTokenString(tokens)}));
        }

        public VersionedValue normal(Collection<Token> tokens) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.STATUS_NORMAL, this.makeTokenString(tokens)}));
        }

        private String makeTokenString(Collection<Token> tokens) {
            return this.partitioner.getTokenFactory().toString((Token)Iterables.get(tokens, (int)0));
        }

        public VersionedValue load(double load) {
            return new VersionedValue(String.valueOf(load));
        }

        public VersionedValue schema(UUID newVersion) {
            return new VersionedValue(newVersion.toString());
        }

        public VersionedValue leaving(Collection<Token> tokens) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.STATUS_LEAVING, this.makeTokenString(tokens)}));
        }

        public VersionedValue left(Collection<Token> tokens, long expireTime) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.STATUS_LEFT, this.makeTokenString(tokens), Long.toString(expireTime)}));
        }

        public VersionedValue moving(Token token) {
            return new VersionedValue("MOVING," + this.partitioner.getTokenFactory().toString(token));
        }

        public VersionedValue hostId(UUID hostId) {
            return new VersionedValue(hostId.toString());
        }

        public VersionedValue tokens(Collection<Token> tokens) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                TokenSerializer.serialize(this.partitioner, tokens, dos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new VersionedValue(new String(bos.toByteArray(), Charsets.ISO_8859_1));
        }

        public VersionedValue removingNonlocal(UUID hostId) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.REMOVING_TOKEN, hostId.toString()}));
        }

        public VersionedValue removedNonlocal(UUID hostId, long expireTime) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.REMOVED_TOKEN, hostId.toString(), Long.toString(expireTime)}));
        }

        public VersionedValue removalCoordinator(UUID hostId) {
            return new VersionedValue(VersionedValue.versionString(new String[]{VersionedValue.REMOVAL_COORDINATOR, hostId.toString()}));
        }

        public VersionedValue hibernate(boolean value) {
            return new VersionedValue("hibernate," + value);
        }

        public VersionedValue datacenter(String dcId) {
            return new VersionedValue(dcId);
        }

        public VersionedValue rack(String rackId) {
            return new VersionedValue(rackId);
        }

        public VersionedValue rpcaddress(InetAddress endpoint) {
            return new VersionedValue(endpoint.getHostAddress());
        }

        public VersionedValue releaseVersion() {
            return new VersionedValue(FBUtilities.getReleaseVersionString());
        }

        public VersionedValue networkVersion() {
            return new VersionedValue(String.valueOf(6));
        }

        public VersionedValue internalIP(String private_ip) {
            return new VersionedValue(private_ip);
        }

        public VersionedValue severity(double value) {
            return new VersionedValue(String.valueOf(value));
        }
    }
}

