/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.utils.BoundedStatsDeque;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArrivalWindow {
    private static final Logger logger = LoggerFactory.getLogger(ArrivalWindow.class);
    private double tLast = 0.0;
    private final BoundedStatsDeque arrivalIntervals;
    private final int MAX_INTERVAL_IN_MS = ArrivalWindow.getMaxInterval();

    ArrivalWindow(int size) {
        this.arrivalIntervals = new BoundedStatsDeque(size);
    }

    private static int getMaxInterval() {
        String newvalue = System.getProperty("cassandra.fd_max_interval_ms");
        if (newvalue != null) {
            logger.info("Overriding FD MAX_INTERVAL to {}ms", (Object)newvalue);
            return Integer.parseInt(newvalue);
        }
        return FailureDetector.INITIAL_VALUE;
    }

    synchronized void add(double value) {
        if (this.tLast > 0.0) {
            double interArrivalTime = value - this.tLast;
            if (interArrivalTime <= (double)this.MAX_INTERVAL_IN_MS) {
                this.arrivalIntervals.add(interArrivalTime);
            } else {
                logger.debug("Ignoring interval time of {}", (Object)interArrivalTime);
            }
        } else {
            this.arrivalIntervals.add(FailureDetector.INITIAL_VALUE);
        }
        this.tLast = value;
    }

    double mean() {
        return this.arrivalIntervals.mean();
    }

    double phi(long tnow) {
        assert (this.arrivalIntervals.size() > 0 && this.tLast > 0.0);
        double t = (double)tnow - this.tLast;
        return t / this.mean();
    }

    public String toString() {
        return StringUtils.join(this.arrivalIntervals.iterator(), (String)" ");
    }
}

