/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AtomicDouble;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.cassandra.auth.Auth;
import org.apache.cassandra.concurrent.DebuggableScheduledThreadPoolExecutor;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.concurrent.TracingAwareExecutorService;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.BatchlogManager;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CounterMutationVerbHandler;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DefinitionsUpdateVerbHandler;
import org.apache.cassandra.db.HintedHandOffManager;
import org.apache.cassandra.db.MigrationRequestVerbHandler;
import org.apache.cassandra.db.ReadRepairVerbHandler;
import org.apache.cassandra.db.ReadVerbHandler;
import org.apache.cassandra.db.RowMutationVerbHandler;
import org.apache.cassandra.db.SchemaCheckVerbHandler;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.TruncateVerbHandler;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.dht.BootStrapper;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RangeStreamer;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.StringToken;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.GossipDigestAck2VerbHandler;
import org.apache.cassandra.gms.GossipDigestAckVerbHandler;
import org.apache.cassandra.gms.GossipDigestSynVerbHandler;
import org.apache.cassandra.gms.GossipShutdownVerbHandler;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetector;
import org.apache.cassandra.gms.TokenSerializer;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.io.sstable.SSTableDeletingTask;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.DynamicEndpointSnitch;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.metrics.StorageMetrics;
import org.apache.cassandra.net.IAsyncResult;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.ResponseVerbHandler;
import org.apache.cassandra.service.AntiEntropyService;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.IEndpointLifecycleSubscriber;
import org.apache.cassandra.service.IndexScanVerbHandler;
import org.apache.cassandra.service.LoadBroadcaster;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.PBSPredictor;
import org.apache.cassandra.service.PendingRangeCalculatorService;
import org.apache.cassandra.service.RangeSliceVerbHandler;
import org.apache.cassandra.service.ScheduledRangeTransferExecutorService;
import org.apache.cassandra.service.SnapshotVerbHandler;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.streaming.IStreamCallback;
import org.apache.cassandra.streaming.OperationType;
import org.apache.cassandra.streaming.ReplicationFinishedVerbHandler;
import org.apache.cassandra.streaming.StreamIn;
import org.apache.cassandra.streaming.StreamOut;
import org.apache.cassandra.streaming.StreamReplyVerbHandler;
import org.apache.cassandra.streaming.StreamRequestVerbHandler;
import org.apache.cassandra.streaming.StreamingRepairTask;
import org.apache.cassandra.streaming.StreamingService;
import org.apache.cassandra.thrift.EndpointDetails;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.CounterId;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageService
extends NotificationBroadcasterSupport
implements IEndpointStateChangeSubscriber,
StorageServiceMBean {
    private static final Logger logger = LoggerFactory.getLogger(StorageService.class);
    public static final int RING_DELAY = StorageService.getRingDelay();
    private final AtomicLong notificationSerialNumber = new AtomicLong();
    private final AtomicDouble severity = new AtomicDouble();
    public static final DebuggableScheduledThreadPoolExecutor scheduledTasks = new DebuggableScheduledThreadPoolExecutor("ScheduledTasks");
    public static final DebuggableScheduledThreadPoolExecutor tasks = new DebuggableScheduledThreadPoolExecutor("NonPeriodicTasks");
    public static final DebuggableScheduledThreadPoolExecutor optionalTasks = new DebuggableScheduledThreadPoolExecutor("OptionalTasks");
    private TokenMetadata tokenMetadata = new TokenMetadata();
    public VersionedValue.VersionedValueFactory valueFactory = new VersionedValue.VersionedValueFactory(StorageService.getPartitioner());
    public static final StorageService instance;
    private static final StorageMetrics metrics;
    private final Set<InetAddress> replicatingNodes = Collections.synchronizedSet(new HashSet());
    private CassandraDaemon daemon;
    private InetAddress removingNode;
    private boolean isBootstrapMode;
    private boolean isSurveyMode = Boolean.parseBoolean(System.getProperty("cassandra.write_survey", "false"));
    private boolean isClientMode;
    private boolean initialized;
    private volatile boolean joined = false;
    private double tracingProbability = 0.0;
    private Mode operationMode;
    private final MigrationManager migrationManager = MigrationManager.instance;
    private volatile int totalCFs;
    private volatile int remainingCFs;
    private static final AtomicInteger nextRepairCommand;
    private static ScheduledRangeTransferExecutorService rangeXferExecutor;
    private final List<IEndpointLifecycleSubscriber> lifecycleSubscribers = new CopyOnWriteArrayList<IEndpointLifecycleSubscriber>();
    private final ObjectName jmxObjectName;

    private static int getRingDelay() {
        String newdelay = System.getProperty("cassandra.ring_delay_ms");
        if (newdelay != null) {
            logger.info("Overriding RING_DELAY to {}ms", (Object)newdelay);
            return Integer.parseInt(newdelay);
        }
        return 30000;
    }

    public static IPartitioner getPartitioner() {
        return DatabaseDescriptor.getPartitioner();
    }

    public Collection<Range<Token>> getLocalRanges(String table) {
        return this.getRangesForEndpoint(table, FBUtilities.getBroadcastAddress());
    }

    public Collection<Range<Token>> getLocalPrimaryRanges(String keyspace) {
        return this.getPrimaryRangesForEndpoint(keyspace, FBUtilities.getBroadcastAddress());
    }

    @Deprecated
    public Range<Token> getLocalPrimaryRange() {
        return this.getPrimaryRangeForEndpoint(FBUtilities.getBroadcastAddress());
    }

    @Override
    public List<String> getPrimaryRange() {
        return this.getLocalPrimaryRange().asList();
    }

    public void finishBootstrapping() {
        this.isBootstrapMode = false;
    }

    public void setTokens(Collection<Token> tokens) {
        if (logger.isDebugEnabled()) {
            logger.debug("Setting tokens to {}", tokens);
        }
        SystemTable.updateTokens(tokens);
        this.tokenMetadata.updateNormalTokens(tokens, FBUtilities.getBroadcastAddress());
        Gossiper.instance.addLocalApplicationState(ApplicationState.TOKENS, this.valueFactory.tokens(this.getLocalTokens()));
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.normal(this.getLocalTokens()));
        this.setMode(Mode.NORMAL, false);
    }

    public StorageService() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            this.jmxObjectName = new ObjectName("org.apache.cassandra.db:type=StorageService");
            mbs.registerMBean(this, this.jmxObjectName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.MUTATION, new RowMutationVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.READ_REPAIR, new ReadRepairVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.READ, new ReadVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.RANGE_SLICE, new RangeSliceVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.INDEX_SCAN, new IndexScanVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.COUNTER_MUTATION, new CounterMutationVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.TRUNCATE, new TruncateVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.BOOTSTRAP_TOKEN, new BootStrapper.BootstrapTokenVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.STREAM_REQUEST, new StreamRequestVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.STREAM_REPLY, new StreamReplyVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.REPLICATION_FINISHED, new ReplicationFinishedVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.REQUEST_RESPONSE, new ResponseVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.INTERNAL_RESPONSE, new ResponseVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.TREE_REQUEST, new AntiEntropyService.TreeRequestVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.TREE_RESPONSE, new AntiEntropyService.TreeResponseVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.STREAMING_REPAIR_REQUEST, new StreamingRepairTask.StreamingRepairRequest());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.STREAMING_REPAIR_RESPONSE, new StreamingRepairTask.StreamingRepairResponse());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.GOSSIP_SHUTDOWN, new GossipShutdownVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.GOSSIP_DIGEST_SYN, new GossipDigestSynVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.GOSSIP_DIGEST_ACK, new GossipDigestAckVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.GOSSIP_DIGEST_ACK2, new GossipDigestAck2VerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.DEFINITIONS_UPDATE, new DefinitionsUpdateVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.SCHEMA_CHECK, new SchemaCheckVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.MIGRATION_REQUEST, new MigrationRequestVerbHandler());
        MessagingService.instance().registerVerbHandlers(MessagingService.Verb.SNAPSHOT, new SnapshotVerbHandler());
        if (StreamingService.instance == null) {
            throw new RuntimeException("Streaming service is unavailable.");
        }
    }

    public void registerDaemon(CassandraDaemon daemon) {
        this.daemon = daemon;
    }

    public void register(IEndpointLifecycleSubscriber subscriber) {
        this.lifecycleSubscribers.add(subscriber);
    }

    public void unregister(IEndpointLifecycleSubscriber subscriber) {
        this.lifecycleSubscribers.remove(subscriber);
    }

    @Override
    public void stopGossiping() {
        if (this.initialized) {
            logger.warn("Stopping gossip by operator request");
            Gossiper.instance.stop();
            this.initialized = false;
        }
    }

    @Override
    public void startGossiping() {
        if (!this.initialized) {
            logger.warn("Starting gossip by operator request");
            Gossiper.instance.start((int)(System.currentTimeMillis() / 1000L));
            this.initialized = true;
        }
    }

    @Override
    public void startRPCServer() {
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        this.daemon.thriftServer.start();
    }

    @Override
    public void stopRPCServer() {
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        if (this.daemon.thriftServer != null) {
            this.daemon.thriftServer.stop();
        }
    }

    @Override
    public boolean isRPCServerRunning() {
        if (this.daemon == null || this.daemon.thriftServer == null) {
            return false;
        }
        return this.daemon.thriftServer.isRunning();
    }

    @Override
    public void startNativeTransport() {
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        try {
            this.daemon.nativeServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Error starting native transport: " + e.getMessage());
        }
    }

    @Override
    public void stopNativeTransport() {
        if (this.daemon == null) {
            throw new IllegalStateException("No configured daemon");
        }
        if (this.daemon.nativeServer != null) {
            this.daemon.nativeServer.stop();
        }
    }

    @Override
    public boolean isNativeTransportRunning() {
        if (this.daemon == null || this.daemon.nativeServer == null) {
            return false;
        }
        return this.daemon.nativeServer.isRunning();
    }

    private void shutdownClientServers() {
        this.stopRPCServer();
        this.stopNativeTransport();
    }

    public void stopClient() {
        Gossiper.instance.unregister(this.migrationManager);
        Gossiper.instance.unregister(this);
        Gossiper.instance.stop();
        MessagingService.instance().shutdown();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        StageManager.shutdownNow();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized Collection<Token> prepareReplacementInfo() throws ConfigurationException {
        logger.info("Gathering node replacement information for {}", (Object)DatabaseDescriptor.getReplaceAddress());
        MessagingService.instance().listen(FBUtilities.getLocalAddress());
        Gossiper.instance.doShadowRound();
        UUID hostId = null;
        if (Gossiper.instance.getEndpointStateForEndpoint(DatabaseDescriptor.getReplaceAddress()) == null) {
            throw new RuntimeException("Cannot replace_address " + DatabaseDescriptor.getReplaceAddress() + " because it doesn't exist in gossip");
        }
        hostId = Gossiper.instance.getHostId(DatabaseDescriptor.getReplaceAddress());
        try {
            if (Gossiper.instance.getEndpointStateForEndpoint(DatabaseDescriptor.getReplaceAddress()).getApplicationState(ApplicationState.TOKENS) == null) {
                throw new RuntimeException("Could not find tokens for " + DatabaseDescriptor.getReplaceAddress() + " to replace");
            }
            Collection<Token> tokens = TokenSerializer.deserialize(StorageService.getPartitioner(), new DataInputStream(new ByteArrayInputStream(this.getApplicationStateValue(DatabaseDescriptor.getReplaceAddress(), ApplicationState.TOKENS))));
            SystemTable.setLocalHostId(hostId);
            MessagingService.instance().shutdown();
            Gossiper.instance.resetEndpointStateMap();
            return tokens;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void initClient() throws IOException, ConfigurationException {
        this.initClient(0);
        try {
            block2: while (true) {
                InetAddress address;
                Thread.sleep(1000L);
                Iterator<InetAddress> i$ = Gossiper.instance.getLiveMembers().iterator();
                do {
                    if (!i$.hasNext()) continue block2;
                } while (Gossiper.instance.isFatClient(address = i$.next()));
                break;
            }
            while (!MigrationManager.isReadyForBootstrap()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public synchronized void initClient(int ringDelay) throws IOException, ConfigurationException {
        if (this.initialized) {
            if (!this.isClientMode) {
                throw new UnsupportedOperationException("StorageService does not support switching modes.");
            }
            return;
        }
        this.initialized = true;
        this.isClientMode = true;
        logger.info("Starting up client gossip");
        this.setMode(Mode.CLIENT, false);
        Gossiper.instance.register(this);
        Gossiper.instance.register(this.migrationManager);
        Gossiper.instance.start((int)(System.currentTimeMillis() / 1000L));
        Gossiper.instance.addLocalApplicationState(ApplicationState.NET_VERSION, this.valueFactory.networkVersion());
        MessagingService.instance().listen(FBUtilities.getLocalAddress());
        try {
            Thread.sleep(ringDelay);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public synchronized void initServer() throws ConfigurationException {
        this.initServer(RING_DELAY);
    }

    public synchronized void initServer(int delay) throws ConfigurationException {
        logger.info("Cassandra version: " + FBUtilities.getReleaseVersionString());
        logger.info("Thrift API version: 19.36.2");
        logger.info("CQL supported versions: " + StringUtils.join((Object[])ClientState.getCQLSupportedVersion(), (String)",") + " (default: " + ClientState.DEFAULT_CQL_VERSION + ")");
        if (this.initialized) {
            if (this.isClientMode) {
                throw new UnsupportedOperationException("StorageService does not support switching modes.");
            }
            return;
        }
        this.initialized = true;
        this.isClientMode = false;
        try {
            Class.forName("org.apache.cassandra.service.StorageProxy");
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        PBSPredictor.instance().init();
        if (Boolean.parseBoolean(System.getProperty("cassandra.load_ring_state", "true"))) {
            logger.info("Loading persisted ring state");
            SetMultimap<InetAddress, Token> loadedTokens = SystemTable.loadTokens();
            Map<InetAddress, UUID> loadedHostIds = SystemTable.loadHostIds();
            for (InetAddress ep : loadedTokens.keySet()) {
                if (ep.equals(FBUtilities.getBroadcastAddress())) {
                    SystemTable.removeEndpoint(ep);
                    continue;
                }
                this.tokenMetadata.updateNormalTokens(loadedTokens.get((Object)ep), ep);
                if (loadedHostIds.containsKey(ep)) {
                    this.tokenMetadata.updateHostId(loadedHostIds.get(ep), ep);
                }
                Gossiper.instance.addSavedEndpoint(ep);
            }
        }
        if (Boolean.parseBoolean(System.getProperty("cassandra.renew_counter_id", "false"))) {
            logger.info("Renewing local node id (as requested)");
            CounterId.renewLocalId();
        }
        Thread drainOnShutdown = new Thread((Runnable)new WrappedRunnable(){

            @Override
            public void runMayThrow() throws ExecutionException, InterruptedException, IOException {
                TracingAwareExecutorService mutationStage = StageManager.getStage(Stage.MUTATION);
                if (mutationStage.isShutdown()) {
                    return;
                }
                StorageService.this.shutdownClientServers();
                optionalTasks.shutdown();
                Gossiper.instance.stop();
                MessagingService.instance().shutdown();
                mutationStage.shutdown();
                mutationStage.awaitTermination(3600L, TimeUnit.SECONDS);
                StorageProxy.instance.verifyNoHintsInProgress();
                ArrayList flushes = new ArrayList();
                for (Table table : Table.all()) {
                    KSMetaData ksm = Schema.instance.getKSMetaData(table.name);
                    if (ksm.durableWrites) continue;
                    for (ColumnFamilyStore cfs : table.getColumnFamilyStores()) {
                        flushes.add(cfs.forceFlush());
                    }
                }
                FBUtilities.waitOnFutures(flushes);
                CommitLog.instance.shutdownBlocking();
                tasks.shutdown();
                if (!tasks.awaitTermination(1L, TimeUnit.MINUTES)) {
                    logger.warn("Miscellaneous task executor still busy after one minute; proceeding with shutdown");
                }
            }
        }, "StorageServiceShutdownHook");
        Runtime.getRuntime().addShutdownHook(drainOnShutdown);
        if (Boolean.parseBoolean(System.getProperty("cassandra.join_ring", "true"))) {
            this.joinTokenRing(delay);
        } else {
            logger.info("Not joining ring as requested. Use JMX (StorageService->joinRing()) to initiate ring joining");
        }
    }

    private void joinTokenRing(int delay) throws ConfigurationException {
        this.joined = true;
        Collection<Token> tokens = null;
        HashMap<ApplicationState, VersionedValue> appStates = new HashMap<ApplicationState, VersionedValue>();
        if (DatabaseDescriptor.getReplaceTokens().size() > 0 || DatabaseDescriptor.getReplaceNode() != null) {
            throw new RuntimeException("Replace method removed; use cassandra.replace_address instead");
        }
        if (DatabaseDescriptor.isReplacing()) {
            if (!DatabaseDescriptor.isAutoBootstrap()) {
                throw new RuntimeException("Trying to replace_address with auto_bootstrap disabled will not work, check your configuration");
            }
            tokens = this.prepareReplacementInfo();
            appStates.put(ApplicationState.STATUS, this.valueFactory.hibernate(true));
            appStates.put(ApplicationState.TOKENS, this.valueFactory.tokens(tokens));
        }
        this.getTokenMetadata().updateHostId(SystemTable.getLocalHostId(), FBUtilities.getBroadcastAddress());
        appStates.put(ApplicationState.NET_VERSION, this.valueFactory.networkVersion());
        appStates.put(ApplicationState.HOST_ID, this.valueFactory.hostId(SystemTable.getLocalHostId()));
        appStates.put(ApplicationState.RPC_ADDRESS, this.valueFactory.rpcaddress(DatabaseDescriptor.getRpcAddress()));
        appStates.put(ApplicationState.RELEASE_VERSION, this.valueFactory.releaseVersion());
        logger.info("Starting up server gossip");
        Gossiper.instance.register(this);
        Gossiper.instance.register(this.migrationManager);
        Gossiper.instance.start(SystemTable.incrementAndGetGeneration(), appStates);
        this.gossipSnitchInfo();
        Schema.instance.updateVersionAndAnnounce();
        MessagingService.instance().listen(FBUtilities.getLocalAddress());
        LoadBroadcaster.instance.startBroadcasting();
        HintedHandOffManager.instance.start();
        BatchlogManager.instance.start();
        HashSet<InetAddress> current = new HashSet<InetAddress>();
        logger.debug("Bootstrap variables: {} {} {} {}", new Object[]{DatabaseDescriptor.isAutoBootstrap(), SystemTable.bootstrapInProgress(), SystemTable.bootstrapComplete(), DatabaseDescriptor.getSeeds().contains(FBUtilities.getBroadcastAddress())});
        if (DatabaseDescriptor.isAutoBootstrap() && !SystemTable.bootstrapComplete() && !DatabaseDescriptor.getSeeds().contains(FBUtilities.getBroadcastAddress())) {
            if (SystemTable.bootstrapInProgress()) {
                logger.warn("Detected previous bootstrap failure; retrying");
            } else {
                SystemTable.setBootstrapState(SystemTable.BootstrapState.IN_PROGRESS);
            }
            this.setMode(Mode.JOINING, "waiting for ring information", true);
            for (int i = 0; i < delay; i += 1000) {
                if (!Schema.instance.getVersion().equals(Schema.emptyVersion)) {
                    logger.debug("got schema: {}", (Object)Schema.instance.getVersion());
                    break;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            }
            while (!MigrationManager.isReadyForBootstrap()) {
                this.setMode(Mode.JOINING, "waiting for schema information to complete", true);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            }
            this.setMode(Mode.JOINING, "schema complete, ready to bootstrap", true);
            this.setMode(Mode.JOINING, "waiting for pending range calculation", true);
            PendingRangeCalculatorService.instance.blockUntilFinished();
            this.setMode(Mode.JOINING, "calculation complete, ready to bootstrap", true);
            if (logger.isDebugEnabled()) {
                logger.debug("... got ring + schema info");
            }
            if (!DatabaseDescriptor.isReplacing()) {
                if (this.tokenMetadata.isMember(FBUtilities.getBroadcastAddress())) {
                    String s = "This node is already a member of the token ring; bootstrap aborted. (If replacing a dead node, remove the old one from the ring first.)";
                    throw new UnsupportedOperationException(s);
                }
                this.setMode(Mode.JOINING, "getting bootstrap token", true);
                tokens = BootStrapper.getBootstrapTokens(this.tokenMetadata, LoadBroadcaster.instance.getLoadInfo());
            } else {
                if (!DatabaseDescriptor.getReplaceAddress().equals(FBUtilities.getBroadcastAddress())) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e) {
                        throw new AssertionError((Object)e);
                    }
                    for (Token token : tokens) {
                        InetAddress existing = this.tokenMetadata.getEndpoint(token);
                        if (existing != null) {
                            if (Gossiper.instance.getEndpointStateForEndpoint(existing).getUpdateTimestamp() > System.currentTimeMillis() - (long)delay) {
                                throw new UnsupportedOperationException("Cannnot replace a live node... ");
                            }
                            current.add(existing);
                            continue;
                        }
                        throw new UnsupportedOperationException("Cannot replace token " + token + " which does not exist!");
                    }
                }
                this.setMode(Mode.JOINING, "Replacing a node with token(s): " + tokens, true);
            }
            this.bootstrap(tokens);
            assert (!this.isBootstrapMode);
        } else {
            tokens = SystemTable.getSavedTokens();
            if (tokens.isEmpty()) {
                Collection<String> initialTokens = DatabaseDescriptor.getInitialTokens();
                if (initialTokens.size() < 1) {
                    tokens = BootStrapper.getRandomTokens(this.tokenMetadata, DatabaseDescriptor.getNumTokens());
                    if (DatabaseDescriptor.getNumTokens() == 1) {
                        logger.warn("Generated random token " + tokens + ". Random tokens will result in an unbalanced ring; see http://wiki.apache.org/cassandra/Operations");
                    } else {
                        logger.info("Generated random tokens. tokens are {}", tokens);
                    }
                } else {
                    tokens = new ArrayList<Token>();
                    for (String token : initialTokens) {
                        tokens.add(StorageService.getPartitioner().getTokenFactory().fromString(token));
                    }
                    logger.info("Saved token not found. Using " + tokens + " from configuration");
                }
            } else if (tokens.size() == 1 && DatabaseDescriptor.getNumTokens() > 1) {
                logger.info("Sleeping for ring delay (" + delay + "ms)");
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                logger.info("Calculating new tokens");
                Token right = tokens.iterator().next();
                TokenMetadata clone = this.tokenMetadata.cloneOnlyTokenMap();
                clone.updateNormalToken(right, FBUtilities.getBroadcastAddress());
                Token left = clone.getPredecessor(right);
                for (int tok = 1; tok < DatabaseDescriptor.getNumTokens(); ++tok) {
                    Token l = left;
                    Token r = right;
                    double frac = (double)tok / (double)DatabaseDescriptor.getNumTokens().intValue();
                    Token midpoint = StorageService.getPartitioner().midpoint(l, r);
                    for (int i = 0; i < 53 && (frac *= 2.0) != 1.0; ++i) {
                        if (frac > 1.0) {
                            l = midpoint;
                            frac -= 1.0;
                        } else {
                            r = midpoint;
                        }
                        midpoint = StorageService.getPartitioner().midpoint(l, r);
                    }
                    tokens.add(midpoint);
                }
                logger.info("Split previous range (" + left + ", " + right + "] into " + tokens);
            } else {
                logger.info("Using saved token " + tokens);
            }
        }
        if (!this.isSurveyMode) {
            SystemTable.setBootstrapState(SystemTable.BootstrapState.COMPLETED);
            this.setTokens(tokens);
            if (!current.isEmpty()) {
                for (InetAddress existing : current) {
                    Gossiper.instance.replacedEndpoint(existing);
                }
            }
            logger.info("Startup completed! Now serving reads.");
            assert (this.tokenMetadata.sortedTokens().size() > 0);
            Auth.setup();
        } else {
            logger.info("Startup complete, but write survey mode is active, not becoming an active ring member. Use JMX (StorageService->joinRing()) to finalize ring joining.");
        }
    }

    public void gossipSnitchInfo() {
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        String dc = snitch.getDatacenter(FBUtilities.getBroadcastAddress());
        String rack = snitch.getRack(FBUtilities.getBroadcastAddress());
        Gossiper.instance.addLocalApplicationState(ApplicationState.DC, StorageService.instance.valueFactory.datacenter(dc));
        Gossiper.instance.addLocalApplicationState(ApplicationState.RACK, StorageService.instance.valueFactory.rack(rack));
    }

    @Override
    public synchronized void joinRing() throws IOException {
        if (!this.joined) {
            logger.info("Joining ring by operator request");
            try {
                this.joinTokenRing(0);
            }
            catch (ConfigurationException e) {
                throw new IOException(e.getMessage());
            }
        } else if (this.isSurveyMode) {
            this.setTokens(SystemTable.getSavedTokens());
            SystemTable.setBootstrapState(SystemTable.BootstrapState.COMPLETED);
            this.isSurveyMode = false;
            logger.info("Leaving write survey mode and joining ring at operator request");
            assert (this.tokenMetadata.sortedTokens().size() > 0);
            Auth.setup();
        }
    }

    @Override
    public boolean isJoined() {
        return this.joined;
    }

    @Override
    public void rebuild(String sourceDc) {
        logger.info("rebuild from dc: {}", (Object)(sourceDc == null ? "(any dc)" : sourceDc));
        RangeStreamer streamer = new RangeStreamer(this.tokenMetadata, FBUtilities.getBroadcastAddress(), OperationType.REBUILD);
        streamer.addSourceFilter(new RangeStreamer.FailureDetectorSourceFilter(FailureDetector.instance));
        if (sourceDc != null) {
            streamer.addSourceFilter(new RangeStreamer.SingleDatacenterFilter(DatabaseDescriptor.getEndpointSnitch(), sourceDc));
        }
        for (String table : Schema.instance.getNonSystemTables()) {
            streamer.addRanges(table, this.getLocalRanges(table));
        }
        streamer.fetch();
    }

    @Override
    public void setStreamThroughputMbPerSec(int value) {
        DatabaseDescriptor.setStreamThroughputOutboundMegabitsPerSec(value);
        logger.info("setstreamthroughput: throttle set to {}", (Object)value);
    }

    @Override
    public int getStreamThroughputMbPerSec() {
        return DatabaseDescriptor.getStreamThroughputOutboundMegabitsPerSec();
    }

    @Override
    public int getCompactionThroughputMbPerSec() {
        return DatabaseDescriptor.getCompactionThroughputMbPerSec();
    }

    @Override
    public void setCompactionThroughputMbPerSec(int value) {
        DatabaseDescriptor.setCompactionThroughputMbPerSec(value);
    }

    @Override
    public boolean isIncrementalBackupsEnabled() {
        return DatabaseDescriptor.isIncrementalBackupsEnabled();
    }

    @Override
    public void setIncrementalBackupsEnabled(boolean value) {
        DatabaseDescriptor.setIncrementalBackupsEnabled(value);
    }

    private void setMode(Mode m, boolean log) {
        this.setMode(m, null, log);
    }

    private void setMode(Mode m, String msg, boolean log) {
        String logMsg;
        this.operationMode = m;
        String string = logMsg = msg == null ? m.toString() : String.format("%s: %s", new Object[]{m, msg});
        if (log) {
            logger.info(logMsg);
        } else {
            logger.debug(logMsg);
        }
    }

    private void bootstrap(Collection<Token> tokens) {
        this.isBootstrapMode = true;
        SystemTable.updateTokens(tokens);
        if (!DatabaseDescriptor.isReplacing()) {
            Gossiper.instance.addLocalApplicationState(ApplicationState.TOKENS, this.valueFactory.tokens(tokens));
            Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.bootstrapping(tokens));
            this.setMode(Mode.JOINING, "sleeping " + RING_DELAY + " ms for pending range setup", true);
            try {
                Thread.sleep(RING_DELAY);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            this.tokenMetadata.updateNormalTokens(tokens, FBUtilities.getBroadcastAddress());
            SystemTable.removeEndpoint(DatabaseDescriptor.getReplaceAddress());
        }
        Tracing.instance();
        if (!Gossiper.instance.seenAnySeed()) {
            throw new IllegalStateException("Unable to contact any seeds!");
        }
        this.setMode(Mode.JOINING, "Starting to bootstrap...", true);
        new BootStrapper(FBUtilities.getBroadcastAddress(), tokens, this.tokenMetadata).bootstrap();
        logger.info("Bootstrap completed! for the tokens {}", tokens);
    }

    public boolean isBootstrapMode() {
        return this.isBootstrapMode;
    }

    public TokenMetadata getTokenMetadata() {
        return this.tokenMetadata;
    }

    public boolean reportSeverity(double incr) {
        if (!Gossiper.instance.isEnabled()) {
            return false;
        }
        VersionedValue updated = StorageService.instance.valueFactory.severity(this.severity.addAndGet(incr));
        Gossiper.instance.addLocalApplicationState(ApplicationState.SEVERITY, updated);
        return true;
    }

    public double getSeverity(InetAddress endpoint) {
        VersionedValue event;
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state != null && (event = state.getApplicationState(ApplicationState.SEVERITY)) != null) {
            return Double.parseDouble(event.value);
        }
        return 0.0;
    }

    @Override
    public Map<List<String>, List<String>> getRangeToEndpointMap(String keyspace) {
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        for (Map.Entry<Range<Token>, List<InetAddress>> entry : this.getRangeToAddressMap(keyspace).entrySet()) {
            map.put(entry.getKey().asList(), this.stringify((Iterable<InetAddress>)entry.getValue()));
        }
        return map;
    }

    public String getRpcaddress(InetAddress endpoint) {
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            return DatabaseDescriptor.getRpcAddress().getHostAddress();
        }
        if (Gossiper.instance.getEndpointStateForEndpoint(endpoint).getApplicationState(ApplicationState.RPC_ADDRESS) == null) {
            return endpoint.getHostAddress();
        }
        return Gossiper.instance.getEndpointStateForEndpoint((InetAddress)endpoint).getApplicationState((ApplicationState)ApplicationState.RPC_ADDRESS).value;
    }

    @Override
    public Map<List<String>, List<String>> getRangeToRpcaddressMap(String keyspace) {
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        for (Map.Entry<Range<Token>, List<InetAddress>> entry : this.getRangeToAddressMap(keyspace).entrySet()) {
            ArrayList<String> rpcaddrs = new ArrayList<String>(entry.getValue().size());
            for (InetAddress endpoint : entry.getValue()) {
                rpcaddrs.add(this.getRpcaddress(endpoint));
            }
            map.put(entry.getKey().asList(), rpcaddrs);
        }
        return map;
    }

    @Override
    public Map<List<String>, List<String>> getPendingRangeToEndpointMap(String keyspace) {
        if (keyspace == null) {
            keyspace = Schema.instance.getNonSystemTables().get(0);
        }
        HashMap<List<String>, List<String>> map = new HashMap<List<String>, List<String>>();
        for (Map.Entry<Range<Token>, Collection<InetAddress>> entry : this.tokenMetadata.getPendingRanges(keyspace).entrySet()) {
            ArrayList<InetAddress> l = new ArrayList<InetAddress>(entry.getValue());
            map.put(entry.getKey().asList(), this.stringify(l));
        }
        return map;
    }

    public Map<Range<Token>, List<InetAddress>> getRangeToAddressMap(String keyspace) {
        return this.getRangeToAddressMap(keyspace, this.tokenMetadata.sortedTokens());
    }

    public Map<Range<Token>, List<InetAddress>> getRangeToAddressMapInLocalDC(String keyspace) {
        Predicate<InetAddress> isLocalDC = new Predicate<InetAddress>(){

            public boolean apply(InetAddress address) {
                return StorageService.this.isLocalDC(address);
            }
        };
        Map<Range<Token>, List<InetAddress>> origMap = this.getRangeToAddressMap(keyspace, this.getTokensInLocalDC());
        HashMap filteredMap = Maps.newHashMap();
        for (Map.Entry<Range<Token>, List<InetAddress>> entry : origMap.entrySet()) {
            ArrayList endpointsInLocalDC = Lists.newArrayList((Iterable)Collections2.filter((Collection)entry.getValue(), (Predicate)isLocalDC));
            filteredMap.put(entry.getKey(), endpointsInLocalDC);
        }
        return filteredMap;
    }

    private List<Token> getTokensInLocalDC() {
        ArrayList filteredTokens = Lists.newArrayList();
        for (Token token : this.tokenMetadata.sortedTokens()) {
            InetAddress endpoint = this.tokenMetadata.getEndpoint(token);
            if (!this.isLocalDC(endpoint)) continue;
            filteredTokens.add(token);
        }
        return filteredTokens;
    }

    private boolean isLocalDC(InetAddress targetHost) {
        String remoteDC = DatabaseDescriptor.getEndpointSnitch().getDatacenter(targetHost);
        String localDC = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
        return remoteDC.equals(localDC);
    }

    private Map<Range<Token>, List<InetAddress>> getRangeToAddressMap(String keyspace, List<Token> sortedTokens) {
        if (keyspace == null) {
            keyspace = Schema.instance.getNonSystemTables().get(0);
        }
        List<Range<Token>> ranges = this.getAllRanges(sortedTokens);
        return this.constructRangeToEndpointMap(keyspace, ranges);
    }

    @Override
    public List<String> describeRingJMX(String keyspace) throws IOException {
        List<TokenRange> tokenRanges = null;
        try {
            tokenRanges = this.describeRing(keyspace);
        }
        catch (InvalidRequestException e) {
            throw new IOException(e.getMessage());
        }
        ArrayList<String> result = new ArrayList<String>(tokenRanges.size());
        for (TokenRange tokenRange : tokenRanges) {
            result.add(tokenRange.toString());
        }
        return result;
    }

    public List<TokenRange> describeRing(String keyspace) throws InvalidRequestException {
        return this.describeRing(keyspace, false);
    }

    public List<TokenRange> describeLocalRing(String keyspace) throws InvalidRequestException {
        return this.describeRing(keyspace, true);
    }

    private List<TokenRange> describeRing(String keyspace, boolean includeOnlyLocalDC) throws InvalidRequestException {
        if (keyspace == null || Table.open(keyspace).getReplicationStrategy() instanceof LocalStrategy) {
            throw new InvalidRequestException("There is no ring for the keyspace: " + keyspace);
        }
        ArrayList<TokenRange> ranges = new ArrayList<TokenRange>();
        Token.TokenFactory tf = StorageService.getPartitioner().getTokenFactory();
        Map<Range<Token>, List<InetAddress>> rangeToAddressMap = includeOnlyLocalDC ? this.getRangeToAddressMapInLocalDC(keyspace) : this.getRangeToAddressMap(keyspace);
        for (Map.Entry<Range<Token>, List<InetAddress>> entry : rangeToAddressMap.entrySet()) {
            Range<Token> range = entry.getKey();
            List<InetAddress> addresses = entry.getValue();
            ArrayList<String> endpoints = new ArrayList<String>(addresses.size());
            ArrayList<String> rpc_endpoints = new ArrayList<String>(addresses.size());
            ArrayList<EndpointDetails> epDetails = new ArrayList<EndpointDetails>(addresses.size());
            for (InetAddress endpoint : addresses) {
                EndpointDetails details = new EndpointDetails();
                details.host = endpoint.getHostAddress();
                details.datacenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(endpoint);
                details.rack = DatabaseDescriptor.getEndpointSnitch().getRack(endpoint);
                endpoints.add(details.host);
                rpc_endpoints.add(this.getRpcaddress(endpoint));
                epDetails.add(details);
            }
            TokenRange tr = new TokenRange(tf.toString(range.left.getToken()), tf.toString(range.right.getToken()), endpoints).setEndpoint_details(epDetails).setRpc_endpoints(rpc_endpoints);
            ranges.add(tr);
        }
        return ranges;
    }

    @Override
    public Map<String, String> getTokenToEndpointMap() {
        Map<Token, InetAddress> mapInetAddress = this.tokenMetadata.getNormalAndBootstrappingTokenToEndpointMap();
        LinkedHashMap<String, String> mapString = new LinkedHashMap<String, String>(mapInetAddress.size());
        ArrayList<Token> tokens = new ArrayList<Token>(mapInetAddress.keySet());
        Collections.sort(tokens);
        for (Token token : tokens) {
            mapString.put(token.toString(), mapInetAddress.get(token).getHostAddress());
        }
        return mapString;
    }

    @Override
    public String getLocalHostId() {
        return this.getTokenMetadata().getHostId(FBUtilities.getBroadcastAddress()).toString();
    }

    @Override
    public Map<String, String> getHostIdMap() {
        HashMap<String, String> mapOut = new HashMap<String, String>();
        for (Map.Entry<InetAddress, UUID> entry : this.getTokenMetadata().getEndpointToHostIdMapForReading().entrySet()) {
            mapOut.put(entry.getKey().getHostAddress(), entry.getValue().toString());
        }
        return mapOut;
    }

    private Map<Range<Token>, List<InetAddress>> constructRangeToEndpointMap(String keyspace, List<Range<Token>> ranges) {
        HashMap<Range<Token>, List<InetAddress>> rangeToEndpointMap = new HashMap<Range<Token>, List<InetAddress>>();
        for (Range<Token> range : ranges) {
            rangeToEndpointMap.put(range, Table.open(keyspace).getReplicationStrategy().getNaturalEndpoints(range.right));
        }
        return rangeToEndpointMap;
    }

    @Override
    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
        if (state.equals((Object)ApplicationState.STATUS)) {
            String apStateValue = value.value;
            String[] pieces = apStateValue.split(VersionedValue.DELIMITER_STR, -1);
            assert (pieces.length > 0);
            String moveName = pieces[0];
            if (moveName.equals("BOOT")) {
                this.handleStateBootstrap(endpoint, pieces);
            } else if (moveName.equals("NORMAL")) {
                this.handleStateNormal(endpoint, pieces);
            } else if (moveName.equals("removing") || moveName.equals("removed")) {
                this.handleStateRemoving(endpoint, pieces);
            } else if (moveName.equals("LEAVING")) {
                this.handleStateLeaving(endpoint, pieces);
            } else if (moveName.equals("LEFT")) {
                this.handleStateLeft(endpoint, pieces);
            } else if (moveName.equals("MOVING")) {
                this.handleStateMoving(endpoint, pieces);
            } else if (moveName.equals("RELOCATING")) {
                this.handleStateRelocating(endpoint, pieces);
            }
        } else {
            EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
            if (epState == null || Gossiper.instance.isDeadState(epState).booleanValue()) {
                logger.debug("Ignoring state change for dead or unknown endpoint: {}", (Object)endpoint);
                return;
            }
            switch (state) {
                case RELEASE_VERSION: {
                    SystemTable.updatePeerInfo(endpoint, "release_version", this.quote(value.value));
                    break;
                }
                case DC: {
                    SystemTable.updatePeerInfo(endpoint, "data_center", this.quote(value.value));
                    break;
                }
                case RACK: {
                    SystemTable.updatePeerInfo(endpoint, "rack", this.quote(value.value));
                    break;
                }
                case RPC_ADDRESS: {
                    SystemTable.updatePeerInfo(endpoint, "rpc_address", this.quote(value.value));
                    break;
                }
                case SCHEMA: {
                    SystemTable.updatePeerInfo(endpoint, "schema_version", value.value);
                    break;
                }
                case HOST_ID: {
                    SystemTable.updatePeerInfo(endpoint, "host_id", value.value);
                }
            }
        }
    }

    private String quote(String value) {
        return "'" + value + "'";
    }

    private byte[] getApplicationStateValue(InetAddress endpoint, ApplicationState appstate) {
        String vvalue = Gossiper.instance.getEndpointStateForEndpoint((InetAddress)endpoint).getApplicationState((ApplicationState)appstate).value;
        return vvalue.getBytes(Charsets.ISO_8859_1);
    }

    private Collection<Token> getTokensFor(InetAddress endpoint, String piece) {
        if (Gossiper.instance.usesVnodes(endpoint)) {
            try {
                return TokenSerializer.deserialize(StorageService.getPartitioner(), new DataInputStream(new ByteArrayInputStream(this.getApplicationStateValue(endpoint, ApplicationState.TOKENS))));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Arrays.asList(StorageService.getPartitioner().getTokenFactory().fromString(piece));
    }

    private void handleStateBootstrap(InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        Collection<Token> tokens = this.getTokensFor(endpoint, pieces[1]);
        if (logger.isDebugEnabled()) {
            logger.debug("Node " + endpoint + " state bootstrapping, token " + tokens);
        }
        if (this.tokenMetadata.isMember(endpoint)) {
            if (!this.tokenMetadata.isLeaving(endpoint)) {
                logger.info("Node " + endpoint + " state jump to bootstrap");
            }
            this.tokenMetadata.removeEndpoint(endpoint);
        }
        this.tokenMetadata.addBootstrapTokens(tokens, endpoint);
        PendingRangeCalculatorService.instance.update();
        if (Gossiper.instance.usesHostId(endpoint)) {
            this.tokenMetadata.updateHostId(Gossiper.instance.getHostId(endpoint), endpoint);
        }
    }

    private void handleStateNormal(final InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        Collection<Token> tokens = this.getTokensFor(endpoint, pieces[1]);
        HashSet<Token> tokensToUpdateInMetadata = new HashSet<Token>();
        HashSet<Token> tokensToUpdateInSystemTable = new HashSet<Token>();
        HashSet<Token> localTokensToRemove = new HashSet<Token>();
        HashSet<InetAddress> endpointsToRemove = new HashSet<InetAddress>();
        if (logger.isDebugEnabled()) {
            logger.debug("Node " + endpoint + " state normal, token " + tokens);
        }
        if (this.tokenMetadata.isMember(endpoint)) {
            logger.info("Node " + endpoint + " state jump to normal");
        }
        if (Gossiper.instance.usesHostId(endpoint)) {
            UUID hostId = Gossiper.instance.getHostId(endpoint);
            InetAddress existing = this.tokenMetadata.getEndpointForHostId(hostId);
            if (DatabaseDescriptor.isReplacing() && Gossiper.instance.getEndpointStateForEndpoint(DatabaseDescriptor.getReplaceAddress()) != null && hostId.equals(Gossiper.instance.getHostId(DatabaseDescriptor.getReplaceAddress()))) {
                logger.warn("Not updating token metadata for {} because I am replacing it", (Object)endpoint);
            } else if (existing != null && !existing.equals(endpoint)) {
                if (existing.equals(FBUtilities.getBroadcastAddress())) {
                    logger.warn("Not updating host ID {} for {} because it's mine", (Object)hostId, (Object)endpoint);
                    this.tokenMetadata.removeEndpoint(endpoint);
                    endpointsToRemove.add(endpoint);
                } else if (Gossiper.instance.compareEndpointStartup(endpoint, existing) > 0) {
                    logger.warn("Host ID collision for {} between {} and {}; {} is the new owner", new Object[]{hostId, existing, endpoint, endpoint});
                    this.tokenMetadata.removeEndpoint(existing);
                    endpointsToRemove.add(existing);
                    this.tokenMetadata.updateHostId(hostId, endpoint);
                } else {
                    logger.warn("Host ID Collision for {} between {} and {}; ignored {}", new Object[]{hostId, existing, endpoint, endpoint});
                    this.tokenMetadata.removeEndpoint(endpoint);
                    endpointsToRemove.add(endpoint);
                }
            } else {
                this.tokenMetadata.updateHostId(hostId, endpoint);
            }
        }
        for (final Token token : tokens) {
            InetAddress currentOwner = this.tokenMetadata.getEndpoint(token);
            if (currentOwner == null) {
                logger.debug("New node " + endpoint + " at token " + token);
                tokensToUpdateInMetadata.add(token);
                if (this.isClientMode) continue;
                tokensToUpdateInSystemTable.add(token);
                continue;
            }
            if (endpoint.equals(currentOwner)) {
                tokensToUpdateInMetadata.add(token);
                continue;
            }
            if (this.tokenMetadata.isRelocating(token) && this.tokenMetadata.getRelocatingRanges().get(token).equals(endpoint)) {
                tokensToUpdateInMetadata.add(token);
                if (!this.isClientMode) {
                    tokensToUpdateInSystemTable.add(token);
                }
                optionalTasks.schedule(new Runnable(){

                    @Override
                    public void run() {
                        logger.info("Removing RELOCATION state for {} {}", (Object)endpoint, (Object)token);
                        StorageService.this.getTokenMetadata().removeFromRelocating(token, endpoint);
                    }
                }, (long)RING_DELAY, TimeUnit.MILLISECONDS);
                if (currentOwner.equals(FBUtilities.getBroadcastAddress())) {
                    localTokensToRemove.add(token);
                }
                logger.info("Token {} relocated to {}", (Object)token, (Object)endpoint);
                continue;
            }
            if (this.tokenMetadata.isRelocating(token)) {
                logger.info("Token {} is relocating to {}, ignoring update from {}", new Object[]{token, this.tokenMetadata.getRelocatingRanges().get(token), endpoint});
                continue;
            }
            if (Gossiper.instance.compareEndpointStartup(endpoint, currentOwner) > 0) {
                tokensToUpdateInMetadata.add(token);
                if (!this.isClientMode) {
                    tokensToUpdateInSystemTable.add(token);
                }
                Multimap<InetAddress, Token> epToTokenCopy = this.getTokenMetadata().getEndpointToTokenMapForReading();
                epToTokenCopy.get((Object)currentOwner).remove(token);
                if (epToTokenCopy.get((Object)currentOwner).size() < 1) {
                    endpointsToRemove.add(currentOwner);
                }
                logger.info(String.format("Nodes %s and %s have the same token %s.  %s is the new owner", endpoint, currentOwner, token, endpoint));
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Relocating ranges: {}", (Object)this.tokenMetadata.printRelocatingRanges());
                continue;
            }
            logger.info(String.format("Nodes %s and %s have the same token %s.  Ignoring %s", endpoint, currentOwner, token, endpoint));
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Relocating ranges: {}", (Object)this.tokenMetadata.printRelocatingRanges());
        }
        this.tokenMetadata.updateNormalTokens(tokensToUpdateInMetadata, endpoint);
        for (InetAddress ep : endpointsToRemove) {
            this.removeEndpoint(ep);
        }
        if (!tokensToUpdateInSystemTable.isEmpty()) {
            SystemTable.updateTokens(endpoint, tokensToUpdateInSystemTable);
        }
        if (!localTokensToRemove.isEmpty()) {
            SystemTable.updateLocalTokens(Collections.<Token>emptyList(), localTokensToRemove);
        }
        if (this.tokenMetadata.isMoving(endpoint)) {
            this.tokenMetadata.removeFromMoving(endpoint);
            if (!this.isClientMode) {
                for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
                    subscriber.onMove(endpoint);
                }
            }
        }
        PendingRangeCalculatorService.instance.update();
    }

    private void handleStateLeaving(InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        Collection<Token> tokens = this.getTokensFor(endpoint, pieces[1]);
        if (logger.isDebugEnabled()) {
            logger.debug("Node " + endpoint + " state leaving, tokens " + tokens);
        }
        if (!this.tokenMetadata.isMember(endpoint)) {
            logger.info("Node " + endpoint + " state jump to leaving");
            this.tokenMetadata.updateNormalTokens(tokens, endpoint);
        } else if (!this.tokenMetadata.getTokens(endpoint).containsAll(tokens)) {
            logger.warn("Node " + endpoint + " 'leaving' token mismatch. Long network partition?");
            this.tokenMetadata.updateNormalTokens(tokens, endpoint);
        }
        this.tokenMetadata.addLeavingEndpoint(endpoint);
        PendingRangeCalculatorService.instance.update();
    }

    private void handleStateLeft(InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        Integer version = MessagingService.instance().getVersion(endpoint);
        Collection<Token> tokens = this.getTokensFor(endpoint, pieces[1]);
        if (logger.isDebugEnabled()) {
            logger.debug("Node " + endpoint + " state left, tokens " + tokens);
        }
        this.excise(tokens, endpoint, this.extractExpireTime(pieces, version));
    }

    private void handleStateMoving(InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        Token token = StorageService.getPartitioner().getTokenFactory().fromString(pieces[1]);
        if (logger.isDebugEnabled()) {
            logger.debug("Node " + endpoint + " state moving, new token " + token);
        }
        this.tokenMetadata.addMovingEndpoint(token, endpoint);
        PendingRangeCalculatorService.instance.update();
    }

    private void handleStateRelocating(InetAddress endpoint, String[] pieces) {
        assert (pieces.length >= 2);
        ArrayList<Token> tokens = new ArrayList<Token>(pieces.length - 1);
        for (String tStr : Arrays.copyOfRange(pieces, 1, pieces.length)) {
            tokens.add(StorageService.getPartitioner().getTokenFactory().fromString(tStr));
        }
        logger.debug("Tokens {} are relocating to {}", tokens, (Object)endpoint);
        this.tokenMetadata.addRelocatingTokens(tokens, endpoint);
        PendingRangeCalculatorService.instance.update();
    }

    private void handleStateRemoving(InetAddress endpoint, String[] pieces) {
        assert (pieces.length > 0);
        if (endpoint.equals(FBUtilities.getBroadcastAddress())) {
            logger.info("Received removenode gossip about myself. Is this node rejoining after an explicit removenode?");
            try {
                this.drain();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
        if (this.tokenMetadata.isMember(endpoint)) {
            String state = pieces[0];
            Collection<Token> removeTokens = this.tokenMetadata.getTokens(endpoint);
            if ("removed".equals(state)) {
                this.excise(removeTokens, endpoint, this.extractExpireTime(pieces, MessagingService.instance().getVersion(endpoint)));
            } else if ("removing".equals(state)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Tokens " + removeTokens + " removed manually (endpoint was " + endpoint + ")");
                }
                this.tokenMetadata.addLeavingEndpoint(endpoint);
                PendingRangeCalculatorService.instance.update();
                String[] coordinator = Gossiper.instance.getEndpointStateForEndpoint((InetAddress)endpoint).getApplicationState((ApplicationState)ApplicationState.REMOVAL_COORDINATOR).value.split(VersionedValue.DELIMITER_STR, -1);
                UUID hostId = UUID.fromString(coordinator[1]);
                this.restoreReplicaCount(endpoint, this.tokenMetadata.getEndpointForHostId(hostId));
            }
        } else {
            if ("removed".equals(pieces[0])) {
                this.addExpireTimeIfFound(endpoint, this.extractExpireTime(pieces, MessagingService.instance().getVersion(endpoint)));
            }
            this.removeEndpoint(endpoint);
        }
    }

    private void excise(Collection<Token> tokens, InetAddress endpoint) {
        logger.info("Removing tokens " + tokens + " for " + endpoint);
        HintedHandOffManager.instance.deleteHintsForEndpoint(endpoint);
        this.removeEndpoint(endpoint);
        this.tokenMetadata.removeEndpoint(endpoint);
        this.tokenMetadata.removeBootstrapTokens(tokens);
        if (!this.isClientMode) {
            for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
                subscriber.onLeaveCluster(endpoint);
            }
        }
        PendingRangeCalculatorService.instance.update();
    }

    private void excise(Collection<Token> tokens, InetAddress endpoint, long expireTime) {
        this.addExpireTimeIfFound(endpoint, expireTime);
        this.excise(tokens, endpoint);
    }

    private void removeEndpoint(InetAddress endpoint) {
        Gossiper.instance.removeEndpoint(endpoint);
        if (!this.isClientMode) {
            SystemTable.removeEndpoint(endpoint);
        }
    }

    protected void addExpireTimeIfFound(InetAddress endpoint, long expireTime) {
        if (expireTime != 0L) {
            Gossiper.instance.addExpireTimeForEndpoint(endpoint, expireTime);
        }
    }

    protected long extractExpireTime(String[] pieces, int version) {
        if (version < 6) {
            if (pieces.length >= 3) {
                return Long.parseLong(pieces[2]);
            }
            return 0L;
        }
        return Long.parseLong(pieces[2]);
    }

    private Multimap<InetAddress, Range<Token>> getNewSourceRanges(String table, Set<Range<Token>> ranges) {
        InetAddress myAddress = FBUtilities.getBroadcastAddress();
        Multimap<Range<Token>, InetAddress> rangeAddresses = Table.open(table).getReplicationStrategy().getRangeAddresses(this.tokenMetadata.cloneOnlyTokenMap());
        HashMultimap sourceRanges = HashMultimap.create();
        IFailureDetector failureDetector = FailureDetector.instance;
        block0: for (Range<Token> range : ranges) {
            Collection possibleRanges = rangeAddresses.get(range);
            IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
            List<InetAddress> sources = snitch.getSortedListByProximity(myAddress, possibleRanges);
            assert (!sources.contains(myAddress));
            for (InetAddress source : sources) {
                if (!failureDetector.isAlive(source)) continue;
                sourceRanges.put((Object)source, range);
                continue block0;
            }
        }
        return sourceRanges;
    }

    private void sendReplicationNotification(InetAddress remote) {
        MessageOut msg = new MessageOut(MessagingService.Verb.REPLICATION_FINISHED);
        IFailureDetector failureDetector = FailureDetector.instance;
        if (logger.isDebugEnabled()) {
            logger.debug("Notifying " + remote.toString() + " of replication completion\n");
        }
        while (failureDetector.isAlive(remote)) {
            IAsyncResult iar = MessagingService.instance().sendRR(msg, remote);
            try {
                iar.get(DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException e) {
            }
        }
    }

    private void restoreReplicaCount(InetAddress endpoint, InetAddress notifyEndpoint) {
        HashMultimap fetchSources = HashMultimap.create();
        HashMultimap rangesToFetch = HashMultimap.create();
        InetAddress myAddress = FBUtilities.getBroadcastAddress();
        for (String table : Schema.instance.getNonSystemTables()) {
            Multimap<Range<Token>, InetAddress> changedRanges = this.getChangedRangesForLeaving(table, endpoint);
            HashSet<Range<Token>> myNewRanges = new HashSet<Range<Token>>();
            for (Map.Entry entry : changedRanges.entries()) {
                if (!((InetAddress)entry.getValue()).equals(myAddress)) continue;
                myNewRanges.add((Range<Token>)entry.getKey());
            }
            Multimap<InetAddress, Range<Token>> sourceRanges = this.getNewSourceRanges(table, myNewRanges);
            for (Map.Entry entry : sourceRanges.asMap().entrySet()) {
                fetchSources.put(entry.getKey(), (Object)table);
                rangesToFetch.put((Object)table, entry);
            }
        }
        for (String table : rangesToFetch.keySet()) {
            for (Map.Entry entry : rangesToFetch.get((Object)table)) {
                InetAddress source = (InetAddress)entry.getKey();
                Collection ranges = (Collection)entry.getValue();
                IStreamCallback callback = new IStreamCallback((Multimap)fetchSources, source, table, notifyEndpoint){
                    final /* synthetic */ Multimap val$fetchSources;
                    final /* synthetic */ InetAddress val$source;
                    final /* synthetic */ String val$table;
                    final /* synthetic */ InetAddress val$notifyEndpoint;
                    {
                        this.val$fetchSources = multimap;
                        this.val$source = inetAddress;
                        this.val$table = string;
                        this.val$notifyEndpoint = inetAddress2;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onSuccess() {
                        Multimap multimap = this.val$fetchSources;
                        synchronized (multimap) {
                            this.val$fetchSources.remove((Object)this.val$source, (Object)this.val$table);
                            if (this.val$fetchSources.isEmpty()) {
                                StorageService.this.sendReplicationNotification(this.val$notifyEndpoint);
                            }
                        }
                    }

                    @Override
                    public void onFailure() {
                        logger.warn("Streaming from " + this.val$source + " failed");
                        this.onSuccess();
                    }
                };
                if (logger.isDebugEnabled()) {
                    logger.debug("Requesting from " + source + " ranges " + StringUtils.join((Collection)ranges, (String)", "));
                }
                StreamIn.requestRanges(source, table, ranges, callback, OperationType.RESTORE_REPLICA_COUNT);
            }
        }
    }

    private Multimap<Range<Token>, InetAddress> getChangedRangesForLeaving(String table, InetAddress endpoint) {
        Collection<Range<Token>> ranges = this.getRangesForEndpoint(table, endpoint);
        if (logger.isDebugEnabled()) {
            logger.debug("Node " + endpoint + " ranges [" + StringUtils.join(ranges, (String)", ") + "]");
        }
        HashMap<Range<Token>, List<InetAddress>> currentReplicaEndpoints = new HashMap<Range<Token>, List<InetAddress>>();
        for (Range<Token> range : ranges) {
            currentReplicaEndpoints.put(range, Table.open(table).getReplicationStrategy().calculateNaturalEndpoints((Token)range.right, this.tokenMetadata.cloneOnlyTokenMap()));
        }
        TokenMetadata temp = this.tokenMetadata.cloneAfterAllLeft();
        if (temp.isMember(endpoint)) {
            temp.removeEndpoint(endpoint);
        }
        HashMultimap changedRanges = HashMultimap.create();
        for (Range<Token> range : ranges) {
            List<InetAddress> newReplicaEndpoints = Table.open(table).getReplicationStrategy().calculateNaturalEndpoints((Token)range.right, temp);
            newReplicaEndpoints.removeAll((Collection)currentReplicaEndpoints.get(range));
            if (logger.isDebugEnabled()) {
                if (newReplicaEndpoints.isEmpty()) {
                    logger.debug("Range " + range + " already in all replicas");
                } else {
                    logger.debug("Range " + range + " will be responsibility of " + StringUtils.join(newReplicaEndpoints, (String)", "));
                }
            }
            changedRanges.putAll(range, newReplicaEndpoints);
        }
        return changedRanges;
    }

    @Override
    public void onJoin(InetAddress endpoint, EndpointState epState) {
        for (Map.Entry<ApplicationState, VersionedValue> entry : epState.getApplicationStateMap().entrySet()) {
            this.onChange(endpoint, entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void onAlive(InetAddress endpoint, EndpointState state) {
        if (this.isClientMode) {
            return;
        }
        if (this.tokenMetadata.isMember(endpoint)) {
            HintedHandOffManager.instance.scheduleHintDelivery(endpoint);
            for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
                subscriber.onUp(endpoint);
            }
        } else {
            for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
                subscriber.onJoinCluster(endpoint);
            }
        }
    }

    @Override
    public void onRemove(InetAddress endpoint) {
        this.tokenMetadata.removeEndpoint(endpoint);
        PendingRangeCalculatorService.instance.update();
    }

    @Override
    public void onDead(InetAddress endpoint, EndpointState state) {
        MessagingService.instance().convict(endpoint);
        if (!this.isClientMode) {
            for (IEndpointLifecycleSubscriber subscriber : this.lifecycleSubscribers) {
                subscriber.onDown(endpoint);
            }
        }
    }

    @Override
    public void onRestart(InetAddress endpoint, EndpointState state) {
        if (state.isAlive()) {
            this.onDead(endpoint, state);
        }
    }

    @Override
    public double getLoad() {
        double bytes = 0.0;
        for (String tableName : Schema.instance.getTables()) {
            Table table = Table.open(tableName);
            for (ColumnFamilyStore cfs : table.getColumnFamilyStores()) {
                bytes += (double)cfs.getLiveDiskSpaceUsed();
            }
        }
        return bytes;
    }

    @Override
    public String getLoadString() {
        return FileUtils.stringifyFileSize(this.getLoad());
    }

    @Override
    public Map<String, String> getLoadMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<InetAddress, Double> entry : LoadBroadcaster.instance.getLoadInfo().entrySet()) {
            map.put(entry.getKey().getHostAddress(), FileUtils.stringifyFileSize(entry.getValue()));
        }
        map.put(FBUtilities.getBroadcastAddress().getHostAddress(), this.getLoadString());
        return map;
    }

    public final void deliverHints(String host) throws UnknownHostException {
        HintedHandOffManager.instance.scheduleHintDelivery(host);
    }

    public Collection<Token> getLocalTokens() {
        Collection<Token> tokens = SystemTable.getSavedTokens();
        assert (tokens != null && !tokens.isEmpty());
        return tokens;
    }

    @Override
    public List<String> getTokens() {
        return this.getTokens(FBUtilities.getBroadcastAddress());
    }

    @Override
    public List<String> getTokens(String endpoint) throws UnknownHostException {
        return this.getTokens(InetAddress.getByName(endpoint));
    }

    private List<String> getTokens(InetAddress endpoint) {
        ArrayList<String> strTokens = new ArrayList<String>();
        for (Token tok : this.getTokenMetadata().getTokens(endpoint)) {
            strTokens.add(tok.toString());
        }
        return strTokens;
    }

    @Override
    public String getReleaseVersion() {
        return FBUtilities.getReleaseVersionString();
    }

    @Override
    public String getSchemaVersion() {
        return Schema.instance.getVersion().toString();
    }

    @Override
    public List<String> getLeavingNodes() {
        return this.stringify(this.tokenMetadata.getLeavingEndpoints());
    }

    @Override
    public List<String> getMovingNodes() {
        ArrayList<String> endpoints = new ArrayList<String>();
        for (Pair<Token, InetAddress> node : this.tokenMetadata.getMovingEndpoints()) {
            endpoints.add(((InetAddress)node.right).getHostAddress());
        }
        return endpoints;
    }

    @Override
    public List<String> getJoiningNodes() {
        return this.stringify(this.tokenMetadata.getBootstrapTokens().values());
    }

    @Override
    public List<String> getLiveNodes() {
        return this.stringify(Gossiper.instance.getLiveMembers());
    }

    @Override
    public List<String> getUnreachableNodes() {
        return this.stringify(Gossiper.instance.getUnreachableMembers());
    }

    @Override
    public String[] getAllDataFileLocations() {
        String[] locations = DatabaseDescriptor.getAllDataFileLocations();
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = FileUtils.getCanonicalPath(locations[i]);
        }
        return locations;
    }

    @Override
    public String getCommitLogLocation() {
        return FileUtils.getCanonicalPath(DatabaseDescriptor.getCommitLogLocation());
    }

    @Override
    public String getSavedCachesLocation() {
        return FileUtils.getCanonicalPath(DatabaseDescriptor.getSavedCachesLocation());
    }

    private List<String> stringify(Iterable<InetAddress> endpoints) {
        ArrayList<String> stringEndpoints = new ArrayList<String>();
        for (InetAddress ep : endpoints) {
            stringEndpoints.add(ep.getHostAddress());
        }
        return stringEndpoints;
    }

    @Override
    public int getCurrentGenerationNumber() {
        return Gossiper.instance.getCurrentGenerationNumber(FBUtilities.getBroadcastAddress());
    }

    @Override
    public void forceTableCleanup(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        if (tableName.equals("system")) {
            throw new RuntimeException("Cleanup of the system table is neither necessary nor wise");
        }
        CounterId.OneShotRenewer counterIdRenewer = new CounterId.OneShotRenewer();
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(false, false, tableName, columnFamilies)) {
            cfStore.forceCleanup(counterIdRenewer);
        }
    }

    @Override
    public void scrub(boolean disableSnapshot, String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(false, false, tableName, columnFamilies)) {
            cfStore.scrub(disableSnapshot);
        }
    }

    @Override
    public void upgradeSSTables(String tableName, boolean excludeCurrentVersion, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, true, tableName, columnFamilies)) {
            cfStore.sstablesRewrite(excludeCurrentVersion);
        }
    }

    @Override
    public void forceTableCompaction(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, false, tableName, columnFamilies)) {
            cfStore.forceMajorCompaction();
        }
    }

    @Override
    public void takeSnapshot(String tag, String ... tableNames) throws IOException {
        Iterable<Table> tables;
        if (this.operationMode.equals((Object)Mode.JOINING)) {
            throw new IOException("Cannot snapshot until bootstrap completes");
        }
        if (tag == null || tag.equals("")) {
            throw new IOException("You must supply a snapshot name.");
        }
        if (tableNames.length == 0) {
            tables = Table.all();
        } else {
            ArrayList<Table> t = new ArrayList<Table>(tableNames.length);
            for (String table : tableNames) {
                t.add(this.getValidTable(table));
            }
            tables = t;
        }
        for (Table table : tables) {
            if (!table.snapshotExists(tag)) continue;
            throw new IOException("Snapshot " + tag + " already exists.");
        }
        for (Table table : tables) {
            table.snapshot(tag, null);
        }
    }

    @Override
    public void takeColumnFamilySnapshot(String tableName, String columnFamilyName, String tag) throws IOException {
        if (this.operationMode.equals((Object)Mode.JOINING)) {
            throw new IOException("Cannot snapshot until bootstrap completes");
        }
        if (tableName == null) {
            throw new IOException("You must supply a table name");
        }
        if (columnFamilyName == null) {
            throw new IOException("You must supply a column family name");
        }
        if (columnFamilyName.contains(".")) {
            throw new IllegalArgumentException("Cannot take a snapshot of a secondary index by itself. Run snapshot on the column family that owns the index.");
        }
        if (tag == null || tag.equals("")) {
            throw new IOException("You must supply a snapshot name.");
        }
        Table table = this.getValidTable(tableName);
        if (table.snapshotExists(tag)) {
            throw new IOException("Snapshot " + tag + " already exists.");
        }
        table.snapshot(tag, columnFamilyName);
    }

    private Table getValidTable(String tableName) throws IOException {
        if (!Schema.instance.getTables().contains(tableName)) {
            throw new IOException("Table " + tableName + " does not exist");
        }
        return Table.open(tableName);
    }

    @Override
    public void clearSnapshot(String tag, String ... tableNames) throws IOException {
        Iterable<Table> tables;
        if (tag == null) {
            tag = "";
        }
        if (tableNames.length == 0) {
            tables = Table.all();
        } else {
            ArrayList<Table> tempTables = new ArrayList<Table>(tableNames.length);
            for (String table : tableNames) {
                tempTables.add(this.getValidTable(table));
            }
            tables = tempTables;
        }
        for (Table table : tables) {
            table.clearSnapshot(tag);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Cleared out snapshot directories");
        }
    }

    public Iterable<ColumnFamilyStore> getValidColumnFamilies(boolean allowIndexes, boolean autoAddIndexes, String tableName, String ... cfNames) throws IOException {
        Table table = this.getValidTable(tableName);
        HashSet<ColumnFamilyStore> valid = new HashSet<ColumnFamilyStore>();
        if (cfNames.length == 0) {
            for (ColumnFamilyStore cfStore : table.getColumnFamilyStores()) {
                valid.add(cfStore);
                if (!autoAddIndexes) continue;
                for (SecondaryIndex si : cfStore.indexManager.getIndexes()) {
                    logger.info("adding secondary index {} to operation", (Object)si.getIndexName());
                    valid.add(si.getIndexCfs());
                }
            }
            return valid;
        }
        String[] arr$ = cfNames;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ColumnFamilyStore cfStore;
            String cfName;
            String baseCfName = cfName = arr$[i$];
            String idxName = null;
            if (cfName.contains(".")) {
                if (!allowIndexes) {
                    logger.warn("Operation not allowed on secondary Index column family ({})", (Object)cfName);
                    continue;
                }
                String[] parts = cfName.split("\\.", 2);
                baseCfName = parts[0];
                idxName = parts[1];
            }
            if ((cfStore = table.getColumnFamilyStore(baseCfName)) == null) {
                logger.warn(String.format("Invalid column family specified: %s. Proceeding with others.", baseCfName));
                continue;
            }
            if (idxName != null) {
                Collection<SecondaryIndex> indexes = cfStore.indexManager.getIndexesByNames(new HashSet<String>(Arrays.asList(cfName)));
                if (indexes.isEmpty()) {
                    logger.warn(String.format("Invalid column family index specified: %s/%s. Proceeding with others.", baseCfName, idxName));
                    continue;
                }
                valid.add(((SecondaryIndex)Iterables.get(indexes, (int)0)).getIndexCfs());
                continue;
            }
            valid.add(cfStore);
            if (!autoAddIndexes) continue;
            for (SecondaryIndex si : cfStore.indexManager.getIndexes()) {
                logger.info("adding secondary index {} to operation", (Object)si.getIndexName());
                valid.add(si.getIndexCfs());
            }
        }
        return valid;
    }

    @Override
    public void forceTableFlush(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(true, false, tableName, columnFamilies)) {
            logger.debug("Forcing flush on keyspace " + tableName + ", CF " + cfStore.getColumnFamilyName());
            cfStore.forceBlockingFlush();
        }
    }

    public void sendNotification(String type, String message, Object userObject) {
        Notification jmxNotification = new Notification(type, (Object)this.jmxObjectName, this.notificationSerialNumber.incrementAndGet(), message);
        jmxNotification.setUserData(userObject);
        this.sendNotification(jmxNotification);
    }

    @Override
    public int forceRepairAsync(String keyspace, boolean isSequential, boolean isLocal, boolean primaryRange, String ... columnFamilies) {
        Collection<Range<Token>> ranges = primaryRange ? this.getLocalPrimaryRanges(keyspace) : this.getLocalRanges(keyspace);
        return this.forceRepairAsync(keyspace, isSequential, isLocal, ranges, columnFamilies);
    }

    public int forceRepairAsync(String keyspace, boolean isSequential, boolean isLocal, Collection<Range<Token>> ranges, String ... columnFamilies) {
        if ("system".equals(keyspace) || "system_traces".equals(keyspace) || ranges.isEmpty()) {
            return 0;
        }
        int cmd = nextRepairCommand.incrementAndGet();
        if (ranges.size() > 0) {
            new Thread(this.createRepairTask(cmd, keyspace, ranges, isSequential, isLocal, columnFamilies)).start();
        }
        return cmd;
    }

    @Override
    public int forceRepairRangeAsync(String beginToken, String endToken, String tableName, boolean isSequential, boolean isLocal, String ... columnFamilies) {
        Token parsedBeginToken = StorageService.getPartitioner().getTokenFactory().fromString(beginToken);
        Token parsedEndToken = StorageService.getPartitioner().getTokenFactory().fromString(endToken);
        logger.info("starting user-requested repair of range ({}, {}] for keyspace {} and column families {}", new Object[]{parsedBeginToken, parsedEndToken, tableName, columnFamilies});
        return this.forceRepairAsync(tableName, isSequential, isLocal, Collections.singleton(new Range(parsedBeginToken, parsedEndToken)), columnFamilies);
    }

    @Override
    public void forceTableRepair(String tableName, boolean isSequential, boolean isLocal, String ... columnFamilies) throws IOException {
        this.forceTableRepairRange(tableName, this.getLocalRanges(tableName), isSequential, isLocal, columnFamilies);
    }

    @Override
    public void forceTableRepairPrimaryRange(String tableName, boolean isSequential, boolean isLocal, String ... columnFamilies) throws IOException {
        this.forceTableRepairRange(tableName, this.getLocalPrimaryRanges(tableName), isSequential, isLocal, columnFamilies);
    }

    @Override
    public void forceTableRepairRange(String beginToken, String endToken, String tableName, boolean isSequential, boolean isLocal, String ... columnFamilies) throws IOException {
        Token parsedBeginToken = StorageService.getPartitioner().getTokenFactory().fromString(beginToken);
        Token parsedEndToken = StorageService.getPartitioner().getTokenFactory().fromString(endToken);
        logger.info("starting user-requested repair of range ({}, {}] for keyspace {} and column families {}", new Object[]{parsedBeginToken, parsedEndToken, tableName, columnFamilies});
        this.forceTableRepairRange(tableName, Collections.singleton(new Range(parsedBeginToken, parsedEndToken)), isSequential, isLocal, columnFamilies);
    }

    public void forceTableRepairRange(String tableName, Collection<Range<Token>> ranges, boolean isSequential, boolean isLocal, String ... columnFamilies) throws IOException {
        if (Schema.systemKeyspaceNames.contains((Object)tableName)) {
            return;
        }
        this.createRepairTask(nextRepairCommand.incrementAndGet(), tableName, ranges, isSequential, isLocal, columnFamilies).run();
    }

    private FutureTask<Object> createRepairTask(final int cmd, final String keyspace, final Collection<Range<Token>> ranges, final boolean isSequential, final boolean isLocal, final String ... columnFamilies) {
        FutureTask<Object> task = new FutureTask<Object>(new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws Exception {
                String message = String.format("Starting repair command #%d, repairing %d ranges for keyspace %s", cmd, ranges.size(), keyspace);
                logger.info(message);
                StorageService.this.sendNotification("repair", message, new int[]{cmd, AntiEntropyService.Status.STARTED.ordinal()});
                ArrayList<AntiEntropyService.RepairFuture> futures = new ArrayList<AntiEntropyService.RepairFuture>(ranges.size());
                for (Range range : ranges) {
                    AntiEntropyService.RepairFuture future;
                    try {
                        future = StorageService.this.forceTableRepair(range, keyspace, isSequential, isLocal, columnFamilies);
                    }
                    catch (IllegalArgumentException e) {
                        logger.error("Repair session failed:", (Throwable)e);
                        StorageService.this.sendNotification("repair", message, new int[]{cmd, AntiEntropyService.Status.SESSION_FAILED.ordinal()});
                        continue;
                    }
                    if (future == null) continue;
                    futures.add(future);
                    try {
                        future.session.differencingDone.await();
                    }
                    catch (InterruptedException e) {
                        message = "Interrupted while waiting for the differencing of repair session " + future.session + " to be done. Repair may be imprecise.";
                        logger.error(message, (Throwable)e);
                        StorageService.this.sendNotification("repair", message, new int[]{cmd, AntiEntropyService.Status.SESSION_FAILED.ordinal()});
                    }
                }
                for (AntiEntropyService.RepairFuture future : futures) {
                    try {
                        future.get();
                        message = String.format("Repair session %s for range %s finished", future.session.getName(), future.session.getRange().toString());
                        StorageService.this.sendNotification("repair", message, new int[]{cmd, AntiEntropyService.Status.SESSION_SUCCESS.ordinal()});
                    }
                    catch (ExecutionException e) {
                        message = String.format("Repair session %s for range %s failed with error %s", future.session.getName(), future.session.getRange().toString(), e.getCause().getMessage());
                        logger.error(message, (Throwable)e);
                        StorageService.this.sendNotification("repair", message, new int[]{cmd, AntiEntropyService.Status.SESSION_FAILED.ordinal()});
                    }
                    catch (Exception e) {
                        message = String.format("Repair session %s for range %s failed with error %s", future.session.getName(), future.session.getRange().toString(), e.getMessage());
                        logger.error(message, (Throwable)e);
                        StorageService.this.sendNotification("repair", message, new int[]{cmd, AntiEntropyService.Status.SESSION_FAILED.ordinal()});
                    }
                }
                StorageService.this.sendNotification("repair", String.format("Repair command #%d finished", cmd), new int[]{cmd, AntiEntropyService.Status.FINISHED.ordinal()});
            }
        }, null);
        return task;
    }

    public AntiEntropyService.RepairFuture forceTableRepair(Range<Token> range, String tableName, boolean isSequential, boolean isLocal, String ... columnFamilies) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        for (ColumnFamilyStore cfStore : this.getValidColumnFamilies(false, false, tableName, columnFamilies)) {
            names.add(cfStore.getColumnFamilyName());
        }
        if (names.isEmpty()) {
            logger.info("No column family to repair for keyspace " + tableName);
            return null;
        }
        return AntiEntropyService.instance.submitRepairSession(range, tableName, isSequential, isLocal, names.toArray(new String[names.size()]));
    }

    @Override
    public void forceTerminateAllRepairSessions() {
        AntiEntropyService.instance.terminateSessions();
    }

    InetAddress getPredecessor(Token token) {
        return this.tokenMetadata.getEndpoint(this.tokenMetadata.getPredecessor(token));
    }

    public InetAddress getSuccessor(Token token) {
        return this.tokenMetadata.getEndpoint(this.tokenMetadata.getSuccessor(token));
    }

    public Collection<Range<Token>> getPrimaryRangesForEndpoint(String keyspace, InetAddress ep) {
        AbstractReplicationStrategy strategy = Table.open(keyspace).getReplicationStrategy();
        HashSet<Range<Token>> primaryRanges = new HashSet<Range<Token>>();
        TokenMetadata metadata = this.tokenMetadata.cloneOnlyTokenMap();
        for (Token token : metadata.sortedTokens()) {
            List<InetAddress> endpoints = strategy.calculateNaturalEndpoints(token, metadata);
            if (endpoints.size() <= 0 || !endpoints.get(0).equals(ep)) continue;
            primaryRanges.add(new Range<Token>(metadata.getPredecessor(token), token));
        }
        return primaryRanges;
    }

    @Deprecated
    public Range<Token> getPrimaryRangeForEndpoint(InetAddress ep) {
        return this.tokenMetadata.getPrimaryRangeFor(this.tokenMetadata.getToken(ep));
    }

    Collection<Range<Token>> getRangesForEndpoint(String table, InetAddress ep) {
        return Table.open(table).getReplicationStrategy().getAddressRanges().get((Object)ep);
    }

    public List<Range<Token>> getAllRanges(List<Token> sortedTokens) {
        if (logger.isDebugEnabled()) {
            logger.debug("computing ranges for " + StringUtils.join(sortedTokens, (String)", "));
        }
        if (sortedTokens.isEmpty()) {
            return Collections.emptyList();
        }
        int size = sortedTokens.size();
        ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(size + 1);
        for (int i = 1; i < size; ++i) {
            Range<RingPosition> range = new Range<RingPosition>(sortedTokens.get(i - 1), sortedTokens.get(i));
            ranges.add(range);
        }
        Range<RingPosition> range = new Range<RingPosition>(sortedTokens.get(size - 1), sortedTokens.get(0));
        ranges.add(range);
        return ranges;
    }

    @Override
    public List<InetAddress> getNaturalEndpoints(String table, String cf, String key) {
        CFMetaData cfMetaData = Schema.instance.getTableDefinition(table).cfMetaData().get(cf);
        return this.getNaturalEndpoints(table, (RingPosition)StorageService.getPartitioner().getToken(cfMetaData.getKeyValidator().fromString(key)));
    }

    @Override
    public List<InetAddress> getNaturalEndpoints(String table, ByteBuffer key) {
        return this.getNaturalEndpoints(table, (RingPosition)StorageService.getPartitioner().getToken(key));
    }

    public List<InetAddress> getNaturalEndpoints(String table, RingPosition pos) {
        return Table.open(table).getReplicationStrategy().getNaturalEndpoints(pos);
    }

    public List<InetAddress> getLiveNaturalEndpoints(Table table, ByteBuffer key) {
        return this.getLiveNaturalEndpoints(table, StorageService.getPartitioner().decorateKey(key));
    }

    public List<InetAddress> getLiveNaturalEndpoints(Table table, RingPosition pos) {
        ArrayList<InetAddress> endpoints = table.getReplicationStrategy().getNaturalEndpoints(pos);
        ArrayList<InetAddress> liveEps = new ArrayList<InetAddress>(endpoints.size());
        for (InetAddress endpoint : endpoints) {
            if (!FailureDetector.instance.isAlive(endpoint)) continue;
            liveEps.add(endpoint);
        }
        return liveEps;
    }

    @Override
    public void setLog4jLevel(String classQualifier, String rawLevel) {
        Level level = Level.toLevel((String)rawLevel);
        org.apache.log4j.Logger.getLogger((String)classQualifier).setLevel(level);
        logger.info("set log level to " + level + " for classes under '" + classQualifier + "' (if the level doesn't look like '" + rawLevel + "' then log4j couldn't parse '" + rawLevel + "')");
    }

    public List<Pair<Range<Token>, Long>> getSplits(String table, String cfName, Range<Token> range, int keysPerSplit) {
        Table t = Table.open(table);
        ColumnFamilyStore cfs = t.getColumnFamilyStore(cfName);
        List<DecoratedKey> keys = this.keySamples(Collections.singleton(cfs), range);
        long totalRowCountEstimate = (keys.size() + 1) * DatabaseDescriptor.getIndexInterval();
        int minSamplesPerSplit = 4;
        int maxSplitCount = keys.size() / 4 + 1;
        int splitCount = Math.max(1, Math.min(maxSplitCount, (int)(totalRowCountEstimate / (long)keysPerSplit)));
        List<Token> tokens = this.keysToTokens(range, keys);
        return this.getSplits(tokens, splitCount);
    }

    private List<Pair<Range<Token>, Long>> getSplits(List<Token> tokens, int splitCount) {
        double step = (double)(tokens.size() - 1) / (double)splitCount;
        int prevIndex = 0;
        Token prevToken = tokens.get(0);
        ArrayList splits = Lists.newArrayListWithExpectedSize((int)splitCount);
        for (int i = 1; i <= splitCount; ++i) {
            int index = (int)Math.round((double)i * step);
            Token token = tokens.get(index);
            long rowCountEstimate = (index - prevIndex) * DatabaseDescriptor.getIndexInterval();
            splits.add(Pair.create(new Range<Token>(prevToken, token), rowCountEstimate));
            prevIndex = index;
            prevToken = token;
        }
        return splits;
    }

    private List<Token> keysToTokens(Range<Token> range, List<DecoratedKey> keys) {
        ArrayList tokens = Lists.newArrayListWithExpectedSize((int)(keys.size() + 2));
        tokens.add(range.left);
        for (DecoratedKey key : keys) {
            tokens.add(key.token);
        }
        tokens.add(range.right);
        return tokens;
    }

    private List<DecoratedKey> keySamples(Iterable<ColumnFamilyStore> cfses, Range<Token> range) {
        ArrayList<DecoratedKey> keys = new ArrayList<DecoratedKey>();
        for (ColumnFamilyStore cfs : cfses) {
            Iterables.addAll(keys, cfs.keySamples(range));
        }
        FBUtilities.sortSampledKeys(keys, range);
        return keys;
    }

    public Token getBootstrapToken() {
        Token token;
        Range<Token> range = this.getLocalPrimaryRange();
        List<DecoratedKey> keys = this.keySamples(ColumnFamilyStore.allUserDefined(), range);
        if (keys.size() < 3) {
            token = StorageService.getPartitioner().midpoint((Token)range.left, (Token)range.right);
            logger.debug("Used midpoint to assign token " + token);
        } else {
            token = keys.get((int)(keys.size() / 2)).token;
            logger.debug("Used key sample of size " + keys.size() + " to assign token " + token);
        }
        if (this.tokenMetadata.getEndpoint(token) != null && this.tokenMetadata.isMember(this.tokenMetadata.getEndpoint(token))) {
            throw new RuntimeException("Chose token " + token + " which is already in use by " + this.tokenMetadata.getEndpoint(token) + " -- specify one manually with initial_token");
        }
        if (token instanceof StringToken) {
            token = new StringToken(((String)token.token).replaceAll(VersionedValue.DELIMITER_STR, ""));
            if (this.tokenMetadata.getNormalAndBootstrappingTokenToEndpointMap().containsKey(token)) {
                throw new RuntimeException("Unable to compute unique token for new node -- specify one manually with initial_token");
            }
        }
        return token;
    }

    private void startLeaving() {
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.leaving(this.getLocalTokens()));
        this.tokenMetadata.addLeavingEndpoint(FBUtilities.getBroadcastAddress());
        PendingRangeCalculatorService.instance.update();
    }

    @Override
    public void decommission() throws InterruptedException {
        if (!this.tokenMetadata.isMember(FBUtilities.getBroadcastAddress())) {
            throw new UnsupportedOperationException("local node is not a member of the token ring yet");
        }
        if (this.tokenMetadata.cloneAfterAllLeft().sortedTokens().size() < 2) {
            throw new UnsupportedOperationException("no other normal nodes in the ring; decommission would be pointless");
        }
        PendingRangeCalculatorService.instance.blockUntilFinished();
        for (String table : Schema.instance.getNonSystemTables()) {
            if (this.tokenMetadata.getPendingRanges(table, FBUtilities.getBroadcastAddress()).size() <= 0) continue;
            throw new UnsupportedOperationException("data is currently moving to this node; unable to leave the ring");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DECOMMISSIONING");
        }
        this.startLeaving();
        this.setMode(Mode.LEAVING, "sleeping " + RING_DELAY + " ms for pending range setup", true);
        Thread.sleep(RING_DELAY);
        Runnable finishLeaving = new Runnable(){

            @Override
            public void run() {
                StorageService.this.shutdownClientServers();
                Gossiper.instance.stop();
                MessagingService.instance().shutdown();
                StageManager.shutdownNow();
                StorageService.this.setMode(Mode.DECOMMISSIONED, true);
            }
        };
        this.unbootstrap(finishLeaving);
    }

    private void leaveRing() {
        SystemTable.setBootstrapState(SystemTable.BootstrapState.NEEDS_BOOTSTRAP);
        this.tokenMetadata.removeEndpoint(FBUtilities.getBroadcastAddress());
        PendingRangeCalculatorService.instance.update();
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.left(this.getLocalTokens(), Gossiper.computeExpireTime()));
        int delay = Math.max(RING_DELAY, 2000);
        logger.info("Announcing that I have left the ring for " + delay + "ms");
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void unbootstrap(Runnable onFinish) {
        HashMap<String, Multimap<Range<Token>, InetAddress>> rangesToStream = new HashMap<String, Multimap<Range<Token>, InetAddress>>();
        for (String table : Schema.instance.getNonSystemTables()) {
            Multimap<Range<Token>, InetAddress> rangesMM = this.getChangedRangesForLeaving(table, FBUtilities.getBroadcastAddress());
            if (logger.isDebugEnabled()) {
                logger.debug("Ranges needing transfer are [" + StringUtils.join((Collection)rangesMM.keySet(), (String)",") + "]");
            }
            rangesToStream.put(table, rangesMM);
        }
        this.setMode(Mode.LEAVING, "streaming data to other nodes", true);
        CountDownLatch latch = this.streamRanges(rangesToStream);
        CountDownLatch hintsLatch = this.streamHints();
        logger.debug("waiting for stream aks.");
        try {
            latch.await();
            hintsLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        logger.debug("stream acks all received.");
        this.leaveRing();
        onFinish.run();
    }

    private CountDownLatch streamHints() {
        if (HintedHandOffManager.instance.listEndpointsPendingHints().size() == 0) {
            return new CountDownLatch(0);
        }
        ArrayList<InetAddress> candidates = new ArrayList<InetAddress>(instance.getTokenMetadata().cloneAfterAllLeft().getAllEndpoints());
        candidates.remove(FBUtilities.getBroadcastAddress());
        Iterator iter = candidates.iterator();
        while (iter.hasNext()) {
            InetAddress address = (InetAddress)iter.next();
            if (FailureDetector.instance.isAlive(address)) continue;
            iter.remove();
        }
        if (candidates.isEmpty()) {
            logger.warn("Unable to stream hints since no live endpoints seen");
            return new CountDownLatch(0);
        }
        DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getBroadcastAddress(), candidates);
        InetAddress hintsDestinationHost = (InetAddress)candidates.get(0);
        Object token = StorageService.getPartitioner().getMinimumToken();
        List<Range<Token>> ranges = Collections.singletonList(new Range(token, token));
        CountDownLatch latch = new CountDownLatch(1);
        StreamOut.transferRanges(hintsDestinationHost, Table.open("system"), Collections.singletonList(Table.open("system").getColumnFamilyStore("hints")), ranges, new CountingDownStreamCallback(latch, hintsDestinationHost), OperationType.UNBOOTSTRAP);
        return latch;
    }

    @Override
    public void move(String newToken) throws IOException {
        try {
            StorageService.getPartitioner().getTokenFactory().validate(newToken);
        }
        catch (ConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        this.move(StorageService.getPartitioner().getTokenFactory().fromString(newToken));
    }

    private void move(Token newToken) throws IOException {
        if (newToken == null) {
            throw new IOException("Can't move to the undefined (null) token.");
        }
        if (this.tokenMetadata.sortedTokens().contains(newToken)) {
            throw new IOException("target token " + newToken + " is already owned by another node.");
        }
        InetAddress localAddress = FBUtilities.getBroadcastAddress();
        if (this.getTokenMetadata().getTokens(localAddress).size() > 1) {
            logger.error("Invalid request to move(Token); This node has more than one token and cannot be moved thusly.");
            throw new UnsupportedOperationException("This node has more than one token and cannot be moved thusly.");
        }
        List<String> tablesToProcess = Schema.instance.getNonSystemTables();
        PendingRangeCalculatorService.instance.blockUntilFinished();
        for (String table : tablesToProcess) {
            if (this.tokenMetadata.getPendingRanges(table, localAddress).size() <= 0) continue;
            throw new UnsupportedOperationException("data is currently moving to this node; unable to leave the ring");
        }
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.moving(newToken));
        this.setMode(Mode.MOVING, String.format("Moving %s from %s to %s.", localAddress, this.getLocalTokens().iterator().next(), newToken), true);
        this.setMode(Mode.MOVING, String.format("Sleeping %s ms before start streaming/fetching ranges", RING_DELAY), true);
        try {
            Thread.sleep(RING_DELAY);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Sleep interrupted " + e.getMessage());
        }
        RangeRelocator relocator = new RangeRelocator(Collections.singleton(newToken), tablesToProcess);
        if (relocator.streamsNeeded()) {
            this.setMode(Mode.MOVING, "fetching new ranges and streaming old ranges", true);
            relocator.logStreamsMap("[Move->STREAMING]");
            CountDownLatch streamLatch = relocator.streams();
            relocator.logRequestsMap("[Move->FETCHING]");
            CountDownLatch fetchLatch = relocator.requests();
            try {
                streamLatch.await();
                fetchLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted latch while waiting for stream/fetch ranges to finish: " + e.getMessage());
            }
        } else {
            this.setMode(Mode.MOVING, "No ranges to fetch/stream", true);
        }
        this.setTokens(Collections.singleton(newToken));
        if (logger.isDebugEnabled()) {
            logger.debug("Successfully moved to new token {}", (Object)this.getLocalTokens().iterator().next());
        }
    }

    @Override
    public void relocate(Collection<String> srcTokens) throws IOException {
        ArrayList<Token> tokens = new ArrayList<Token>(srcTokens.size());
        try {
            for (String srcT : srcTokens) {
                StorageService.getPartitioner().getTokenFactory().validate(srcT);
                tokens.add(StorageService.getPartitioner().getTokenFactory().fromString(srcT));
            }
        }
        catch (ConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        this.relocateTokens(tokens);
    }

    void relocateTokens(Collection<Token> srcTokens) {
        assert (srcTokens != null);
        InetAddress localAddress = FBUtilities.getBroadcastAddress();
        Collection<Token> localTokens = this.getTokenMetadata().getTokens(localAddress);
        HashSet<Token> tokens = new HashSet<Token>(srcTokens);
        Iterator it = tokens.iterator();
        while (it.hasNext()) {
            Token srcT = (Token)it.next();
            if (!localTokens.contains(srcT)) continue;
            it.remove();
            logger.warn("cannot move {}; source and destination match", (Object)srcT);
        }
        if (tokens.size() < 1) {
            logger.warn("no valid token arguments specified; nothing to relocate");
        }
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.relocating(tokens));
        this.setMode(Mode.RELOCATING, String.format("relocating %s to %s", tokens, localAddress.getHostAddress()), true);
        List<String> tables = Schema.instance.getNonSystemTables();
        this.setMode(Mode.RELOCATING, String.format("Sleeping %s ms before start streaming/fetching ranges", RING_DELAY), true);
        try {
            Thread.sleep(RING_DELAY);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Sleep interrupted " + e.getMessage());
        }
        RangeRelocator relocator = new RangeRelocator(tokens, tables);
        if (relocator.streamsNeeded()) {
            this.setMode(Mode.RELOCATING, "fetching new ranges and streaming old ranges", true);
            relocator.logStreamsMap("[Relocate->STREAMING]");
            CountDownLatch streamLatch = relocator.streams();
            relocator.logRequestsMap("[Relocate->FETCHING]");
            CountDownLatch fetchLatch = relocator.requests();
            try {
                streamLatch.await();
                fetchLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted latch while waiting for stream/fetch ranges to finish: " + e.getMessage());
            }
        } else {
            this.setMode(Mode.RELOCATING, "no new ranges to stream/fetch", true);
        }
        Collection<Token> currentTokens = SystemTable.updateLocalTokens(tokens, Collections.<Token>emptyList());
        this.tokenMetadata.updateNormalTokens(currentTokens, FBUtilities.getBroadcastAddress());
        Gossiper.instance.addLocalApplicationState(ApplicationState.TOKENS, this.valueFactory.tokens(currentTokens));
        Gossiper.instance.addLocalApplicationState(ApplicationState.STATUS, this.valueFactory.normal(currentTokens));
        this.setMode(Mode.NORMAL, false);
    }

    @Override
    public String getRemovalStatus() {
        if (this.removingNode == null) {
            return "No token removals in process.";
        }
        return String.format("Removing token (%s). Waiting for replication confirmation from [%s].", this.tokenMetadata.getToken(this.removingNode), StringUtils.join(this.replicatingNodes, (String)","));
    }

    @Override
    public void forceRemoveCompletion() {
        if (!this.replicatingNodes.isEmpty() || !this.tokenMetadata.getLeavingEndpoints().isEmpty()) {
            logger.warn("Removal not confirmed for for " + StringUtils.join(this.replicatingNodes, (String)","));
            for (InetAddress endpoint : this.tokenMetadata.getLeavingEndpoints()) {
                UUID hostId = this.tokenMetadata.getHostId(endpoint);
                Gossiper.instance.advertiseTokenRemoved(endpoint, hostId);
                this.excise(this.tokenMetadata.getTokens(endpoint), endpoint);
            }
        } else {
            throw new UnsupportedOperationException("No tokens to force removal on, call 'removenode' first");
        }
        this.replicatingNodes.clear();
        this.removingNode = null;
    }

    @Override
    public void removeNode(String hostIdString) {
        InetAddress myAddress = FBUtilities.getBroadcastAddress();
        UUID localHostId = this.tokenMetadata.getHostId(myAddress);
        UUID hostId = UUID.fromString(hostIdString);
        InetAddress endpoint = this.tokenMetadata.getEndpointForHostId(hostId);
        if (endpoint == null) {
            throw new UnsupportedOperationException("Host ID not found.");
        }
        Collection<Token> tokens = this.tokenMetadata.getTokens(endpoint);
        if (endpoint.equals(myAddress)) {
            throw new UnsupportedOperationException("Cannot remove self");
        }
        if (Gossiper.instance.getLiveMembers().contains(endpoint)) {
            throw new UnsupportedOperationException("Node " + endpoint + " is alive and owns this ID. Use decommission command to remove it from the ring");
        }
        if (this.tokenMetadata.isLeaving(endpoint)) {
            logger.warn("Node " + endpoint + " is already being removed, continuing removal anyway");
        }
        if (!this.replicatingNodes.isEmpty()) {
            throw new UnsupportedOperationException("This node is already processing a removal. Wait for it to complete, or use 'removenode force' if this has failed.");
        }
        for (String table : Schema.instance.getNonSystemTables()) {
            if (Table.open(table).getReplicationStrategy().getReplicationFactor() == 1) continue;
            Multimap<Range<Token>, InetAddress> changedRanges = this.getChangedRangesForLeaving(table, endpoint);
            IFailureDetector failureDetector = FailureDetector.instance;
            for (InetAddress ep : changedRanges.values()) {
                if (failureDetector.isAlive(ep)) {
                    this.replicatingNodes.add(ep);
                    continue;
                }
                logger.warn("Endpoint " + ep + " is down and will not receive data for re-replication of " + endpoint);
            }
        }
        this.removingNode = endpoint;
        this.tokenMetadata.addLeavingEndpoint(endpoint);
        PendingRangeCalculatorService.instance.update();
        Gossiper.instance.advertiseRemoving(endpoint, hostId, localHostId);
        this.restoreReplicaCount(endpoint, myAddress);
        while (!this.replicatingNodes.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.excise(tokens, endpoint);
        Gossiper.instance.advertiseTokenRemoved(endpoint, hostId);
        this.replicatingNodes.clear();
        this.removingNode = null;
    }

    public void confirmReplication(InetAddress node) {
        if (!this.replicatingNodes.isEmpty()) {
            this.replicatingNodes.remove(node);
        } else {
            logger.info("Received unexpected REPLICATION_FINISHED message from " + node + ". Was this node recently a removal coordinator?");
        }
    }

    public boolean isClientMode() {
        return this.isClientMode;
    }

    public synchronized void requestGC() {
        if (this.hasUnreclaimedSpace()) {
            logger.info("requesting GC to free disk space");
            System.gc();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private boolean hasUnreclaimedSpace() {
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            if (!cfs.hasUnreclaimedSpace()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getOperationMode() {
        return this.operationMode.toString();
    }

    @Override
    public String getDrainProgress() {
        return String.format("Drained %s/%s ColumnFamilies", this.remainingCFs, this.totalCFs);
    }

    @Override
    public synchronized void drain() throws IOException, InterruptedException, ExecutionException {
        TracingAwareExecutorService mutationStage = StageManager.getStage(Stage.MUTATION);
        if (mutationStage.isTerminated()) {
            logger.warn("Cannot drain node (did it already happen?)");
            return;
        }
        this.setMode(Mode.DRAINING, "starting drain process", true);
        this.shutdownClientServers();
        optionalTasks.shutdown();
        Gossiper.instance.stop();
        this.setMode(Mode.DRAINING, "shutting down MessageService", false);
        MessagingService.instance().shutdown();
        this.setMode(Mode.DRAINING, "clearing mutation stage", false);
        mutationStage.shutdown();
        mutationStage.awaitTermination(3600L, TimeUnit.SECONDS);
        StorageProxy.instance.verifyNoHintsInProgress();
        this.setMode(Mode.DRAINING, "flushing column families", false);
        this.totalCFs = 0;
        for (Table table : Table.nonSystem()) {
            this.totalCFs += table.getColumnFamilyStores().size();
        }
        this.remainingCFs = this.totalCFs;
        ArrayList flushes = new ArrayList();
        for (Table table : Table.nonSystem()) {
            for (ColumnFamilyStore cfs : table.getColumnFamilyStores()) {
                flushes.add(cfs.forceFlush());
            }
        }
        for (Future future : flushes) {
            FBUtilities.waitOnFuture(future);
            --this.remainingCFs;
        }
        flushes.clear();
        for (Table table : Table.system()) {
            for (ColumnFamilyStore cfs : table.getColumnFamilyStores()) {
                flushes.add(cfs.forceFlush());
            }
        }
        FBUtilities.waitOnFutures(flushes);
        ColumnFamilyStore.postFlushExecutor.shutdown();
        ColumnFamilyStore.postFlushExecutor.awaitTermination(60L, TimeUnit.SECONDS);
        CommitLog.instance.shutdownBlocking();
        tasks.shutdown();
        if (!tasks.awaitTermination(1L, TimeUnit.MINUTES)) {
            logger.warn("Miscellaneous task executor still busy after one minute; proceeding with shutdown");
        }
        this.setMode(Mode.DRAINED, true);
    }

    IPartitioner setPartitionerUnsafe(IPartitioner newPartitioner) {
        IPartitioner<?> oldPartitioner = DatabaseDescriptor.getPartitioner();
        DatabaseDescriptor.setPartitioner(newPartitioner);
        this.valueFactory = new VersionedValue.VersionedValueFactory(StorageService.getPartitioner());
        return oldPartitioner;
    }

    TokenMetadata setTokenMetadataUnsafe(TokenMetadata tmd) {
        TokenMetadata old = this.tokenMetadata;
        this.tokenMetadata = tmd;
        return old;
    }

    @Override
    public void truncate(String keyspace, String columnFamily) throws TimeoutException, IOException {
        try {
            StorageProxy.truncateBlocking(keyspace, columnFamily);
        }
        catch (UnavailableException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public Map<InetAddress, Float> getOwnership() {
        ArrayList<Token> sortedTokens = this.tokenMetadata.sortedTokens();
        TreeMap<Token, Float> tokenMap = new TreeMap<Token, Float>(StorageService.getPartitioner().describeOwnership(sortedTokens));
        LinkedHashMap<InetAddress, Float> nodeMap = new LinkedHashMap<InetAddress, Float>();
        for (Map.Entry entry : tokenMap.entrySet()) {
            InetAddress endpoint = this.tokenMetadata.getEndpoint((Token)entry.getKey());
            Float tokenOwnership = (Float)entry.getValue();
            if (nodeMap.containsKey(endpoint)) {
                nodeMap.put(endpoint, Float.valueOf(((Float)nodeMap.get(endpoint)).floatValue() + tokenOwnership.floatValue()));
                continue;
            }
            nodeMap.put(endpoint, tokenOwnership);
        }
        return nodeMap;
    }

    public LinkedHashMap<InetAddress, Float> effectiveOwnership(String keyspace) throws IllegalStateException {
        if (Schema.instance.getNonSystemTables().size() <= 0) {
            throw new IllegalStateException("Couldn't find any Non System Keyspaces to infer replication topology");
        }
        if (keyspace == null && !this.hasSameReplication(Schema.instance.getNonSystemTables())) {
            throw new IllegalStateException("Non System keyspaces doesnt have the same topology");
        }
        TokenMetadata metadata = this.tokenMetadata.cloneOnlyTokenMap();
        if (keyspace == null) {
            keyspace = Schema.instance.getNonSystemTables().get(0);
        }
        ArrayList<Collection> endpointsGroupedByDc = new ArrayList<Collection>();
        TreeMap sortedDcsToEndpoints = new TreeMap();
        sortedDcsToEndpoints.putAll(metadata.getTopology().getDatacenterEndpoints().asMap());
        for (Collection endpoints : sortedDcsToEndpoints.values()) {
            endpointsGroupedByDc.add(endpoints);
        }
        Map<Token, Float> tokenOwnership = StorageService.getPartitioner().describeOwnership(this.tokenMetadata.sortedTokens());
        LinkedHashMap finalOwnership = Maps.newLinkedHashMap();
        for (Collection endpoints : endpointsGroupedByDc) {
            for (InetAddress endpoint : endpoints) {
                float ownership = 0.0f;
                for (Range<Token> range : this.getRangesForEndpoint(keyspace, endpoint)) {
                    if (!tokenOwnership.containsKey(range.right)) continue;
                    ownership += tokenOwnership.get(range.right).floatValue();
                }
                finalOwnership.put(endpoint, Float.valueOf(ownership));
            }
        }
        return finalOwnership;
    }

    private boolean hasSameReplication(List<String> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (int i = 0; i < list.size() - 1; ++i) {
            KSMetaData ksm1 = Schema.instance.getKSMetaData(list.get(i));
            KSMetaData ksm2 = Schema.instance.getKSMetaData(list.get(i + 1));
            if (ksm1.strategyClass.equals(ksm2.strategyClass) && Iterators.elementsEqual(ksm1.strategyOptions.entrySet().iterator(), ksm2.strategyOptions.entrySet().iterator())) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getKeyspaces() {
        ArrayList<String> tableslist = new ArrayList<String>(Schema.instance.getTables());
        return Collections.unmodifiableList(tableslist);
    }

    @Override
    public void updateSnitch(String epSnitchClassName, Boolean dynamic, Integer dynamicUpdateInterval, Integer dynamicResetInterval, Double dynamicBadnessThreshold) throws ClassNotFoundException {
        IEndpointSnitch oldSnitch = DatabaseDescriptor.getEndpointSnitch();
        IEndpointSnitch newSnitch = null;
        try {
            newSnitch = (IEndpointSnitch)FBUtilities.construct(epSnitchClassName, "snitch");
        }
        catch (ConfigurationException e) {
            throw new ClassNotFoundException(e.getMessage());
        }
        if (dynamic.booleanValue()) {
            DatabaseDescriptor.setDynamicUpdateInterval(dynamicUpdateInterval);
            DatabaseDescriptor.setDynamicResetInterval(dynamicResetInterval);
            DatabaseDescriptor.setDynamicBadnessThreshold(dynamicBadnessThreshold);
            newSnitch = new DynamicEndpointSnitch(newSnitch);
        }
        DatabaseDescriptor.setEndpointSnitch(newSnitch);
        for (String ks : Schema.instance.getTables()) {
            Table.open((String)ks).getReplicationStrategy().snitch = newSnitch;
        }
        if (oldSnitch instanceof DynamicEndpointSnitch) {
            ((DynamicEndpointSnitch)oldSnitch).unregisterMBean();
        }
    }

    public void flushLargestMemtables() {
        ColumnFamilyStore largest = null;
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            long total = cfs.getTotalMemtableLiveSize();
            if (total <= 0L || largest != null && total <= largest.getTotalMemtableLiveSize()) continue;
            logger.debug(total + " estimated memtable size for " + cfs);
            largest = cfs;
        }
        if (largest == null) {
            logger.info("Unable to reduce heap usage since there are no dirty column families");
            return;
        }
        logger.warn("Flushing " + largest + " to relieve memory pressure");
        largest.forceFlush();
    }

    private CountDownLatch streamRanges(Map<String, Multimap<Range<Token>, InetAddress>> rangesToStreamByTable) {
        Map<InetAddress, LinkedList<Range>> rangesPerEndpoint;
        String table;
        HashMap<String, Map<InetAddress, LinkedList<Range>>> sessionsToStreamByTable = new HashMap<String, Map<InetAddress, LinkedList<Range>>>();
        int sessionCount = 0;
        for (Map.Entry<String, Multimap<Range<Token>, InetAddress>> entry : rangesToStreamByTable.entrySet()) {
            Multimap<Range<Token>, InetAddress> rangesWithEndpoints = entry.getValue();
            if (rangesWithEndpoints.isEmpty()) continue;
            table = entry.getKey();
            rangesPerEndpoint = new HashMap();
            for (Map.Entry entry2 : rangesWithEndpoints.entries()) {
                Range range = (Range)entry2.getKey();
                InetAddress endpoint = (InetAddress)entry2.getValue();
                LinkedList<Range> curRanges = (LinkedList<Range>)rangesPerEndpoint.get(endpoint);
                if (curRanges == null) {
                    curRanges = new LinkedList<Range>();
                    rangesPerEndpoint.put(endpoint, curRanges);
                }
                curRanges.add(range);
            }
            sessionCount += rangesPerEndpoint.size();
            sessionsToStreamByTable.put(table, rangesPerEndpoint);
        }
        CountDownLatch latch = new CountDownLatch(sessionCount);
        for (Map.Entry entry : sessionsToStreamByTable.entrySet()) {
            table = (String)entry.getKey();
            rangesPerEndpoint = (Map)entry.getValue();
            for (Map.Entry entry3 : rangesPerEndpoint.entrySet()) {
                List ranges = (List)entry3.getValue();
                InetAddress newEndpoint = (InetAddress)entry3.getKey();
                StreamOut.transferRanges(newEndpoint, Table.open(table), (Collection<Range<Token>>)ranges, new CountingDownStreamCallback(latch, newEndpoint), OperationType.UNBOOTSTRAP);
            }
        }
        return latch;
    }

    private CountDownLatch requestRanges(Map<String, Multimap<InetAddress, Range<Token>>> ranges) {
        final CountDownLatch latch = new CountDownLatch(ranges.keySet().size());
        for (Map.Entry<String, Multimap<InetAddress, Range<Token>>> entry : ranges.entrySet()) {
            Multimap<InetAddress, Range<Token>> endpointWithRanges = entry.getValue();
            if (endpointWithRanges.isEmpty()) {
                latch.countDown();
                continue;
            }
            String table = entry.getKey();
            final HashSet pending = new HashSet(endpointWithRanges.keySet());
            for (final InetAddress source : endpointWithRanges.keySet()) {
                Collection toFetch = endpointWithRanges.get((Object)source);
                IStreamCallback callback = new IStreamCallback(){

                    @Override
                    public void onSuccess() {
                        pending.remove(source);
                        if (pending.isEmpty()) {
                            latch.countDown();
                        }
                    }

                    @Override
                    public void onFailure() {
                        logger.warn("Streaming from " + source + " failed");
                        this.onSuccess();
                    }
                };
                if (logger.isDebugEnabled()) {
                    logger.debug("Requesting from " + source + " ranges " + StringUtils.join((Collection)toFetch, (String)", "));
                }
                StreamIn.requestRanges(source, table, toFetch, callback, OperationType.BOOTSTRAP);
            }
        }
        return latch;
    }

    public Pair<Set<Range<Token>>, Set<Range<Token>>> calculateStreamAndFetchRanges(Collection<Range<Token>> current, Collection<Range<Token>> updated) {
        boolean intersect;
        HashSet<Range<Token>> toStream = new HashSet<Range<Token>>();
        HashSet<Range<Token>> toFetch = new HashSet<Range<Token>>();
        for (Range<Token> r1 : current) {
            intersect = false;
            for (Range<Token> r2 : updated) {
                if (!r1.intersects(r2)) continue;
                toStream.addAll(r1.subtract(r2));
                intersect = true;
            }
            if (intersect) continue;
            toStream.add(r1);
        }
        for (Range<Token> r2 : updated) {
            intersect = false;
            for (Range<Token> r1 : current) {
                if (!r2.intersects(r1)) continue;
                toFetch.addAll(r2.subtract(r1));
                intersect = true;
            }
            if (intersect) continue;
            toFetch.add(r2);
        }
        return Pair.create(toStream, toFetch);
    }

    @Override
    public void bulkLoad(String directory) {
        File dir = new File(directory);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException("Invalid directory " + directory);
        }
        SSTableLoader.Client client = new SSTableLoader.Client(){

            @Override
            public void init(String keyspace) {
                try {
                    this.setPartitioner(DatabaseDescriptor.getPartitioner());
                    for (Map.Entry<Range<Token>, List<InetAddress>> entry : instance.getRangeToAddressMap(keyspace).entrySet()) {
                        Range<Token> range = entry.getKey();
                        for (InetAddress endpoint : entry.getValue()) {
                            this.addRangeForEndpoint(range, endpoint);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean validateColumnFamily(String keyspace, String cfName) {
                return Schema.instance.getCFMetaData(keyspace, cfName) != null;
            }
        };
        SSTableLoader loader = new SSTableLoader(dir, client, new OutputHandler.LogOutput());
        try {
            loader.stream().get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getExceptionCount() {
        return (int)StorageMetrics.exceptions.count();
    }

    @Override
    public void rescheduleFailedDeletions() {
        SSTableDeletingTask.rescheduleFailedTasks();
    }

    @Override
    public void loadNewSSTables(String ksName, String cfName) {
        ColumnFamilyStore.loadNewSSTables(ksName, cfName);
    }

    @Override
    public List<String> sampleKeyRange() {
        ArrayList<DecoratedKey> keys = new ArrayList<DecoratedKey>();
        for (Table keyspace : Table.nonSystem()) {
            for (Range<Token> range : this.getPrimaryRangesForEndpoint(keyspace.name, FBUtilities.getBroadcastAddress())) {
                keys.addAll(this.keySamples(keyspace.getColumnFamilyStores(), range));
            }
        }
        ArrayList<String> sampledKeys = new ArrayList<String>(keys.size());
        for (DecoratedKey key : keys) {
            sampledKeys.add(key.getToken().toString());
        }
        return sampledKeys;
    }

    @Override
    public void rebuildSecondaryIndex(String ksName, String cfName, String ... idxNames) {
        ColumnFamilyStore.rebuildSecondaryIndex(ksName, cfName, idxNames);
    }

    @Override
    public void resetLocalSchema() throws IOException {
        MigrationManager.resetLocalSchema();
    }

    @Override
    public void setTraceProbability(double probability) {
        this.tracingProbability = probability;
    }

    @Override
    public double getTracingProbability() {
        return this.tracingProbability;
    }

    @Override
    public void enableScheduledRangeXfers() {
        rangeXferExecutor.setup();
    }

    @Override
    public void disableScheduledRangeXfers() {
        rangeXferExecutor.tearDown();
    }

    @Override
    public String getClusterName() {
        return DatabaseDescriptor.getClusterName();
    }

    @Override
    public String getPartitionerName() {
        return DatabaseDescriptor.getPartitionerName();
    }

    @Override
    public int getTombstoneDebugThreshold() {
        return DatabaseDescriptor.getTombstoneDebugThreshold();
    }

    @Override
    public void setTombstoneDebugThreshold(int tombstoneDebugThreshold) {
        DatabaseDescriptor.setTombstoneDebugThreshold(tombstoneDebugThreshold);
    }

    static {
        tasks.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        instance = new StorageService();
        metrics = new StorageMetrics();
        nextRepairCommand = new AtomicInteger();
        rangeXferExecutor = new ScheduledRangeTransferExecutorService();
    }

    static class CountingDownStreamCallback
    implements IStreamCallback {
        private final CountDownLatch latch;
        private final InetAddress targetAddr;

        CountingDownStreamCallback(CountDownLatch latch, InetAddress targetAddr) {
            this.latch = latch;
            this.targetAddr = targetAddr;
        }

        @Override
        public void onSuccess() {
            this.latch.countDown();
        }

        @Override
        public void onFailure() {
            logger.warn("Streaming to " + this.targetAddr + " failed");
            this.onSuccess();
        }
    }

    private class RangeRelocator {
        private Map<String, Multimap<InetAddress, Range<Token>>> rangesToFetch = new HashMap<String, Multimap<InetAddress, Range<Token>>>();
        private Map<String, Multimap<Range<Token>, InetAddress>> rangesToStreamByTable = new HashMap<String, Multimap<Range<Token>, InetAddress>>();

        private RangeRelocator(Collection<Token> tokens, List<String> tables) {
            this.calculateToFromStreams(tokens, tables);
        }

        private void calculateToFromStreams(Collection<Token> newTokens, List<String> tables) {
            InetAddress localAddress = FBUtilities.getBroadcastAddress();
            IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
            TokenMetadata tokenMetaCloneAllSettled = StorageService.this.tokenMetadata.cloneAfterAllSettled();
            TokenMetadata tokenMetaClone = StorageService.this.tokenMetadata.cloneOnlyTokenMap();
            for (String table : tables) {
                for (Token newToken : newTokens) {
                    AbstractReplicationStrategy strategy = Table.open(table).getReplicationStrategy();
                    Collection<Range<Token>> currentRanges = StorageService.this.getRangesForEndpoint(table, localAddress);
                    Collection<Range<Token>> updatedRanges = strategy.getPendingAddressRanges(StorageService.this.tokenMetadata, newToken, localAddress);
                    Multimap<Range<Token>, InetAddress> rangeAddresses = strategy.getRangeAddresses(tokenMetaClone);
                    Pair<Set<Range<Token>>, Set<Range<Token>>> rangesPerTable = StorageService.this.calculateStreamAndFetchRanges(currentRanges, updatedRanges);
                    ArrayListMultimap rangesToFetchWithPreferredEndpoints = ArrayListMultimap.create();
                    for (Range toFetch : (Set)rangesPerTable.right) {
                        for (Range range : rangeAddresses.keySet()) {
                            if (!range.contains(toFetch)) continue;
                            List<InetAddress> endpoints = snitch.getSortedListByProximity(localAddress, rangeAddresses.get((Object)range));
                            rangesToFetchWithPreferredEndpoints.putAll((Object)toFetch, endpoints);
                        }
                    }
                    HashMultimap rangeWithEndpoints = HashMultimap.create();
                    for (Range toStream : (Set)rangesPerTable.left) {
                        ImmutableSet currentEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)toStream.right, tokenMetaClone));
                        ImmutableSet newEndpoints = ImmutableSet.copyOf(strategy.calculateNaturalEndpoints((Token)toStream.right, tokenMetaCloneAllSettled));
                        logger.debug("Range:" + toStream + "Current endpoints: " + currentEndpoints + " New endpoints: " + newEndpoints);
                        rangeWithEndpoints.putAll((Object)toStream, (Iterable)Sets.difference((Set)newEndpoints, (Set)currentEndpoints));
                    }
                    this.rangesToStreamByTable.put(table, (Multimap<Range<Token>, InetAddress>)rangeWithEndpoints);
                    Multimap<InetAddress, Range<Token>> workMap = RangeStreamer.getWorkMap((Multimap<Range<Token>, InetAddress>)rangesToFetchWithPreferredEndpoints);
                    this.rangesToFetch.put(table, workMap);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Table {}: work map {}.", (Object)table, workMap);
                }
            }
        }

        private void logStreamsMap(String prefix) {
            logger.debug("{} Work map: {}", (Object)prefix, this.rangesToStreamByTable);
        }

        private void logRequestsMap(String prefix) {
            logger.debug("{} Work map: {}", (Object)prefix, this.rangesToFetch);
        }

        private boolean streamsNeeded() {
            return !this.rangesToStreamByTable.isEmpty() || !this.rangesToFetch.isEmpty();
        }

        private CountDownLatch streams() {
            return StorageService.this.streamRanges(this.rangesToStreamByTable);
        }

        private CountDownLatch requests() {
            return StorageService.this.requestRanges(this.rangesToFetch);
        }
    }

    private static enum Mode {
        NORMAL,
        CLIENT,
        JOINING,
        LEAVING,
        DECOMMISSIONED,
        MOVING,
        DRAINING,
        DRAINED,
        RELOCATING;

    }
}

