/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.transport.messages.ResultMessage;

public class DropIndexStatement
extends SchemaAlteringStatement {
    public final String indexName;

    public DropIndexStatement(String indexName) {
        super(new CFName());
        this.indexName = indexName;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.findIndexedCF().cfName, Permission.ALTER);
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.UPDATED;
    }

    @Override
    public void announceMigration() throws InvalidRequestException, ConfigurationException {
        CFMetaData updatedCfm = this.updateCFMetadata(this.findIndexedCF());
        MigrationManager.announceColumnFamilyUpdate(updatedCfm);
    }

    private CFMetaData updateCFMetadata(CFMetaData cfm) throws InvalidRequestException {
        ColumnDefinition column = this.findIndexedColumn(cfm);
        assert (column != null);
        CFMetaData cloned = cfm.clone();
        ColumnDefinition toChange = cloned.getColumn_metadata().get(column.name);
        assert (toChange.getIndexName() != null && toChange.getIndexName().equals(this.indexName));
        toChange.setIndexName(null);
        toChange.setIndexType(null, null);
        return cloned;
    }

    private CFMetaData findIndexedCF() throws InvalidRequestException {
        KSMetaData ksm = Schema.instance.getTableDefinition(this.keyspace());
        for (CFMetaData cfm : ksm.cfMetaData().values()) {
            if (this.findIndexedColumn(cfm) == null) continue;
            return cfm;
        }
        throw new InvalidRequestException("Index '" + this.indexName + "' could not be found in any of the column families of keyspace '" + this.keyspace() + "'");
    }

    private ColumnDefinition findIndexedColumn(CFMetaData cfm) {
        for (ColumnDefinition column : cfm.getColumn_metadata().values()) {
            if (column.getIndexType() == null || column.getIndexName() == null || !column.getIndexName().equals(this.indexName)) continue;
            return column;
        }
        return null;
    }
}

