/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.streaming.StreamOutSession;
import org.apache.cassandra.streaming.StreamReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamReplyVerbHandler
implements IVerbHandler<StreamReply> {
    private static final Logger logger = LoggerFactory.getLogger(StreamReplyVerbHandler.class);

    @Override
    public void doVerb(MessageIn<StreamReply> message, String id) {
        StreamReply reply = (StreamReply)message.payload;
        logger.debug("Received StreamReply {}", (Object)reply);
        StreamOutSession session = StreamOutSession.get(reply.sessionId);
        if (session == null) {
            logger.debug("Received stream action " + (Object)((Object)reply.action) + " for an unknown session from " + message.from);
            return;
        }
        switch (reply.action) {
            case FILE_FINISHED: {
                logger.info("Successfully sent {} to {}", (Object)reply.file, (Object)message.from);
                session.validateCurrentFile(reply.file);
                session.startNext();
                break;
            }
            case FILE_RETRY: {
                session.validateCurrentFile(reply.file);
                logger.info("Need to re-stream file {} to {}", (Object)reply.file, (Object)message.from);
                session.retry();
                break;
            }
            case SESSION_FINISHED: {
                session.close(true);
                break;
            }
            case SESSION_FAILURE: {
                session.close(false);
                break;
            }
            default: {
                throw new RuntimeException("Cannot handle FileStatus.Action: " + (Object)((Object)reply.action));
            }
        }
    }
}

