/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.migration.avro.CfDef;
import org.apache.cassandra.db.migration.avro.ColumnDef;
import org.apache.cassandra.db.migration.avro.KsDef;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.utils.ByteBufferUtil;

public class Avro {
    @Deprecated
    public static KSMetaData ksFromAvro(KsDef ks) {
        Class<?> repStratClass;
        try {
            String strategyClassName = KSMetaData.convertOldStrategyName(ks.strategy_class.toString());
            repStratClass = Class.forName(strategyClassName);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not create ReplicationStrategy of type " + ks.strategy_class, ex);
        }
        HashMap<String, String> strategyOptions = new HashMap<String, String>();
        if (ks.strategy_options != null) {
            for (Map.Entry<CharSequence, CharSequence> e : ks.strategy_options.entrySet()) {
                String name = e.getKey().toString();
                if (repStratClass == NetworkTopologyStrategy.class && name.trim().toLowerCase().equals("replication_factor")) continue;
                strategyOptions.put(name, e.getValue().toString());
            }
        }
        Avro.maybeAddReplicationFactor(strategyOptions, ks.strategy_class.toString(), ks.replication_factor);
        int cfsz = ks.cf_defs.size();
        ArrayList<CFMetaData> cfMetaData = new ArrayList<CFMetaData>(cfsz);
        for (CfDef cf_def : ks.cf_defs) {
            double rowsCached;
            double keysCached = cf_def.key_cache_size == null ? -1.0 : cf_def.key_cache_size;
            double d = rowsCached = cf_def.row_cache_size == null ? -1.0 : cf_def.row_cache_size;
            cf_def.caching = keysCached > 0.0 && rowsCached > 0.0 ? CFMetaData.Caching.ALL.name() : (keysCached <= 0.0 && rowsCached <= 0.0 ? CFMetaData.Caching.NONE.name() : (keysCached > 0.0 && rowsCached <= 0.0 ? CFMetaData.Caching.KEYS_ONLY.name() : CFMetaData.Caching.ROWS_ONLY.name()));
            cfMetaData.add(Avro.cfFromAvro(cf_def));
        }
        return new KSMetaData(ks.name.toString(), repStratClass, strategyOptions, ks.durable_writes, cfMetaData);
    }

    @Deprecated
    private static void maybeAddReplicationFactor(Map<String, String> options, String cls, Integer rf) {
        if (rf != null && (cls.endsWith("SimpleStrategy") || cls.endsWith("OldNetworkTopologyStrategy"))) {
            options.put("replication_factor", rf.toString());
        }
    }

    @Deprecated
    public static CFMetaData cfFromAvro(CfDef cf) {
        CFMetaData.Caching caching;
        CompressionParameters cp;
        AbstractType<?> keyValidator;
        AbstractType<?> validator;
        AbstractType<?> comparator;
        AbstractType<?> subcolumnComparator = null;
        try {
            comparator = TypeParser.parse(cf.comparator_type.toString());
            if (cf.subcomparator_type != null) {
                subcolumnComparator = TypeParser.parse(cf.subcomparator_type);
            }
            validator = TypeParser.parse(cf.default_validation_class);
            keyValidator = TypeParser.parse(cf.key_validation_class);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not inflate CFMetaData for " + (Object)((Object)cf), ex);
        }
        TreeMap<ByteBuffer, ColumnDefinition> column_metadata = new TreeMap<ByteBuffer, ColumnDefinition>(BytesType.instance);
        for (ColumnDef aColumn_metadata : cf.column_metadata) {
            ColumnDefinition cd = Avro.columnFromAvro(aColumn_metadata);
            if (cd.getIndexType() != null && cd.getIndexName() == null) {
                cd.setIndexName(CFMetaData.getDefaultIndexName(cf.name.toString(), comparator, cd.name));
            }
            column_metadata.put(cd.name, cd);
        }
        CFMetaData newCFMD = new CFMetaData(cf.keyspace.toString(), cf.name.toString(), ColumnFamilyType.create(cf.column_type.toString()), comparator, subcolumnComparator);
        if (cf.min_compaction_threshold != null) {
            newCFMD.minCompactionThreshold(cf.min_compaction_threshold);
        }
        if (cf.max_compaction_threshold != null) {
            newCFMD.maxCompactionThreshold(cf.max_compaction_threshold);
        }
        if (cf.key_alias != null) {
            newCFMD.keyAliases(Collections.singletonList(cf.key_alias));
        }
        if (cf.column_aliases != null) {
            newCFMD.columnAliases(new ArrayList<ByteBuffer>(cf.column_aliases));
        }
        if (cf.value_alias != null) {
            newCFMD.valueAlias(cf.value_alias);
        }
        if (cf.compaction_strategy != null) {
            try {
                newCFMD.compactionStrategyClass = CFMetaData.createCompactionStrategy(cf.compaction_strategy.toString());
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        if (cf.compaction_strategy_options != null) {
            for (Map.Entry<CharSequence, CharSequence> e : cf.compaction_strategy_options.entrySet()) {
                newCFMD.compactionStrategyOptions.put(e.getKey().toString(), e.getValue().toString());
            }
        }
        try {
            cp = CompressionParameters.create(cf.compression_options);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            caching = cf.caching == null ? CFMetaData.DEFAULT_CACHING_STRATEGY : CFMetaData.Caching.fromString(cf.caching.toString());
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        Schema.instance.addOldCfIdMapping(cf.id, newCFMD.cfId);
        return newCFMD.comment(cf.comment.toString()).readRepairChance(cf.read_repair_chance).dcLocalReadRepairChance(cf.dclocal_read_repair_chance).replicateOnWrite(cf.replicate_on_write).gcGraceSeconds(cf.gc_grace_seconds).defaultValidator(validator).keyValidator(keyValidator).columnMetadata(column_metadata).compressionParameters(cp).bloomFilterFpChance(cf.bloom_filter_fp_chance).caching(caching);
    }

    @Deprecated
    public static ColumnDefinition columnFromAvro(ColumnDef cd) {
        IndexType index_type = cd.index_type == null ? null : Enum.valueOf(IndexType.class, cd.index_type.name());
        String index_name = cd.index_name == null ? null : cd.index_name.toString();
        try {
            AbstractType<?> validatorType = TypeParser.parse(cd.validation_class);
            return new ColumnDefinition(ByteBufferUtil.clone(cd.name), validatorType, index_type, ColumnDefinition.getStringMap(cd.index_options), index_name, null);
        }
        catch (RequestValidationException e) {
            throw new RuntimeException(e);
        }
    }
}

