/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Objects;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.DateType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;

public abstract class Selector {
    public abstract ColumnIdentifier id();

    public boolean hasFunction() {
        return false;
    }

    public Function function() {
        return null;
    }

    public boolean hasKey() {
        return false;
    }

    public Term key() {
        return null;
    }

    public static class WithKey
    extends Selector {
        private final ColumnIdentifier id;
        private final Term key;

        public WithKey(ColumnIdentifier id, Term key) {
            this.id = id;
            this.key = key;
        }

        @Override
        public ColumnIdentifier id() {
            return this.id;
        }

        @Override
        public boolean hasKey() {
            return true;
        }

        @Override
        public Term key() {
            return this.key;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.id, this.key});
        }

        public final boolean equals(Object o) {
            if (!(o instanceof WithKey)) {
                return false;
            }
            WithKey that = (WithKey)o;
            return this.id().equals(that.id()) && this.key.equals(that.key);
        }

        public String toString() {
            return this.id + "[" + this.key + "]";
        }
    }

    public static class WithFunction
    extends Selector {
        private final Function function;
        private final ColumnIdentifier id;

        public WithFunction(ColumnIdentifier id, Function function) {
            this.id = id;
            this.function = function;
        }

        @Override
        public ColumnIdentifier id() {
            return this.id;
        }

        @Override
        public boolean hasFunction() {
            return true;
        }

        @Override
        public Function function() {
            return this.function;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.function, this.id});
        }

        public final boolean equals(Object o) {
            if (!(o instanceof WithFunction)) {
                return false;
            }
            WithFunction that = (WithFunction)o;
            return this.id().equals(((Selector)that).id()) && this.function() == ((Selector)that).function();
        }

        public String toString() {
            return (Object)((Object)this.function) + "(" + this.id + ")";
        }
    }

    public static enum Function {
        WRITE_TIME(LongType.instance),
        TTL(Int32Type.instance),
        DATE_OF(DateType.instance),
        UNIXTIMESTAMP_OF(LongType.instance);

        public final AbstractType<?> resultType;

        private Function(AbstractType<?> resultType) {
            this.resultType = resultType;
        }

        public String toString() {
            switch (this) {
                case WRITE_TIME: {
                    return "writetime";
                }
                case TTL: {
                    return "ttl";
                }
                case DATE_OF: {
                    return "dateof";
                }
                case UNIXTIMESTAMP_OF: {
                    return "unixtimestampof";
                }
            }
            throw new AssertionError();
        }
    }
}

