/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Random;
import java.util.UUID;
import org.apache.cassandra.utils.FBUtilities;

public class UUIDGen {
    private static final long START_EPOCH = -12219292800000L;
    private static final long clockSeqAndNode = UUIDGen.makeClockSeqAndNode();
    private static final UUIDGen instance = new UUIDGen();
    private long lastNanos;

    private UUIDGen() {
        if (clockSeqAndNode == 0L) {
            throw new RuntimeException("singleton instantiation is misplaced.");
        }
    }

    public static UUID getTimeUUID() {
        return new UUID(instance.createTimeSafe(), clockSeqAndNode);
    }

    public static UUID getUUID(ByteBuffer raw) {
        return new UUID(raw.getLong(raw.position()), raw.getLong(raw.position() + 8));
    }

    public static byte[] decompose(UUID uuid) {
        long most = uuid.getMostSignificantBits();
        long least = uuid.getLeastSignificantBits();
        byte[] b = new byte[16];
        for (int i = 0; i < 8; ++i) {
            b[i] = (byte)(most >>> (7 - i) * 8);
            b[8 + i] = (byte)(least >>> (7 - i) * 8);
        }
        return b;
    }

    public static byte[] getTimeUUIDBytes() {
        return UUIDGen.createTimeUUIDBytes(instance.createTimeSafe());
    }

    public static byte[] getTimeUUIDBytes(long timeMillis) {
        return UUIDGen.createTimeUUIDBytes(instance.createTimeUnsafe(timeMillis));
    }

    public static byte[] getTimeUUIDBytes(long timeMillis, int nanos) {
        if (nanos >= 10000) {
            throw new IllegalArgumentException();
        }
        return UUIDGen.createTimeUUIDBytes(instance.createTimeUnsafe(timeMillis, nanos));
    }

    private static byte[] createTimeUUIDBytes(long msb) {
        int i;
        long lsb = clockSeqAndNode;
        byte[] uuidBytes = new byte[16];
        for (i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
        }
        for (i = 8; i < 16; ++i) {
            uuidBytes[i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return uuidBytes;
    }

    public static long getAdjustedTimestamp(UUID uuid) {
        if (uuid.version() != 1) {
            throw new IllegalArgumentException("incompatible with uuid version: " + uuid.version());
        }
        return uuid.timestamp() / 10000L + -12219292800000L;
    }

    private static long makeClockSeqAndNode() {
        long clock = new Random(System.currentTimeMillis()).nextLong();
        long lsb = 0L;
        lsb |= Long.MIN_VALUE;
        lsb |= (clock & 0x3FFFL) << 48;
        return lsb |= UUIDGen.makeNode();
    }

    private synchronized long createTimeSafe() {
        long nanosSince = (System.currentTimeMillis() - -12219292800000L) * 10000L;
        if (nanosSince > this.lastNanos) {
            this.lastNanos = nanosSince;
        } else {
            nanosSince = ++this.lastNanos;
        }
        return this.createTime(nanosSince);
    }

    private long createTimeUnsafe(long when) {
        return this.createTimeUnsafe(when, 0);
    }

    private long createTimeUnsafe(long when, int nanos) {
        long nanosSince = (when - -12219292800000L) * 10000L + (long)nanos;
        return this.createTime(nanosSince);
    }

    private long createTime(long nanosSince) {
        long msb = 0L;
        msb |= (0xFFFFFFFFL & nanosSince) << 32;
        msb |= (0xFFFF00000000L & nanosSince) >>> 16;
        msb |= (0xFFFF000000000000L & nanosSince) >>> 48;
        return msb |= 0x1000L;
    }

    private static long makeNode() {
        Collection<InetAddress> localAddresses = FBUtilities.getAllLocalAddresses();
        if (localAddresses.isEmpty()) {
            throw new RuntimeException("Cannot generate the node component of the UUID because cannot retrieve any IP addresses.");
        }
        byte[] hash = UUIDGen.hash(localAddresses);
        long node = 0L;
        for (int i = 0; i < Math.min(6, hash.length); ++i) {
            node |= (0xFFL & (long)hash[i]) << (5 - i) * 8;
        }
        assert ((0xFF00000000000000L & node) == 0L);
        return node | 0x10000000000L;
    }

    private static byte[] hash(Collection<InetAddress> data) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            for (InetAddress addr : data) {
                messageDigest.update(addr.getAddress());
            }
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("MD5 digest algorithm is not available", nsae);
        }
    }
}

