/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.auth.Auth;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.PermissionDetails;
import org.apache.cassandra.auth.Resources;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.statements.AuthorizationStatement;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.messages.ResultMessage;

public class ListPermissionsStatement
extends AuthorizationStatement {
    private static final String KS = "system_auth";
    private static final String CF = "permissions";
    private static final List<ColumnSpecification> metadata;
    private final Set<Permission> permissions;
    private DataResource resource;
    private final String username;
    private final boolean recursive;

    public ListPermissionsStatement(Set<Permission> permissions, IResource resource, String username, boolean recursive) {
        this.permissions = permissions;
        this.resource = (DataResource)resource;
        this.username = username;
        this.recursive = recursive;
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.username != null && !Auth.isExistingUser(this.username)) {
            throw new InvalidRequestException(String.format("User %s doesn't exist", this.username));
        }
        if (this.resource != null) {
            this.resource = ListPermissionsStatement.maybeCorrectResource(this.resource, state);
            if (!this.resource.exists()) {
                throw new InvalidRequestException(String.format("%s doesn't exist", this.resource));
            }
        }
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        state.ensureNotAnonymous();
    }

    @Override
    public ResultMessage execute(ClientState state) throws UnauthorizedException, InvalidRequestException {
        ArrayList<PermissionDetails> details = new ArrayList<PermissionDetails>();
        if (this.resource != null && this.recursive) {
            for (IResource iResource : Resources.chain(this.resource)) {
                details.addAll(this.list(state, iResource));
            }
        } else {
            details.addAll(this.list(state, this.resource));
        }
        Collections.sort(details);
        return this.resultMessage(details);
    }

    private ResultMessage resultMessage(List<PermissionDetails> details) {
        if (details.isEmpty()) {
            return new ResultMessage.Void();
        }
        ResultSet result = new ResultSet(metadata);
        for (PermissionDetails pd : details) {
            result.addColumnValue(UTF8Type.instance.decompose(pd.username));
            result.addColumnValue(UTF8Type.instance.decompose(pd.resource.toString()));
            result.addColumnValue(UTF8Type.instance.decompose(pd.permission.toString()));
        }
        return new ResultMessage.Rows(result);
    }

    private Set<PermissionDetails> list(ClientState state, IResource resource) throws UnauthorizedException, InvalidRequestException {
        return DatabaseDescriptor.getAuthorizer().list(state.getUser(), this.permissions, resource, this.username);
    }

    static {
        ArrayList<ColumnSpecification> columns = new ArrayList<ColumnSpecification>(4);
        columns.add(new ColumnSpecification(KS, CF, new ColumnIdentifier("username", true), UTF8Type.instance));
        columns.add(new ColumnSpecification(KS, CF, new ColumnIdentifier("resource", true), UTF8Type.instance));
        columns.add(new ColumnSpecification(KS, CF, new ColumnIdentifier("permission", true), UTF8Type.instance));
        metadata = Collections.unmodifiableList(columns);
    }
}

