/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.UnknownColumnFamilyException;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema {
    private static final Logger logger = LoggerFactory.getLogger(Schema.class);
    public static final Schema instance = new Schema();
    public static final int NAME_LENGTH = 48;
    private final Map<String, KSMetaData> tables = new NonBlockingHashMap();
    private final Map<String, Table> tableInstances = new NonBlockingHashMap();
    private final BiMap<Pair<String, String>, UUID> cfIdMap = HashBiMap.create();
    private final BiMap<Integer, UUID> oldCfIdMap = HashBiMap.create();
    private volatile UUID version;
    public static final UUID emptyVersion;
    public static final ImmutableSet<String> systemKeyspaceNames;

    public Schema load(Collection<KSMetaData> tableDefs) {
        for (KSMetaData def : tableDefs) {
            this.load(def);
        }
        return this;
    }

    public Schema load(KSMetaData keyspaceDef) {
        for (CFMetaData cfm : keyspaceDef.cfMetaData().values()) {
            this.load(cfm);
        }
        this.setTableDefinition(keyspaceDef);
        return this;
    }

    public Table getTableInstance(String tableName) {
        return this.tableInstances.get(tableName);
    }

    public void storeTableInstance(Table table) {
        if (this.tableInstances.containsKey(table.name)) {
            throw new IllegalArgumentException(String.format("Table %s was already initialized.", table.name));
        }
        this.tableInstances.put(table.name, table);
    }

    public Table removeTableInstance(String tableName) {
        return this.tableInstances.remove(tableName);
    }

    public void clearTableDefinition(KSMetaData ksm) {
        this.tables.remove(ksm.name);
    }

    public CFMetaData getCFMetaData(String tableName, String cfName) {
        assert (tableName != null);
        KSMetaData ksm = this.tables.get(tableName);
        return ksm == null ? null : ksm.cfMetaData().get(cfName);
    }

    public CFMetaData getCFMetaData(UUID cfId) {
        Pair<String, String> cf = this.getCF(cfId);
        return cf == null ? null : this.getCFMetaData((String)cf.left, (String)cf.right);
    }

    public CFMetaData getCFMetaData(Descriptor descriptor) {
        return this.getCFMetaData(descriptor.ksname, descriptor.cfname);
    }

    public ColumnFamilyType getColumnFamilyType(String ksName, String cfName) {
        assert (ksName != null && cfName != null);
        CFMetaData cfMetaData = this.getCFMetaData(ksName, cfName);
        return cfMetaData == null ? null : cfMetaData.cfType;
    }

    public AbstractType<?> getComparator(String ksName, String cfName) {
        assert (ksName != null);
        CFMetaData cfmd = this.getCFMetaData(ksName, cfName);
        if (cfmd == null) {
            throw new IllegalArgumentException("Unknown ColumnFamily " + cfName + " in keyspace " + ksName);
        }
        return cfmd.comparator;
    }

    public AbstractType<?> getSubComparator(String ksName, String cfName) {
        assert (ksName != null);
        return this.getCFMetaData((String)ksName, (String)cfName).subcolumnComparator;
    }

    public AbstractType<?> getValueValidator(String ksName, String cfName, ByteBuffer column) {
        return this.getCFMetaData(ksName, cfName).getValueValidator(column);
    }

    public KSMetaData getKSMetaData(String table) {
        assert (table != null);
        return this.tables.get(table);
    }

    public List<String> getNonSystemTables() {
        return ImmutableList.copyOf((Collection)Sets.difference(this.tables.keySet(), systemKeyspaceNames));
    }

    public KSMetaData getTableDefinition(String table) {
        return this.getKSMetaData(table);
    }

    public Map<String, CFMetaData> getTableMetaData(String tableName) {
        assert (tableName != null);
        KSMetaData ksm = this.tables.get(tableName);
        assert (ksm != null);
        return ksm.cfMetaData();
    }

    public Set<String> getTables() {
        return this.tables.keySet();
    }

    public Collection<KSMetaData> getTableDefinitions() {
        return this.tables.values();
    }

    public void setTableDefinition(KSMetaData ksm) {
        assert (ksm != null);
        this.tables.put(ksm.name, ksm);
    }

    public void addOldCfIdMapping(Integer oldId, UUID newId) {
        if (oldId == null) {
            return;
        }
        this.oldCfIdMap.put((Object)oldId, (Object)newId);
    }

    public UUID convertOldCfId(Integer oldCfId) throws UnknownColumnFamilyException {
        UUID cfId = (UUID)this.oldCfIdMap.get((Object)oldCfId);
        if (cfId == null) {
            throw new UnknownColumnFamilyException("ColumnFamily identified by old " + oldCfId + " was not found.", null);
        }
        return cfId;
    }

    public Integer convertNewCfId(UUID newCfId) {
        return this.oldCfIdMap.containsValue((Object)newCfId) ? (Integer)this.oldCfIdMap.inverse().get((Object)newCfId) : null;
    }

    public Pair<String, String> getCF(UUID cfId) {
        return (Pair)this.cfIdMap.inverse().get((Object)cfId);
    }

    public UUID getId(String ksName, String cfName) {
        return (UUID)this.cfIdMap.get(Pair.create(ksName, cfName));
    }

    public void load(CFMetaData cfm) {
        Pair<String, String> key = Pair.create(cfm.ksName, cfm.cfName);
        if (this.cfIdMap.containsKey(key)) {
            throw new RuntimeException(String.format("Attempting to load already loaded column family %s.%s", cfm.ksName, cfm.cfName));
        }
        logger.debug("Adding {} to cfIdMap", (Object)cfm);
        this.cfIdMap.put(key, (Object)cfm.cfId);
    }

    public void purge(CFMetaData cfm) {
        this.cfIdMap.remove(Pair.create(cfm.ksName, cfm.cfName));
    }

    public UUID getVersion() {
        return this.version;
    }

    public void updateVersion() {
        try {
            MessageDigest versionDigest = MessageDigest.getInstance("MD5");
            for (Row row : SystemTable.serializedSchema()) {
                if (Schema.invalidSchemaRow(row) || Schema.ignoredSchemaRow(row)) continue;
                row.cf.updateDigest(versionDigest);
            }
            this.version = UUID.nameUUIDFromBytes(versionDigest.digest());
            SystemTable.updateSchemaVersion(this.version);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void updateVersionAndAnnounce() {
        this.updateVersion();
        MigrationManager.passiveAnnounce(this.version);
    }

    public synchronized void clear() {
        for (String table : this.getNonSystemTables()) {
            KSMetaData ksm = this.getTableDefinition(table);
            for (CFMetaData cfm : ksm.cfMetaData().values()) {
                this.purge(cfm);
            }
            this.clearTableDefinition(ksm);
        }
        this.updateVersionAndAnnounce();
    }

    public static boolean invalidSchemaRow(Row row) {
        return row.cf == null || row.cf.isMarkedForDelete() && row.cf.isEmpty();
    }

    public static boolean ignoredSchemaRow(Row row) {
        try {
            return systemKeyspaceNames.contains((Object)ByteBufferUtil.string(row.key.key));
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        systemKeyspaceNames = ImmutableSet.of((Object)"system", (Object)"system_traces", (Object)"system_auth");
        try {
            emptyVersion = UUID.nameUUIDFromBytes(MessageDigest.getInstance("MD5").digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }
}

