/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.cassandra.utils.FBUtilities;

public class UUIDGen {
    private static final long START_EPOCH = -12219292800000L;
    private static final long clock = new Random(System.currentTimeMillis()).nextLong();
    private static final UUIDGen instance = new UUIDGen();
    private long lastNanos;
    private final Map<InetAddress, Long> nodeCache = new HashMap<InetAddress, Long>();
    private static final ThreadLocal<MessageDigest> localMD5Digest = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("MD5 digest algorithm is not available", nsae);
            }
        }

        @Override
        public MessageDigest get() {
            MessageDigest digest = (MessageDigest)super.get();
            digest.reset();
            return digest;
        }
    };

    private UUIDGen() {
        if (clock == 0L) {
            throw new RuntimeException("singleton instantiation is misplaced.");
        }
    }

    public static UUID makeType1UUIDFromHost(InetAddress addr) {
        return new UUID(instance.createTimeSafe(), instance.getClockSeqAndNode(addr));
    }

    public static UUID getUUID(ByteBuffer raw) {
        return new UUID(raw.getLong(raw.position()), raw.getLong(raw.position() + 8));
    }

    public static byte[] decompose(UUID uuid) {
        long most = uuid.getMostSignificantBits();
        long least = uuid.getLeastSignificantBits();
        byte[] b = new byte[16];
        for (int i = 0; i < 8; ++i) {
            b[i] = (byte)(most >>> (7 - i) * 8);
            b[8 + i] = (byte)(least >>> (7 - i) * 8);
        }
        return b;
    }

    public static byte[] getTimeUUIDBytes() {
        return UUIDGen.createTimeUUIDBytes(instance.createTimeSafe());
    }

    public static byte[] getTimeUUIDBytes(long timeMillis) {
        return UUIDGen.createTimeUUIDBytes(instance.createTimeUnsafe(timeMillis));
    }

    public static byte[] getTimeUUIDBytes(long timeMillis, int nanos) {
        if (nanos >= 10000) {
            throw new IllegalArgumentException();
        }
        return UUIDGen.createTimeUUIDBytes(instance.createTimeUnsafe(timeMillis, nanos));
    }

    private static byte[] createTimeUUIDBytes(long msb) {
        int i;
        long lsb = instance.getClockSeqAndNode(FBUtilities.getLocalAddress());
        byte[] uuidBytes = new byte[16];
        for (i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
        }
        for (i = 8; i < 16; ++i) {
            uuidBytes[i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return uuidBytes;
    }

    public static long getAdjustedTimestamp(UUID uuid) {
        if (uuid.version() != 1) {
            throw new IllegalArgumentException("incompatible with uuid version: " + uuid.version());
        }
        return uuid.timestamp() / 10000L + -12219292800000L;
    }

    private long getClockSeqAndNode(InetAddress addr) {
        long lsb = 0L;
        lsb |= Long.MIN_VALUE;
        lsb |= (clock & 0x3FFFL) << 48;
        return lsb |= this.makeNode(addr);
    }

    private synchronized long createTimeSafe() {
        long nanosSince = (System.currentTimeMillis() - -12219292800000L) * 10000L;
        if (nanosSince > this.lastNanos) {
            this.lastNanos = nanosSince;
        } else {
            nanosSince = ++this.lastNanos;
        }
        return this.createTime(nanosSince);
    }

    private long createTimeUnsafe(long when) {
        return this.createTimeUnsafe(when, 0);
    }

    private long createTimeUnsafe(long when, int nanos) {
        long nanosSince = (when - -12219292800000L) * 10000L + (long)nanos;
        return this.createTime(nanosSince);
    }

    private long createTime(long nanosSince) {
        long msb = 0L;
        msb |= (0xFFFFFFFFL & nanosSince) << 32;
        msb |= (0xFFFF00000000L & nanosSince) >>> 16;
        msb |= (0xFFFF000000000000L & nanosSince) >>> 48;
        return msb |= 0x1000L;
    }

    private long makeNode(InetAddress addr) {
        if (this.nodeCache.containsKey(addr)) {
            return this.nodeCache.get(addr);
        }
        byte[] hash = UUIDGen.hash(addr.toString());
        long node = 0L;
        for (int i = 0; i < Math.min(6, hash.length); ++i) {
            node |= (0xFFL & (long)hash[i]) << (5 - i) * 8;
        }
        assert ((0xFF00000000000000L & node) == 0L);
        this.nodeCache.put(addr, node);
        return node;
    }

    private static byte[] hash(String ... data) {
        MessageDigest messageDigest = localMD5Digest.get();
        for (String block : data) {
            messageDigest.update(block.getBytes());
        }
        return messageDigest.digest();
    }
}

