/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ReadyMessage;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class CredentialsMessage
extends Message.Request {
    public static final Message.Codec<CredentialsMessage> codec = new Message.Codec<CredentialsMessage>(){

        @Override
        public CredentialsMessage decode(ChannelBuffer body) {
            CredentialsMessage msg = new CredentialsMessage();
            int count = body.readUnsignedShort();
            for (int i = 0; i < count; ++i) {
                String key = CBUtil.readString(body);
                String value = CBUtil.readString(body);
                msg.credentials.put(key, value);
            }
            return msg;
        }

        @Override
        public ChannelBuffer encode(CredentialsMessage msg) {
            ChannelBuffer cb = ChannelBuffers.dynamicBuffer();
            cb.writeShort(msg.credentials.size());
            for (Map.Entry<String, String> entry : msg.credentials.entrySet()) {
                cb.writeBytes(CBUtil.stringToCB(entry.getKey()));
                cb.writeBytes(CBUtil.stringToCB(entry.getValue()));
            }
            return cb;
        }
    };
    public final Map<String, String> credentials = new HashMap<String, String>();

    public CredentialsMessage() {
        super(Message.Type.CREDENTIALS);
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this);
    }

    @Override
    public Message.Response execute(QueryState state) {
        try {
            state.getClientState().login(this.credentials);
            return new ReadyMessage();
        }
        catch (AuthenticationException e) {
            return ErrorMessage.fromException(e);
        }
    }

    public String toString() {
        return "CREDENTIALS " + this.credentials;
    }
}

