/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import com.google.common.base.Stopwatch;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.helpers.MessageFormatter;

public class TraceState {
    public final UUID sessionId;
    public final InetAddress coordinator;
    public final Stopwatch watch;
    public final ByteBuffer sessionIdBytes;
    public final boolean isLocallyOwned;

    public TraceState(InetAddress coordinator, UUID sessionId, boolean locallyOwned) {
        assert (coordinator != null);
        assert (sessionId != null);
        this.coordinator = coordinator;
        this.sessionId = sessionId;
        this.isLocallyOwned = locallyOwned;
        this.sessionIdBytes = ByteBufferUtil.bytes(sessionId);
        this.watch = new Stopwatch();
        this.watch.start();
    }

    public int elapsed() {
        long elapsed = this.watch.elapsedTime(TimeUnit.MICROSECONDS);
        return elapsed < Integer.MAX_VALUE ? (int)elapsed : Integer.MAX_VALUE;
    }

    public void trace(String format, Object arg) {
        this.trace(MessageFormatter.format((String)format, (Object)arg).getMessage());
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.trace(MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage());
    }

    public void trace(String format, Object[] args) {
        this.trace(MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage());
    }

    public void trace(final String message) {
        final int elapsed = this.elapsed();
        final ByteBuffer eventId = ByteBufferUtil.bytes(UUIDGen.makeType1UUIDFromHost(FBUtilities.getBroadcastAddress()));
        final String threadName = Thread.currentThread().getName();
        StageManager.getStage(Stage.TRACING).execute(new WrappedRunnable(){

            @Override
            public void runMayThrow() throws Exception {
                CFMetaData cfMeta = CFMetaData.TraceEventsCf;
                ColumnFamily cf = ColumnFamily.create(cfMeta);
                Tracing.addColumn(cf, Tracing.buildName(cfMeta, eventId, ByteBufferUtil.bytes("source")), FBUtilities.getBroadcastAddress());
                Tracing.addColumn(cf, Tracing.buildName(cfMeta, eventId, ByteBufferUtil.bytes("thread")), threadName);
                Tracing.addColumn(cf, Tracing.buildName(cfMeta, eventId, ByteBufferUtil.bytes("source_elapsed")), elapsed);
                Tracing.addColumn(cf, Tracing.buildName(cfMeta, eventId, ByteBufferUtil.bytes("activity")), message);
                RowMutation mutation = new RowMutation("system_traces", TraceState.this.sessionIdBytes);
                mutation.add(cf);
                StorageProxy.mutate(Arrays.asList(mutation), ConsistencyLevel.ANY);
            }
        });
    }
}

