/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Objects;
import java.io.File;
import java.util.StringTokenizer;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.utils.FilterFactory;
import org.apache.cassandra.utils.Pair;

public class Descriptor {
    public final File directory;
    public final Version version;
    public final String ksname;
    public final String cfname;
    public final int generation;
    public final boolean temporary;
    private final int hashCode;

    public Descriptor(File directory, String ksname, String cfname, int generation, boolean temp) {
        this(Version.CURRENT, directory, ksname, cfname, generation, temp);
    }

    public Descriptor(String version, File directory, String ksname, String cfname, int generation, boolean temp) {
        this(new Version(version), directory, ksname, cfname, generation, temp);
    }

    public Descriptor(Version version, File directory, String ksname, String cfname, int generation, boolean temp) {
        assert (version != null && directory != null && ksname != null && cfname != null);
        this.version = version;
        this.directory = directory;
        this.ksname = ksname;
        this.cfname = cfname;
        this.generation = generation;
        this.temporary = temp;
        this.hashCode = Objects.hashCode((Object[])new Object[]{directory, generation, ksname, cfname});
    }

    public Descriptor withGeneration(int newGeneration) {
        return new Descriptor(this.version, this.directory, this.ksname, this.cfname, newGeneration, this.temporary);
    }

    public String filenameFor(Component component) {
        return this.filenameFor(component.name());
    }

    private String baseFilename() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.directory).append(File.separatorChar);
        buff.append(this.ksname).append('-');
        buff.append(this.cfname).append('-');
        if (this.temporary) {
            buff.append("tmp").append('-');
        }
        if (!Version.LEGACY.equals(this.version)) {
            buff.append(this.version).append('-');
        }
        buff.append(this.generation);
        return buff.toString();
    }

    public String filenameFor(String suffix) {
        return this.baseFilename() + '-' + suffix;
    }

    public static Descriptor fromFilename(String filename) {
        File file = new File(filename);
        return (Descriptor)Descriptor.fromFilename((File)file.getParentFile(), (String)file.getName()).left;
    }

    public static Pair<Descriptor, String> fromFilename(File directory, String name) {
        StringTokenizer st = new StringTokenizer(name, String.valueOf('-'));
        String ksname = st.nextToken();
        String cfname = st.nextToken();
        String nexttok = st.nextToken();
        boolean temporary = false;
        if (nexttok.equals("tmp")) {
            temporary = true;
            nexttok = st.nextToken();
        }
        Version version = Version.LEGACY;
        if (Version.validate(nexttok)) {
            version = new Version(nexttok);
            nexttok = st.nextToken();
        }
        int generation = Integer.parseInt(nexttok);
        String component = st.nextToken();
        directory = directory != null ? directory : new File(".");
        return Pair.create(new Descriptor(version, directory, ksname, cfname, generation, temporary), component);
    }

    public Descriptor asTemporary(boolean temporary) {
        return new Descriptor(this.version, this.directory, this.ksname, this.cfname, this.generation, temporary);
    }

    public boolean isCompatible() {
        return this.version.isCompatible();
    }

    public boolean isStreamCompatible() {
        return this.version.isStreamCompatible();
    }

    public String toString() {
        return this.baseFilename();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Descriptor)) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return that.directory.equals(this.directory) && that.generation == this.generation && that.ksname.equals(this.ksname) && that.cfname.equals(this.cfname);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static class Version {
        private static final String current_version = "ia";
        public static final Version LEGACY = new Version("a");
        public static final Version CURRENT = new Version("ia");
        private final String version;
        public final boolean hasStringsInBloomFilter;
        public final boolean hasIntRowSize;
        public final boolean hasEncodedKeys;
        public final boolean isLatestVersion;
        public final boolean metadataIncludesReplayPosition;
        public final boolean metadataIncludesModernReplayPosition;
        public final boolean tracksMaxTimestamp;
        public final boolean hasCompressionRatio;
        public final boolean hasPartitioner;
        public final boolean tracksTombstones;
        public final boolean hasPromotedIndexes;
        public final FilterFactory.Type filterType;
        public final boolean hasAncestors;

        public Version(String version) {
            this.version = version;
            this.hasStringsInBloomFilter = version.compareTo("c") < 0;
            this.hasIntRowSize = version.compareTo("d") < 0;
            this.hasEncodedKeys = version.compareTo("e") < 0;
            this.metadataIncludesReplayPosition = version.compareTo("g") >= 0;
            this.hasCompressionRatio = version.compareTo("hb") >= 0;
            this.hasPartitioner = version.compareTo("hc") >= 0;
            this.tracksMaxTimestamp = version.compareTo("hd") >= 0;
            this.hasAncestors = version.compareTo("he") >= 0;
            this.metadataIncludesModernReplayPosition = version.compareTo("hf") >= 0;
            this.tracksTombstones = version.compareTo(current_version) >= 0;
            this.hasPromotedIndexes = version.compareTo(current_version) >= 0;
            boolean bl = this.isLatestVersion = version.compareTo(current_version) == 0;
            this.filterType = version.compareTo("f") < 0 ? FilterFactory.Type.SHA : (version.compareTo(current_version) < 0 ? FilterFactory.Type.MURMUR2 : FilterFactory.Type.MURMUR3);
        }

        static boolean validate(String ver) {
            return ver != null && ver.matches("[a-z]+");
        }

        public boolean isCompatible() {
            return this.version.charAt(0) <= Version.CURRENT.version.charAt(0);
        }

        public boolean isStreamCompatible() {
            return this.isCompatible() && this.version.charAt(0) >= 'i';
        }

        public boolean containsTimestamp() {
            return this.version.compareTo("h") >= 0;
        }

        public String toString() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Version)) {
                return false;
            }
            return this.version.equals(((Version)o).version);
        }

        public int hashCode() {
            return this.version.hashCode();
        }
    }
}

