/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ColumnGroupMap;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.transport.messages.ResultMessage;

public abstract class ModificationStatement
extends CFStatement
implements CQLStatement {
    public static final ConsistencyLevel defaultConsistency = ConsistencyLevel.ONE;
    protected Type type;
    private Long timestamp;
    private final int timeToLive;

    public ModificationStatement(CFName name, Attributes attrs) {
        this(name, attrs.timestamp, attrs.timeToLive);
    }

    public ModificationStatement(CFName name, Long timestamp, int timeToLive) {
        super(name);
        this.timestamp = timestamp;
        this.timeToLive = timeToLive;
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.MODIFY);
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.timeToLive < 0) {
            throw new InvalidRequestException("A TTL must be greater or equal to 0");
        }
        if (this.timeToLive > 630720000) {
            throw new InvalidRequestException(String.format("ttl is too large. requested (%d) maximum (%d)", this.timeToLive, 630720000));
        }
    }

    protected abstract void validateConsistency(ConsistencyLevel var1) throws InvalidRequestException;

    @Override
    public ResultMessage execute(ConsistencyLevel cl, QueryState queryState, List<ByteBuffer> variables) throws RequestExecutionException, RequestValidationException {
        if (cl == null) {
            throw new InvalidRequestException("Invalid empty consistency level");
        }
        this.validateConsistency(cl);
        Collection<? extends IMutation> mutations = this.getMutations(variables, false, cl, queryState.getTimestamp());
        assert (this.type != null);
        switch (this.type) {
            case LOGGED: {
                if (mutations.size() > 1) {
                    StorageProxy.mutateAtomically(mutations, cl);
                    break;
                }
                StorageProxy.mutate(mutations, cl);
                break;
            }
            case UNLOGGED: 
            case COUNTER: {
                StorageProxy.mutate(mutations, cl);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return null;
    }

    @Override
    public ResultMessage executeInternal(QueryState queryState) throws RequestValidationException, RequestExecutionException {
        for (IMutation iMutation : this.getMutations(Collections.<ByteBuffer>emptyList(), true, null, queryState.getTimestamp())) {
            iMutation.apply();
        }
        return null;
    }

    public long getTimestamp(long now) {
        return this.timestamp == null ? now : this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isSetTimestamp() {
        return this.timestamp != null;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    protected Map<ByteBuffer, ColumnGroupMap> readRows(List<ByteBuffer> keys, ColumnNameBuilder builder, Set<ByteBuffer> toRead, CompositeType composite, boolean local, ConsistencyLevel cl) throws RequestExecutionException, RequestValidationException {
        try {
            cl.validateForRead(this.keyspace());
        }
        catch (InvalidRequestException e) {
            throw new InvalidRequestException(String.format("Write operation require a read but consistency %s is not supported on reads", new Object[]{cl}));
        }
        ColumnSlice[] slices = new ColumnSlice[toRead.size()];
        int i = 0;
        for (ByteBuffer name : toRead) {
            ByteBuffer start = builder.copy().add(name).build();
            ByteBuffer finish = builder.copy().add(name).buildAsEndOfRange();
            slices[i++] = new ColumnSlice(start, finish);
        }
        ArrayList<ReadCommand> commands = new ArrayList<ReadCommand>(keys.size());
        for (ByteBuffer key : keys) {
            commands.add(new SliceFromReadCommand(this.keyspace(), key, new QueryPath(this.columnFamily()), new SliceQueryFilter(slices, false, Integer.MAX_VALUE)));
        }
        try {
            List<Row> rows = local ? SelectStatement.readLocally(this.keyspace(), commands) : StorageProxy.read(commands, cl);
            HashMap<ByteBuffer, ColumnGroupMap> map = new HashMap<ByteBuffer, ColumnGroupMap>();
            for (Row row : rows) {
                if (row.cf == null || row.cf.isEmpty()) continue;
                ColumnGroupMap.Builder groupBuilder = new ColumnGroupMap.Builder(composite, true);
                for (IColumn column : row.cf) {
                    groupBuilder.add(column);
                }
                List<ColumnGroupMap> groups = groupBuilder.groups();
                assert (groups.isEmpty() || groups.size() == 1);
                if (groups.isEmpty()) continue;
                map.put(row.key.key, groups.get(0));
            }
            return map;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    protected abstract Collection<? extends IMutation> getMutations(List<ByteBuffer> var1, boolean var2, ConsistencyLevel var3, long var4) throws RequestExecutionException, RequestValidationException;

    public abstract ParsedStatement.Prepared prepare(CFDefinition.Name[] var1) throws InvalidRequestException;

    public static enum Type {
        LOGGED,
        UNLOGGED,
        COUNTER;

    }
}

