/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.EnumMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.service.IEndpointLifecycleSubscriber;
import org.apache.cassandra.service.IMigrationListener;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.Frame;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.RequestThreadPoolExecutor;
import org.apache.cassandra.transport.ServerConnection;
import org.apache.cassandra.transport.messages.EventMessage;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Slf4JLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements CassandraDaemon.Server {
    private static final Logger logger;
    private final ConnectionTracker connectionTracker = new ConnectionTracker();
    public final InetSocketAddress socket;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private ChannelFactory factory;
    private ExecutionHandler executionHandler;

    public Server(InetSocketAddress socket) {
        this.socket = socket;
        EventNotifier notifier = new EventNotifier(this);
        StorageService.instance.register(notifier);
        MigrationManager.instance.register(notifier);
    }

    public Server(String hostname, int port) {
        this(new InetSocketAddress(hostname, port));
    }

    public Server(InetAddress host, int port) {
        this(new InetSocketAddress(host, port));
    }

    public Server(int port) {
        this(new InetSocketAddress(port));
    }

    @Override
    public void start() {
        if (this.isRunning.compareAndSet(false, true)) {
            this.run();
        }
    }

    @Override
    public void stop() {
        if (this.isRunning.compareAndSet(true, false)) {
            this.close();
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning.get();
    }

    public void run() {
        this.executionHandler = new ExecutionHandler((Executor)((Object)new RequestThreadPoolExecutor()));
        this.factory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        ServerBootstrap bootstrap = new ServerBootstrap(this.factory);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new PipelineFactory(this));
        logger.info("Starting listening for CQL clients on " + this.socket + "...");
        Channel channel = bootstrap.bind((SocketAddress)this.socket);
        this.connectionTracker.allChannels.add((Object)channel);
    }

    public void close() {
        this.connectionTracker.closeAll();
        this.factory.releaseExternalResources();
        this.factory = null;
        this.executionHandler.releaseExternalResources();
        this.executionHandler = null;
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Slf4JLoggerFactory());
        logger = LoggerFactory.getLogger(Server.class);
    }

    private static class EventNotifier
    implements IEndpointLifecycleSubscriber,
    IMigrationListener {
        private final Server server;

        private EventNotifier(Server server) {
            this.server = server;
        }

        private InetAddress getRpcAddress(InetAddress endpoint) {
            try {
                return InetAddress.getByName(StorageService.instance.getRpcaddress(endpoint));
            }
            catch (UnknownHostException e) {
                logger.error("Problem retrieving RPC address for " + endpoint, (Throwable)e);
                return endpoint;
            }
        }

        @Override
        public void onJoinCluster(InetAddress endpoint) {
            this.server.connectionTracker.send(Event.TopologyChange.newNode(this.getRpcAddress(endpoint), this.server.socket.getPort()));
        }

        @Override
        public void onLeaveCluster(InetAddress endpoint) {
            this.server.connectionTracker.send(Event.TopologyChange.removedNode(this.getRpcAddress(endpoint), this.server.socket.getPort()));
        }

        @Override
        public void onMove(InetAddress endpoint) {
            this.server.connectionTracker.send(Event.TopologyChange.movedNode(this.getRpcAddress(endpoint), this.server.socket.getPort()));
        }

        @Override
        public void onUp(InetAddress endpoint) {
            this.server.connectionTracker.send(Event.StatusChange.nodeUp(this.getRpcAddress(endpoint), this.server.socket.getPort()));
        }

        @Override
        public void onDown(InetAddress endpoint) {
            this.server.connectionTracker.send(Event.StatusChange.nodeDown(this.getRpcAddress(endpoint), this.server.socket.getPort()));
        }

        @Override
        public void onCreateKeyspace(String ksName) {
            this.server.connectionTracker.send(new Event.SchemaChange(Event.SchemaChange.Change.CREATED, ksName));
        }

        @Override
        public void onCreateColumnFamly(String ksName, String cfName) {
            this.server.connectionTracker.send(new Event.SchemaChange(Event.SchemaChange.Change.CREATED, ksName, cfName));
        }

        @Override
        public void onUpdateKeyspace(String ksName) {
            this.server.connectionTracker.send(new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, ksName));
        }

        @Override
        public void onUpdateColumnFamly(String ksName, String cfName) {
            this.server.connectionTracker.send(new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, ksName, cfName));
        }

        @Override
        public void onDropKeyspace(String ksName) {
            this.server.connectionTracker.send(new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, ksName));
        }

        @Override
        public void onDropColumnFamly(String ksName, String cfName) {
            this.server.connectionTracker.send(new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, ksName, cfName));
        }
    }

    private static class PipelineFactory
    implements ChannelPipelineFactory {
        private static final Message.ProtocolDecoder messageDecoder = new Message.ProtocolDecoder();
        private static final Message.ProtocolEncoder messageEncoder = new Message.ProtocolEncoder();
        private static final Frame.Decompressor frameDecompressor = new Frame.Decompressor();
        private static final Frame.Compressor frameCompressor = new Frame.Compressor();
        private static final Frame.Encoder frameEncoder = new Frame.Encoder();
        private static final Message.Dispatcher dispatcher = new Message.Dispatcher();
        private final Server server;

        public PipelineFactory(Server server) {
            this.server = server;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("frameDecoder", (ChannelHandler)new Frame.Decoder(this.server.connectionTracker, ServerConnection.FACTORY));
            pipeline.addLast("frameEncoder", (ChannelHandler)frameEncoder);
            pipeline.addLast("frameDecompressor", (ChannelHandler)frameDecompressor);
            pipeline.addLast("frameCompressor", (ChannelHandler)frameCompressor);
            pipeline.addLast("messageDecoder", (ChannelHandler)messageDecoder);
            pipeline.addLast("messageEncoder", (ChannelHandler)messageEncoder);
            pipeline.addLast("executor", (ChannelHandler)this.server.executionHandler);
            pipeline.addLast("dispatcher", (ChannelHandler)dispatcher);
            return pipeline;
        }
    }

    public static class ConnectionTracker
    implements Connection.Tracker {
        public final ChannelGroup allChannels = new DefaultChannelGroup();
        private final EnumMap<Event.Type, ChannelGroup> groups = new EnumMap(Event.Type.class);

        public ConnectionTracker() {
            for (Event.Type type : Event.Type.values()) {
                this.groups.put(type, (ChannelGroup)new DefaultChannelGroup(type.toString()));
            }
        }

        @Override
        public void addConnection(Channel ch, Connection connection) {
            this.allChannels.add((Object)ch);
        }

        public void register(Event.Type type, Channel ch) {
            this.groups.get((Object)type).add((Object)ch);
        }

        public void unregister(Channel ch) {
            for (ChannelGroup group : this.groups.values()) {
                group.remove((Object)ch);
            }
        }

        public void send(Event event) {
            this.groups.get((Object)event.type).write((Object)new EventMessage(event));
        }

        @Override
        public void closeAll() {
            this.allChannels.close().awaitUninterruptibly();
        }
    }
}

