/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.cassandra.transport.CBUtil;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public abstract class Event {
    public final Type type;

    private Event(Type type) {
        this.type = type;
    }

    public static Event deserialize(ChannelBuffer cb) {
        switch (Enum.valueOf(Type.class, CBUtil.readString(cb).toUpperCase())) {
            case TOPOLOGY_CHANGE: {
                return TopologyChange.deserializeEvent(cb);
            }
            case STATUS_CHANGE: {
                return StatusChange.deserializeEvent(cb);
            }
            case SCHEMA_CHANGE: {
                return SchemaChange.deserializeEvent(cb);
            }
        }
        throw new AssertionError();
    }

    public ChannelBuffer serialize() {
        return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{CBUtil.stringToCB(this.type.toString()), this.serializeEvent()});
    }

    protected abstract ChannelBuffer serializeEvent();

    public static class SchemaChange
    extends Event {
        public final Change change;
        public final String keyspace;
        public final String table;

        public SchemaChange(Change change, String keyspace, String table) {
            super(Type.SCHEMA_CHANGE);
            this.change = change;
            this.keyspace = keyspace;
            this.table = table;
        }

        public SchemaChange(Change change, String keyspace) {
            this(change, keyspace, "");
        }

        private static SchemaChange deserializeEvent(ChannelBuffer cb) {
            Change change = Enum.valueOf(Change.class, CBUtil.readString(cb).toUpperCase());
            String keyspace = CBUtil.readString(cb);
            String table = CBUtil.readString(cb);
            return new SchemaChange(change, keyspace, table);
        }

        @Override
        protected ChannelBuffer serializeEvent() {
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{CBUtil.stringToCB(this.change.toString()), CBUtil.stringToCB(this.keyspace), CBUtil.stringToCB(this.table)});
        }

        public String toString() {
            return (Object)((Object)this.change) + " " + this.keyspace + (this.table.isEmpty() ? "" : "." + this.table);
        }

        public static enum Change {
            CREATED,
            UPDATED,
            DROPPED;

        }
    }

    public static class StatusChange
    extends Event {
        public final Status status;
        public final InetSocketAddress node;

        private StatusChange(Status status, InetSocketAddress node) {
            super(Type.STATUS_CHANGE);
            this.status = status;
            this.node = node;
        }

        public static StatusChange nodeUp(InetAddress host, int port) {
            return new StatusChange(Status.UP, new InetSocketAddress(host, port));
        }

        public static StatusChange nodeDown(InetAddress host, int port) {
            return new StatusChange(Status.DOWN, new InetSocketAddress(host, port));
        }

        private static StatusChange deserializeEvent(ChannelBuffer cb) {
            Status status = Enum.valueOf(Status.class, CBUtil.readString(cb).toUpperCase());
            InetSocketAddress node = CBUtil.readInet(cb);
            return new StatusChange(status, node);
        }

        @Override
        protected ChannelBuffer serializeEvent() {
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{CBUtil.stringToCB(this.status.toString()), CBUtil.inetToCB(this.node)});
        }

        public String toString() {
            return (Object)((Object)this.status) + " " + this.node;
        }

        public static enum Status {
            UP,
            DOWN;

        }
    }

    public static class TopologyChange
    extends Event {
        public final Change change;
        public final InetSocketAddress node;

        private TopologyChange(Change change, InetSocketAddress node) {
            super(Type.TOPOLOGY_CHANGE);
            this.change = change;
            this.node = node;
        }

        public static TopologyChange newNode(InetAddress host, int port) {
            return new TopologyChange(Change.NEW_NODE, new InetSocketAddress(host, port));
        }

        public static TopologyChange removedNode(InetAddress host, int port) {
            return new TopologyChange(Change.REMOVED_NODE, new InetSocketAddress(host, port));
        }

        public static TopologyChange movedNode(InetAddress host, int port) {
            return new TopologyChange(Change.MOVED_NODE, new InetSocketAddress(host, port));
        }

        private static TopologyChange deserializeEvent(ChannelBuffer cb) {
            Change change = Enum.valueOf(Change.class, CBUtil.readString(cb).toUpperCase());
            InetSocketAddress node = CBUtil.readInet(cb);
            return new TopologyChange(change, node);
        }

        @Override
        protected ChannelBuffer serializeEvent() {
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{CBUtil.stringToCB(this.change.toString()), CBUtil.inetToCB(this.node)});
        }

        public String toString() {
            return (Object)((Object)this.change) + " " + this.node;
        }

        public static enum Change {
            NEW_NODE,
            REMOVED_NODE,
            MOVED_NODE;

        }
    }

    public static enum Type {
        TOPOLOGY_CHANGE,
        STATUS_CHANGE,
        SCHEMA_CHANGE;

    }
}

