/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.RangeSliceReply;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeSliceVerbHandler
implements IVerbHandler<RangeSliceCommand> {
    private static final Logger logger = LoggerFactory.getLogger(RangeSliceVerbHandler.class);

    public static List<Row> executeLocally(RangeSliceCommand command) throws ExecutionException, InterruptedException {
        ColumnFamilyStore cfs = Table.open(command.keyspace).getColumnFamilyStore(command.column_family);
        if (cfs.indexManager.hasIndexFor(command.row_filter)) {
            return cfs.search(command.row_filter, command.range, command.maxResults, command.predicate, command.maxIsColumns);
        }
        return cfs.getRangeSlice(command.super_column, command.range, command.maxResults, command.predicate, command.row_filter, command.maxIsColumns, command.isPaging);
    }

    @Override
    public void doVerb(MessageIn<RangeSliceCommand> message, String id) {
        try {
            if (StorageService.instance.isBootstrapMode()) {
                throw new RuntimeException("Cannot service reads while bootstrapping!");
            }
            RangeSliceReply reply = new RangeSliceReply(RangeSliceVerbHandler.executeLocally((RangeSliceCommand)message.payload));
            logger.debug("Enqueuing response to {}", (Object)message.from);
            MessagingService.instance().sendReply(reply.createMessage(), id, message.from);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

