/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.TreeSet;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtendedFilter {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedFilter.class);
    public final ColumnFamilyStore cfs;
    protected final IDiskAtomFilter originalFilter;
    private final int maxResults;
    private final boolean maxIsColumns;
    private final boolean isPaging;

    public static ExtendedFilter create(ColumnFamilyStore cfs, IDiskAtomFilter filter, List<IndexExpression> clause, int maxResults, boolean maxIsColumns, boolean isPaging) {
        if (clause == null || clause.isEmpty()) {
            return new EmptyClauseFilter(cfs, filter, maxResults, maxIsColumns, isPaging);
        }
        if (isPaging) {
            throw new IllegalArgumentException("Cross-row paging is not supported along with index clauses");
        }
        return cfs.getComparator() instanceof CompositeType ? new FilterWithCompositeClauses(cfs, filter, clause, maxResults, maxIsColumns) : new FilterWithClauses(cfs, filter, clause, maxResults, maxIsColumns);
    }

    protected ExtendedFilter(ColumnFamilyStore cfs, IDiskAtomFilter filter, int maxResults, boolean maxIsColumns, boolean isPaging) {
        assert (cfs != null);
        assert (filter != null);
        this.cfs = cfs;
        this.originalFilter = filter;
        this.maxResults = maxResults;
        this.maxIsColumns = maxIsColumns;
        this.isPaging = isPaging;
        if (maxIsColumns) {
            this.originalFilter.updateColumnsLimit(maxResults);
        }
        if (isPaging && (!(this.originalFilter instanceof SliceQueryFilter) || ((SliceQueryFilter)this.originalFilter).finish().remaining() != 0)) {
            throw new IllegalArgumentException("Cross-row paging is only supported for SliceQueryFilter having an empty finish column");
        }
    }

    public int maxRows() {
        return this.maxIsColumns ? Integer.MAX_VALUE : this.maxResults;
    }

    public int maxColumns() {
        return this.maxIsColumns ? this.maxResults : Integer.MAX_VALUE;
    }

    public void updateFilter(int currentColumnsCount) {
        if (this.isPaging) {
            ((SliceQueryFilter)this.initialFilter()).setStart(ByteBufferUtil.EMPTY_BYTE_BUFFER);
        }
        if (!this.maxIsColumns) {
            return;
        }
        int remaining = this.maxResults - currentColumnsCount;
        this.initialFilter().updateColumnsLimit(remaining);
    }

    public int lastCounted(ColumnFamily data) {
        if (this.initialFilter() instanceof SliceQueryFilter) {
            return ((SliceQueryFilter)this.initialFilter()).lastCounted();
        }
        return data.getLiveColumnCount();
    }

    public abstract IDiskAtomFilter initialFilter();

    public IDiskAtomFilter originalFilter() {
        return this.originalFilter;
    }

    public abstract List<IndexExpression> getClause();

    public abstract IDiskAtomFilter getExtraFilter(ColumnFamily var1);

    public abstract ColumnFamily prune(ColumnFamily var1);

    public abstract boolean isSatisfiedBy(ColumnFamily var1, ColumnNameBuilder var2);

    public static boolean satisfies(int comparison, IndexOperator op) {
        switch (op) {
            case EQ: {
                return comparison == 0;
            }
            case GTE: {
                return comparison >= 0;
            }
            case GT: {
                return comparison > 0;
            }
            case LTE: {
                return comparison <= 0;
            }
            case LT: {
                return comparison < 0;
            }
        }
        throw new IllegalStateException();
    }

    private static class EmptyClauseFilter
    extends ExtendedFilter {
        public EmptyClauseFilter(ColumnFamilyStore cfs, IDiskAtomFilter filter, int maxResults, boolean maxIsColumns, boolean isPaging) {
            super(cfs, filter, maxResults, maxIsColumns, isPaging);
        }

        @Override
        public IDiskAtomFilter initialFilter() {
            return this.originalFilter;
        }

        @Override
        public List<IndexExpression> getClause() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IDiskAtomFilter getExtraFilter(ColumnFamily data) {
            return null;
        }

        @Override
        public ColumnFamily prune(ColumnFamily data) {
            return data;
        }

        @Override
        public boolean isSatisfiedBy(ColumnFamily data, ColumnNameBuilder builder) {
            return true;
        }
    }

    private static class FilterWithCompositeClauses
    extends FilterWithClauses {
        public FilterWithCompositeClauses(ColumnFamilyStore cfs, IDiskAtomFilter filter, List<IndexExpression> clause, int maxResults, boolean maxIsColumns) {
            super(cfs, filter, clause, maxResults, maxIsColumns);
        }

        @Override
        protected IDiskAtomFilter computeInitialFilter() {
            int limit = this.originalFilter instanceof SliceQueryFilter ? ((SliceQueryFilter)this.originalFilter).count : Integer.MAX_VALUE;
            return new SliceQueryFilter(ColumnSlice.ALL_COLUMNS_ARRAY, false, limit);
        }
    }

    private static class FilterWithClauses
    extends ExtendedFilter {
        protected final List<IndexExpression> clause;
        protected final IDiskAtomFilter initialFilter;

        public FilterWithClauses(ColumnFamilyStore cfs, IDiskAtomFilter filter, List<IndexExpression> clause, int maxResults, boolean maxIsColumns) {
            super(cfs, filter, maxResults, maxIsColumns, false);
            assert (clause != null);
            this.clause = clause;
            this.initialFilter = this.computeInitialFilter();
        }

        protected IDiskAtomFilter computeInitialFilter() {
            if (this.originalFilter instanceof SliceQueryFilter) {
                if (this.cfs.getMaxRowSize() < (long)DatabaseDescriptor.getColumnIndexSize()) {
                    logger.trace("Expanding slice filter to entire row to cover additional expressions");
                    return new SliceQueryFilter(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER, ((SliceQueryFilter)this.originalFilter).reversed, Integer.MAX_VALUE);
                }
            } else {
                logger.trace("adding columns to original Filter to cover additional expressions");
                assert (this.originalFilter instanceof NamesQueryFilter);
                if (!this.clause.isEmpty()) {
                    TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(this.cfs.getComparator());
                    for (IndexExpression expr : this.clause) {
                        columns.add(expr.column_name);
                    }
                    columns.addAll(((NamesQueryFilter)this.originalFilter).columns);
                    return new NamesQueryFilter(columns);
                }
            }
            return this.originalFilter;
        }

        @Override
        public IDiskAtomFilter initialFilter() {
            return this.initialFilter;
        }

        @Override
        public List<IndexExpression> getClause() {
            return this.clause;
        }

        private boolean needsExtraQuery(ColumnFamily data) {
            if (!(this.originalFilter instanceof SliceQueryFilter)) {
                return false;
            }
            SliceQueryFilter filter = (SliceQueryFilter)this.originalFilter;
            if (filter.slices.length == 1 && filter.start().equals(ByteBufferUtil.EMPTY_BYTE_BUFFER) && filter.finish().equals(ByteBufferUtil.EMPTY_BYTE_BUFFER) && filter.count == Integer.MAX_VALUE) {
                return false;
            }
            for (IndexExpression expr : this.clause) {
                if (data.getColumn(expr.column_name) != null) continue;
                logger.debug("adding extraFilter to cover additional expressions");
                return true;
            }
            return false;
        }

        @Override
        public IDiskAtomFilter getExtraFilter(ColumnFamily data) {
            if (!this.needsExtraQuery(data)) {
                return null;
            }
            TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(this.cfs.getComparator());
            for (IndexExpression expr : this.clause) {
                if (data.getColumn(expr.column_name) != null) continue;
                columns.add(expr.column_name);
            }
            assert (!columns.isEmpty());
            return new NamesQueryFilter(columns);
        }

        @Override
        public ColumnFamily prune(ColumnFamily data) {
            if (this.initialFilter == this.originalFilter) {
                return data;
            }
            ColumnFamily pruned = data.cloneMeShallow();
            OnDiskAtomIterator iter = this.originalFilter.getMemtableColumnIterator(data, null);
            this.originalFilter.collectReducedColumns(pruned, QueryFilter.gatherTombstones(pruned, iter), this.cfs.gcBefore());
            return pruned;
        }

        @Override
        public boolean isSatisfiedBy(ColumnFamily data, ColumnNameBuilder builder) {
            for (IndexExpression expression : this.clause) {
                ByteBuffer colName = builder == null ? expression.column_name : builder.copy().add(expression.column_name).build();
                IColumn column = data.getColumn(colName);
                if (column == null) {
                    return false;
                }
                int v = data.metadata().getValueValidator(expression.column_name).compare(column.value(), expression.value);
                if (FilterWithClauses.satisfies(v, expression.op)) continue;
                return false;
            }
            return true;
        }
    }
}

