/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.ArrayListMultimap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.operations.ColumnOperation;
import org.apache.cassandra.cql3.operations.Operation;
import org.apache.cassandra.cql3.statements.ColumnGroupMap;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public class UpdateStatement
extends ModificationStatement {
    private CFDefinition cfDef;
    private final List<Pair<ColumnIdentifier, Operation>> columns;
    private final List<ColumnIdentifier> columnNames;
    private final List<Operation> columnOperations;
    private final List<Relation> whereClause;
    private final ArrayListMultimap<CFDefinition.Name, Operation> processedColumns = ArrayListMultimap.create();
    private final Map<ColumnIdentifier, List<Term>> processedKeys = new HashMap<ColumnIdentifier, List<Term>>();

    public UpdateStatement(CFName name, List<Pair<ColumnIdentifier, Operation>> columns, List<Relation> whereClause, Attributes attrs) {
        super(name, attrs);
        this.columns = columns;
        this.whereClause = whereClause;
        this.columnNames = null;
        this.columnOperations = null;
    }

    public UpdateStatement(CFName name, Attributes attrs, List<ColumnIdentifier> columnNames, List<Operation> columnOperations) {
        super(name, attrs);
        this.columnNames = columnNames;
        this.columnOperations = columnOperations;
        this.whereClause = null;
        this.columns = null;
    }

    @Override
    protected void validateConsistency(ConsistencyLevel cl) throws InvalidRequestException {
        if (this.type == ModificationStatement.Type.COUNTER) {
            cl.validateCounterForWrite(this.cfDef.cfm);
        } else {
            cl.validateForWrite(this.cfDef.cfm.ksName);
        }
    }

    public Collection<IMutation> getMutations(List<ByteBuffer> variables, boolean local, ConsistencyLevel cl, long now) throws RequestExecutionException, RequestValidationException {
        List<ByteBuffer> keys = UpdateStatement.buildKeyNames(this.cfDef, this.processedKeys, variables);
        ColumnNameBuilder builder = this.cfDef.getColumnNameBuilder();
        UpdateStatement.buildColumnNames(this.cfDef, this.processedKeys, builder, variables, true);
        TreeSet<ByteBuffer> toRead = null;
        for (Map.Entry entry : this.processedColumns.entries()) {
            CFDefinition.Name name = (CFDefinition.Name)entry.getKey();
            Operation value = (Operation)entry.getValue();
            if (!(name.type instanceof ListType) || !value.requiresRead()) continue;
            if (toRead == null) {
                toRead = new TreeSet<ByteBuffer>(UTF8Type.instance);
            }
            toRead.add(name.name.key);
        }
        Map<ByteBuffer, ColumnGroupMap> rows = toRead != null ? this.readRows(keys, builder, toRead, (CompositeType)this.cfDef.cfm.comparator, local, cl) : null;
        LinkedList<IMutation> mutations = new LinkedList<IMutation>();
        UpdateParameters params = new UpdateParameters(variables, this.getTimestamp(now), this.getTimeToLive());
        for (ByteBuffer key : keys) {
            mutations.add(this.mutationForKey(this.cfDef, key, builder, params, rows == null ? null : rows.get(key), cl));
        }
        return mutations;
    }

    static CFDefinition.Name buildColumnNames(CFDefinition cfDef, Map<ColumnIdentifier, List<Term>> processed, ColumnNameBuilder builder, List<ByteBuffer> variables, boolean requireAllComponent) throws InvalidRequestException {
        CFDefinition.Name firstEmpty = null;
        for (CFDefinition.Name name : cfDef.columns.values()) {
            List<Term> values = processed.get(name.name);
            if (values == null || values.isEmpty()) {
                firstEmpty = name;
                if (!requireAllComponent || !cfDef.isComposite || cfDef.isCompact) continue;
                throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s", name));
            }
            if (firstEmpty != null) {
                throw new InvalidRequestException(String.format("Missing PRIMARY KEY part %s since %s is set", firstEmpty.name, name.name));
            }
            assert (values.size() == 1);
            builder.add(values.get(0), Relation.Type.EQ, variables);
        }
        return firstEmpty;
    }

    static List<ByteBuffer> buildKeyNames(CFDefinition cfDef, Map<ColumnIdentifier, List<Term>> processed, List<ByteBuffer> variables) throws InvalidRequestException {
        ColumnNameBuilder keyBuilder = cfDef.getKeyNameBuilder();
        ArrayList<ByteBuffer> keys = new ArrayList<ByteBuffer>();
        for (CFDefinition.Name name : cfDef.keys.values()) {
            List<Term> values = processed.get(name.name);
            if (values == null || values.isEmpty()) {
                throw new InvalidRequestException(String.format("Missing mandatory PRIMARY KEY part %s", name));
            }
            if (keyBuilder.remainingCount() == 1) {
                for (Term t : values) {
                    keys.add(keyBuilder.copy().add(t, Relation.Type.EQ, variables).build());
                }
                continue;
            }
            if (values.size() > 1) {
                throw new InvalidRequestException("IN is only supported on the last column of the partition key");
            }
            keyBuilder.add(values.get(0), Relation.Type.EQ, variables);
        }
        return keys;
    }

    private IMutation mutationForKey(CFDefinition cfDef, ByteBuffer key, ColumnNameBuilder builder, UpdateParameters params, ColumnGroupMap group, ConsistencyLevel cl) throws InvalidRequestException {
        org.apache.cassandra.cql.QueryProcessor.validateKey(key);
        boolean hasCounterColumn = false;
        QueryProcessor.validateKey(key);
        RowMutation rm = new RowMutation(cfDef.cfm.ksName, key);
        ColumnFamily cf = rm.addOrGet(cfDef.cfm.cfName);
        if (cfDef.isComposite && !cfDef.isCompact) {
            ByteBuffer name = builder.copy().add(ByteBufferUtil.EMPTY_BYTE_BUFFER).build();
            cf.addColumn(params.makeColumn(name, ByteBufferUtil.EMPTY_BYTE_BUFFER));
        }
        if (cfDef.isCompact) {
            Operation operation;
            if (builder.componentCount() == 0) {
                throw new InvalidRequestException(String.format("Missing PRIMARY KEY part %s", cfDef.columns.values().iterator().next()));
            }
            if (cfDef.value == null) {
                operation = ColumnOperation.SetToEmpty();
            } else {
                List operations = this.processedColumns.get((Object)cfDef.value);
                if (operations.isEmpty()) {
                    throw new InvalidRequestException(String.format("Missing mandatory column %s", cfDef.value));
                }
                assert (operations.size() == 1);
                operation = (Operation)operations.get(0);
            }
            hasCounterColumn = this.addToMutation(cf, builder, cfDef.value, operation, params, null);
        } else {
            for (Map.Entry entry : this.processedColumns.entries()) {
                CFDefinition.Name name = (CFDefinition.Name)entry.getKey();
                Operation op = (Operation)entry.getValue();
                hasCounterColumn |= this.addToMutation(cf, builder.copy().add(name.name.key), name, op, params, group == null || !op.requiresRead() ? null : group.getCollection(name.name.key));
            }
        }
        return hasCounterColumn ? new CounterMutation(rm, cl) : rm;
    }

    private boolean addToMutation(ColumnFamily cf, ColumnNameBuilder builder, CFDefinition.Name valueDef, Operation valueOperation, UpdateParameters params, List<Pair<ByteBuffer, IColumn>> list) throws InvalidRequestException {
        Operation.Type type = valueOperation.getType();
        switch (type) {
            case COLUMN: {
                if (valueDef != null && valueDef.type.isCollection()) {
                    ((ColumnOperation)valueOperation).executePreparedCollection(cf, builder.copy(), (CollectionType)valueDef.type, params);
                    break;
                }
                valueOperation.execute(cf, builder.copy(), valueDef == null ? null : valueDef.type, params);
                break;
            }
            case COUNTER: {
                if (valueDef != null && valueDef.type.isCollection()) {
                    throw new InvalidRequestException("Cannot assign collection value to column with " + valueDef.type + " type.");
                }
                valueOperation.execute(cf, builder.copy(), valueDef == null ? null : valueDef.type, params);
                break;
            }
            default: {
                if (!valueDef.type.isCollection()) {
                    throw new InvalidRequestException("Can't apply collection operation on column with " + valueDef.type + " type.");
                }
                valueOperation.execute(cf, builder.copy(), (CollectionType)valueDef.type, params, list);
            }
        }
        return valueOperation.getType() == Operation.Type.COUNTER;
    }

    @Override
    public ParsedStatement.Prepared prepare(CFDefinition.Name[] boundNames) throws InvalidRequestException {
        if (this.columns != null) {
            for (Pair<ColumnIdentifier, Operation> column : this.columns) {
                if (((Operation)column.right).getType() == Operation.Type.COUNTER) {
                    if (this.type == null) {
                        this.type = ModificationStatement.Type.COUNTER;
                        continue;
                    }
                    if (this.type == ModificationStatement.Type.COUNTER) continue;
                    throw new InvalidRequestException("Mix of counter and non-counter operations is not allowed.");
                }
                if (this.type != ModificationStatement.Type.COUNTER) continue;
                throw new InvalidRequestException("Mix of counter and non-counter operations is not allowed.");
            }
        }
        if (this.type == null) {
            this.type = ModificationStatement.Type.LOGGED;
        }
        CFMetaData metadata = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily(), this.type == ModificationStatement.Type.COUNTER);
        this.cfDef = metadata.getCfDef();
        if (this.columns == null) {
            if (this.columnNames.size() != this.columnOperations.size()) {
                throw new InvalidRequestException("unmatched column names/values");
            }
            if (this.columnNames.size() < 1) {
                throw new InvalidRequestException("no columns specified for INSERT");
            }
            block9: for (int i = 0; i < this.columnNames.size(); ++i) {
                CFDefinition.Name name = this.cfDef.get(this.columnNames.get(i));
                if (name == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", this.columnNames.get(i)));
                }
                Operation operation = this.columnOperations.get(i);
                for (Term t : operation.getValues()) {
                    if (!t.isBindMarker()) continue;
                    boundNames[t.bindIndex] = name;
                }
                switch (name.kind) {
                    case KEY_ALIAS: 
                    case COLUMN_ALIAS: {
                        if (this.processedKeys.containsKey(name.name)) {
                            throw new InvalidRequestException(String.format("Multiple definitions found for PRIMARY KEY part %s", name));
                        }
                        if (operation.getType() != Operation.Type.COLUMN) {
                            throw new InvalidRequestException(String.format("Invalid definition for %s, not a collection type", name));
                        }
                        this.processedKeys.put(name.name, operation.getValues());
                        continue block9;
                    }
                    case VALUE_ALIAS: 
                    case COLUMN_METADATA: {
                        if (this.processedColumns.containsKey((Object)name)) {
                            throw new InvalidRequestException(String.format("Multiple definitions found for column %s", name));
                        }
                        this.processedColumns.put((Object)name, (Object)operation);
                    }
                }
            }
        } else {
            for (Pair<ColumnIdentifier, Operation> entry : this.columns) {
                CFDefinition.Name name = this.cfDef.get((ColumnIdentifier)entry.left);
                if (name == null) {
                    throw new InvalidRequestException(String.format("Unknown identifier %s", entry.left));
                }
                switch (name.kind) {
                    case KEY_ALIAS: 
                    case COLUMN_ALIAS: {
                        throw new InvalidRequestException(String.format("PRIMARY KEY part %s found in SET part", entry.left));
                    }
                    case VALUE_ALIAS: 
                    case COLUMN_METADATA: {
                        for (Operation op : this.processedColumns.get((Object)name)) {
                            if (op.getType() != Operation.Type.COLUMN) continue;
                            throw new InvalidRequestException(String.format("Multiple definitions found for column %s", name));
                        }
                        Operation op = (Operation)entry.right;
                        for (Term t : op.getValues()) {
                            if (!t.isBindMarker()) continue;
                            boundNames[t.bindIndex] = name;
                        }
                        this.processedColumns.put((Object)name, (Object)op);
                    }
                }
            }
            UpdateStatement.processKeys(this.cfDef, this.whereClause, this.processedKeys, boundNames);
        }
        return new ParsedStatement.Prepared(this, Arrays.asList(boundNames));
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        CFDefinition.Name[] names = new CFDefinition.Name[this.getBoundsTerms()];
        return this.prepare(names);
    }

    static void processKeys(CFDefinition cfDef, List<Relation> keys, Map<ColumnIdentifier, List<Term>> processed, CFDefinition.Name[] names) throws InvalidRequestException {
        for (Relation rel : keys) {
            CFDefinition.Name name = cfDef.get(rel.getEntity());
            if (name == null) {
                throw new InvalidRequestException(String.format("Unknown key identifier %s", rel.getEntity()));
            }
            switch (name.kind) {
                case KEY_ALIAS: 
                case COLUMN_ALIAS: {
                    List<Term> values;
                    if (rel.operator() == Relation.Type.EQ) {
                        values = Collections.singletonList(rel.getValue());
                    } else if (name.kind == CFDefinition.Name.Kind.KEY_ALIAS && rel.operator() == Relation.Type.IN) {
                        values = rel.getInValues();
                    } else {
                        throw new InvalidRequestException(String.format("Invalid operator %s for key %s", new Object[]{rel.operator(), rel.getEntity()}));
                    }
                    if (processed.containsKey(name.name)) {
                        throw new InvalidRequestException(String.format("Multiple definitions found for PRIMARY KEY part %s", name));
                    }
                    for (Term value : values) {
                        if (!value.isBindMarker()) continue;
                        names[value.bindIndex] = name;
                    }
                    processed.put(name.name, values);
                    break;
                }
                case VALUE_ALIAS: 
                case COLUMN_METADATA: {
                    throw new InvalidRequestException(String.format("PRIMARY KEY part %s found in SET part", rel.getEntity()));
                }
            }
        }
    }

    public String toString() {
        return String.format("UpdateStatement(name=%s, keys=%s, columns=%s, timestamp=%s, timeToLive=%s)", this.cfName, this.whereClause, this.columns, this.isSetTimestamp() ? Long.valueOf(this.getTimestamp(-1L)) : "<now>", this.getTimeToLive());
    }
}

