/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CFPropDefs;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ParsedType;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang.StringUtils;

public class CreateColumnFamilyStatement
extends SchemaAlteringStatement {
    public AbstractType<?> comparator;
    private AbstractType<?> defaultValidator;
    private AbstractType<?> keyValidator;
    private final List<ByteBuffer> keyAliases = new ArrayList<ByteBuffer>();
    private final List<ByteBuffer> columnAliases = new ArrayList<ByteBuffer>();
    private ByteBuffer valueAlias;
    private final Map<ColumnIdentifier, AbstractType> columns = new HashMap<ColumnIdentifier, AbstractType>();
    private final CFPropDefs properties;

    public CreateColumnFamilyStatement(CFName name, CFPropDefs properties) {
        super(name);
        this.properties = properties;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.CREATE);
    }

    private Map<ByteBuffer, ColumnDefinition> getColumns() throws InvalidRequestException {
        HashMap<ByteBuffer, ColumnDefinition> columnDefs = new HashMap<ByteBuffer, ColumnDefinition>();
        Integer componentIndex = null;
        if (this.comparator instanceof CompositeType) {
            CompositeType ct = (CompositeType)this.comparator;
            componentIndex = ct.types.get(ct.types.size() - 1) instanceof ColumnToCollectionType ? ct.types.size() - 2 : ct.types.size() - 1;
        }
        for (Map.Entry<ColumnIdentifier, AbstractType> col : this.columns.entrySet()) {
            columnDefs.put(col.getKey().key, new ColumnDefinition(col.getKey().key, col.getValue(), null, null, null, componentIndex));
        }
        return columnDefs;
    }

    @Override
    public void announceMigration() throws RequestValidationException {
        MigrationManager.announceNewColumnFamily(this.getCFMetaData());
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.CREATED;
    }

    public CFMetaData getCFMetaData() throws RequestValidationException {
        CFMetaData newCFMD = new CFMetaData(this.keyspace(), this.columnFamily(), ColumnFamilyType.Standard, this.comparator, null);
        this.applyPropertiesTo(newCFMD);
        return newCFMD;
    }

    public void applyPropertiesTo(CFMetaData cfmd) throws RequestValidationException {
        cfmd.defaultValidator(this.defaultValidator).columnMetadata(this.getColumns()).keyValidator(this.keyValidator).keyAliases(this.keyAliases).columnAliases(this.columnAliases).valueAlias(this.valueAlias);
        this.properties.applyToCFMetadata(cfmd);
    }

    public static class RawStatement
    extends CFStatement {
        private final Map<ColumnIdentifier, ParsedType> definitions = new HashMap<ColumnIdentifier, ParsedType>();
        public final CFPropDefs properties = new CFPropDefs();
        private final List<List<ColumnIdentifier>> keyAliases = new ArrayList<List<ColumnIdentifier>>();
        private final List<ColumnIdentifier> columnAliases = new ArrayList<ColumnIdentifier>();
        private final Map<ColumnIdentifier, Boolean> definedOrdering = new LinkedHashMap<ColumnIdentifier, Boolean>();
        private boolean useCompactStorage;
        private final Multiset<ColumnIdentifier> definedNames = HashMultiset.create((int)1);

        public RawStatement(CFName name) {
            super(name);
        }

        @Override
        public ParsedStatement.Prepared prepare() throws RequestValidationException {
            ArrayList types;
            if (!this.columnFamily().matches("\\w+")) {
                throw new InvalidRequestException(String.format("\"%s\" is not a valid column family name (must be alphanumeric character only: [0-9A-Za-z]+)", this.columnFamily()));
            }
            if (this.columnFamily().length() > 48) {
                throw new InvalidRequestException(String.format("Column family names shouldn't be more than %s characters long (got \"%s\")", 48, this.columnFamily()));
            }
            for (Multiset.Entry entry : this.definedNames.entrySet()) {
                if (entry.getCount() <= 1) continue;
                throw new InvalidRequestException(String.format("Multiple definition of identifier %s", entry.getElement()));
            }
            this.properties.validate();
            CreateColumnFamilyStatement stmt = new CreateColumnFamilyStatement(this.cfName, this.properties);
            stmt.setBoundTerms(this.getBoundsTerms());
            HashMap<ByteBuffer, CollectionType> definedCollections = null;
            for (Map.Entry<ColumnIdentifier, ParsedType> entry : this.definitions.entrySet()) {
                ColumnIdentifier id = entry.getKey();
                ParsedType pt = entry.getValue();
                if (pt.isCollection()) {
                    if (definedCollections == null) {
                        definedCollections = new HashMap<ByteBuffer, CollectionType>();
                    }
                    definedCollections.put(id.key, (CollectionType)pt.getType());
                }
                stmt.columns.put(id, pt.getType());
            }
            if (this.keyAliases.size() != 1) {
                throw new InvalidRequestException("You must specify one and only one PRIMARY KEY");
            }
            List<ColumnIdentifier> kAliases = this.keyAliases.get(0);
            ArrayList keyTypes = new ArrayList(kAliases.size());
            for (ColumnIdentifier alias : kAliases) {
                stmt.keyAliases.add(alias.key);
                AbstractType<?> abstractType = this.getTypeAndRemove(stmt.columns, alias);
                if (abstractType instanceof CounterColumnType) {
                    throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", alias));
                }
                keyTypes.add(abstractType);
            }
            stmt.keyValidator = keyTypes.size() == 1 ? (AbstractType)keyTypes.get(0) : CompositeType.getInstance(keyTypes);
            if (this.columnAliases.isEmpty()) {
                if (this.useCompactStorage) {
                    if (stmt.columns.isEmpty()) {
                        throw new InvalidRequestException("No definition found that is not part of the PRIMARY KEY");
                    }
                    stmt.comparator = CFDefinition.definitionType;
                } else {
                    types = new ArrayList(definedCollections == null ? 1 : 2);
                    types.add(CFDefinition.definitionType);
                    if (definedCollections != null) {
                        types.add(ColumnToCollectionType.getInstance(definedCollections));
                    }
                    stmt.comparator = CompositeType.getInstance(types);
                }
            } else if (this.useCompactStorage && this.columnAliases.size() == 1) {
                if (definedCollections != null) {
                    throw new InvalidRequestException("Collection types are not supported with COMPACT STORAGE");
                }
                stmt.columnAliases.add(this.columnAliases.get((int)0).key);
                stmt.comparator = this.getTypeAndRemove(stmt.columns, this.columnAliases.get(0));
                if (stmt.comparator instanceof CounterColumnType) {
                    throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", stmt.columnAliases.get(0)));
                }
            } else {
                types = new ArrayList(this.columnAliases.size() + 1);
                for (ColumnIdentifier columnIdentifier : this.columnAliases) {
                    stmt.columnAliases.add(columnIdentifier.key);
                    AbstractType<?> type = this.getTypeAndRemove(stmt.columns, columnIdentifier);
                    if (type instanceof CounterColumnType) {
                        throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", columnIdentifier.key));
                    }
                    types.add(type);
                }
                if (this.useCompactStorage) {
                    if (definedCollections != null) {
                        throw new InvalidRequestException("Collection types are not supported with COMPACT STORAGE");
                    }
                } else {
                    types.add(CFDefinition.definitionType);
                    if (definedCollections != null) {
                        types.add(ColumnToCollectionType.getInstance(definedCollections));
                    }
                }
                if (types.isEmpty()) {
                    throw new IllegalStateException("Nonsensical empty parameter list for CompositeType");
                }
                stmt.comparator = CompositeType.getInstance(types);
            }
            if (this.useCompactStorage && stmt.columns.size() <= 1) {
                if (stmt.columns.isEmpty()) {
                    if (this.columnAliases.isEmpty()) {
                        throw new InvalidRequestException(String.format("COMPACT STORAGE with non-composite PRIMARY KEY require one column not part of the PRIMARY KEY (got: %s)", StringUtils.join(stmt.columns.keySet(), (String)", ")));
                    }
                    stmt.defaultValidator = CFDefinition.definitionType;
                    stmt.valueAlias = ByteBufferUtil.EMPTY_BYTE_BUFFER;
                } else {
                    Map.Entry lastEntry = stmt.columns.entrySet().iterator().next();
                    stmt.defaultValidator = (AbstractType)lastEntry.getValue();
                    stmt.valueAlias = ((ColumnIdentifier)lastEntry.getKey()).key;
                    stmt.columns.remove(lastEntry.getKey());
                }
            } else {
                if (this.useCompactStorage && !this.columnAliases.isEmpty()) {
                    throw new InvalidRequestException(String.format("COMPACT STORAGE with composite PRIMARY KEY allows no more than one column not part of the PRIMARY KEY (got: %s)", StringUtils.join(stmt.columns.keySet(), (String)", ")));
                }
                stmt.defaultValidator = !stmt.columns.isEmpty() && stmt.columns.values().iterator().next() instanceof CounterColumnType ? CounterColumnType.instance : CFDefinition.definitionType;
            }
            if (!this.definedOrdering.isEmpty()) {
                if (this.definedOrdering.size() > this.columnAliases.size()) {
                    throw new InvalidRequestException("Too much columns provided for CLUSTERING ORDER");
                }
                int i = 0;
                for (ColumnIdentifier columnIdentifier : this.definedOrdering.keySet()) {
                    ColumnIdentifier c;
                    if (!columnIdentifier.equals(c = this.columnAliases.get(i))) {
                        if (this.definedOrdering.containsKey(c)) {
                            throw new InvalidRequestException(String.format("The order of columns in the CLUSTERING ORDER directive must be the one of the clustering key (%s must appear before %s)", c, columnIdentifier));
                        }
                        throw new InvalidRequestException(String.format("Missing CLUSTERING ORDER for column %s", c));
                    }
                    ++i;
                }
            }
            return new ParsedStatement.Prepared(stmt);
        }

        private AbstractType<?> getTypeAndRemove(Map<ColumnIdentifier, AbstractType> columns, ColumnIdentifier t) throws InvalidRequestException, ConfigurationException {
            ReversedType type = columns.get(t);
            if (type == null) {
                throw new InvalidRequestException(String.format("Unkown definition %s referenced in PRIMARY KEY", t));
            }
            if (type instanceof CollectionType) {
                throw new InvalidRequestException(String.format("Invalid collection type for PRIMARY KEY component %s", t));
            }
            columns.remove(t);
            Boolean isReversed = this.definedOrdering.get(t);
            return isReversed != null && isReversed != false ? ReversedType.getInstance(type) : type;
        }

        public void addDefinition(ColumnIdentifier def, ParsedType type) {
            this.definedNames.add((Object)def);
            this.definitions.put(def, type);
        }

        public void addKeyAliases(List<ColumnIdentifier> aliases) {
            this.keyAliases.add(aliases);
        }

        public void addColumnAlias(ColumnIdentifier alias) {
            this.columnAliases.add(alias);
        }

        public void setOrdering(ColumnIdentifier alias, boolean reversed) {
            this.definedOrdering.put(alias, reversed);
        }

        public void setCompactStorage() {
            this.useCompactStorage = true;
        }

        public void checkAccess(ClientState state) {
            throw new UnsupportedOperationException();
        }

        public CqlResult execute(ClientState state, List<ByteBuffer> variables) {
            throw new UnsupportedOperationException();
        }
    }
}

