/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.utils.Pair;

public class BatchStatement
extends ModificationStatement {
    protected final List<ModificationStatement> statements;

    public BatchStatement(ModificationStatement.Type type, List<ModificationStatement> statements, Attributes attrs) {
        super(null, attrs);
        this.type = type;
        this.statements = statements;
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        for (ModificationStatement statement : this.statements) {
            statement.prepareKeyspace(state);
        }
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        HashSet<String> cfamsSeen = new HashSet<String>();
        for (ModificationStatement statement : this.statements) {
            if (cfamsSeen.contains(statement.columnFamily())) continue;
            state.hasColumnFamilyAccess(statement.keyspace(), statement.columnFamily(), Permission.UPDATE);
            cfamsSeen.add(statement.columnFamily());
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.getTimeToLive() != 0) {
            throw new InvalidRequestException("Global TTL on the BATCH statement is not supported.");
        }
        for (ModificationStatement statement : this.statements) {
            if (this.isSetTimestamp() && statement.isSetTimestamp()) {
                throw new InvalidRequestException("Timestamp must be set either on BATCH or individual statements");
            }
            if (statement.getTimeToLive() >= 0) continue;
            throw new InvalidRequestException("A TTL must be greater or equal to 0");
        }
    }

    @Override
    protected void validateConsistency(ConsistencyLevel cl) throws InvalidRequestException {
        for (ModificationStatement statement : this.statements) {
            statement.validateConsistency(cl);
        }
    }

    @Override
    public Collection<? extends IMutation> getMutations(List<ByteBuffer> variables, boolean local, ConsistencyLevel cl, long now) throws RequestExecutionException, RequestValidationException {
        HashMap<Pair<String, ByteBuffer>, IMutation> mutations = new HashMap<Pair<String, ByteBuffer>, IMutation>();
        for (ModificationStatement statement : this.statements) {
            if (this.isSetTimestamp()) {
                statement.setTimestamp(this.getTimestamp(now));
            }
            for (IMutation iMutation : statement.getMutations(variables, local, cl, now)) {
                if (iMutation instanceof CounterMutation && this.type != ModificationStatement.Type.COUNTER) {
                    throw new InvalidRequestException("Counter mutations are only allowed in COUNTER batches");
                }
                if (iMutation instanceof RowMutation && this.type == ModificationStatement.Type.COUNTER) {
                    throw new InvalidRequestException("Only counter mutations are allowed in COUNTER batches");
                }
                Pair<String, ByteBuffer> key = Pair.create(iMutation.getTable(), iMutation.key());
                IMutation existing = (IMutation)mutations.get(key);
                if (existing == null) {
                    mutations.put(key, iMutation);
                    continue;
                }
                existing.addAll(iMutation);
            }
        }
        return mutations.values();
    }

    @Override
    public ParsedStatement.Prepared prepare(CFDefinition.Name[] boundNames) throws InvalidRequestException {
        for (ModificationStatement statement : this.statements) {
            statement.prepare(boundNames);
        }
        return new ParsedStatement.Prepared(this, Arrays.asList(boundNames));
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        CFDefinition.Name[] boundNames = new CFDefinition.Name[this.getBoundsTerms()];
        return this.prepare(boundNames);
    }

    public String toString() {
        return String.format("BatchStatement(type=%s, statements=%s)", new Object[]{this.type, this.statements});
    }
}

