/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.operations;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.operations.ListOperation;
import org.apache.cassandra.cql3.operations.MapOperation;
import org.apache.cassandra.cql3.operations.Operation;
import org.apache.cassandra.cql3.operations.SetOperation;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public class ColumnOperation
implements Operation {
    private static final Operation setToEmptyOperation = new ColumnOperation(null, Kind.SET){

        @Override
        protected void doSet(ColumnFamily cf, ColumnNameBuilder builder, AbstractType<?> validator, UpdateParameters params) throws InvalidRequestException {
            ByteBuffer colName = builder.build();
            QueryProcessor.validateColumnName(colName);
            cf.addColumn(params.makeColumn(colName, ByteBufferUtil.EMPTY_BYTE_BUFFER));
        }
    };
    private final Term value;
    private final Kind kind;

    private ColumnOperation(Term value, Kind kind) {
        this.value = value;
        this.kind = kind;
    }

    @Override
    public void execute(ColumnFamily cf, ColumnNameBuilder builder, AbstractType<?> validator, UpdateParameters params) throws InvalidRequestException {
        switch (this.kind) {
            case SET: {
                this.doSet(cf, builder, validator, params);
                break;
            }
            case COUNTER_INC: 
            case COUNTER_DEC: {
                this.doCounter(cf, builder, params);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported operation: " + (Object)((Object)this.kind)));
            }
        }
    }

    @Override
    public void execute(ColumnFamily cf, ColumnNameBuilder builder, CollectionType validator, UpdateParameters params, List<Pair<ByteBuffer, IColumn>> list) throws InvalidRequestException {
        throw new InvalidRequestException("Column operations are only supported on simple types, but " + validator + " given.");
    }

    public void executePreparedCollection(ColumnFamily cf, ColumnNameBuilder builder, CollectionType validator, UpdateParameters params) throws InvalidRequestException {
        switch (validator.kind) {
            case LIST: {
                ListOperation.doInsertFromPrepared(cf, builder, (ListType)validator, this.value, params);
                break;
            }
            case SET: {
                SetOperation.doInsertFromPrepared(cf, builder, (SetType)validator, this.value, params);
                break;
            }
            case MAP: {
                MapOperation.doInsertFromPrepared(cf, builder, (MapType)validator, this.value, params);
            }
        }
    }

    protected void doSet(ColumnFamily cf, ColumnNameBuilder builder, AbstractType<?> validator, UpdateParameters params) throws InvalidRequestException {
        ByteBuffer colName = builder.build();
        QueryProcessor.validateColumnName(colName);
        ByteBuffer valueBytes = this.value.getByteBuffer(validator, params.variables);
        cf.addColumn(params.makeColumn(colName, valueBytes));
    }

    private void doCounter(ColumnFamily cf, ColumnNameBuilder builder, UpdateParameters params) throws InvalidRequestException {
        long val;
        try {
            val = ByteBufferUtil.toLong(this.value.getByteBuffer(LongType.instance, params.variables));
        }
        catch (NumberFormatException e) {
            throw new InvalidRequestException(String.format("'%s' is an invalid value, should be a long.", this.value.getText()));
        }
        if (this.kind == Kind.COUNTER_DEC) {
            if (val == Long.MIN_VALUE) {
                throw new InvalidRequestException("The negation of " + val + " overflows supported integer precision (signed 8 bytes integer)");
            }
            val = -val;
        }
        cf.addCounter(new QueryPath(cf.metadata().cfName, null, builder.build()), val);
    }

    @Override
    public List<Term> getValues() {
        return Collections.singletonList(this.value);
    }

    @Override
    public boolean requiresRead() {
        return false;
    }

    @Override
    public Operation.Type getType() {
        return this.kind == Kind.COUNTER_DEC || this.kind == Kind.COUNTER_INC ? Operation.Type.COUNTER : Operation.Type.COLUMN;
    }

    public static Operation Set(Term value) {
        return new ColumnOperation(value, Kind.SET);
    }

    public static Operation CounterInc(Term value) {
        return new ColumnOperation(value, Kind.COUNTER_INC);
    }

    public static Operation CounterDec(Term value) {
        return new ColumnOperation(value, Kind.COUNTER_DEC);
    }

    public static Operation SetToEmpty() {
        return setToEmptyOperation;
    }

    static enum Kind {
        SET,
        COUNTER_INC,
        COUNTER_DEC;

    }
}

