/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum Permission {
    READ,
    WRITE,
    FULL_ACCESS,
    NO_ACCESS,
    DESCRIBE,
    CREATE,
    ALTER,
    DROP,
    UPDATE,
    DELETE,
    SELECT;

    public static final EnumSet<Permission> ALL;
    public static final EnumSet<Permission> NONE;
    public static final EnumSet<Permission> GRANULAR_PERMISSIONS;
    public static final EnumSet<Permission> ALLOWED_SYSTEM_ACTIONS;
    public static final Map<Permission, EnumSet<Permission>> oldToNew;

    static {
        ALL = EnumSet.allOf(Permission.class);
        NONE = EnumSet.noneOf(Permission.class);
        GRANULAR_PERMISSIONS = EnumSet.range(FULL_ACCESS, SELECT);
        ALLOWED_SYSTEM_ACTIONS = EnumSet.of(DESCRIBE, UPDATE, DELETE, SELECT);
        oldToNew = new HashMap<Permission, EnumSet<Permission>>(2){
            {
                this.put(READ, EnumSet.of(DESCRIBE, SELECT));
                this.put(WRITE, EnumSet.range(DESCRIBE, DELETE));
            }
        };
    }
}

