/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.obs.OpenBitSet;

abstract class BloomFilterSerializer
implements ISerializer<BloomFilter> {
    BloomFilterSerializer() {
    }

    @Override
    public void serialize(BloomFilter bf, DataOutput dos) throws IOException {
        int bitLength = bf.bitset.getNumWords();
        int pageSize = bf.bitset.getPageSize();
        int pageCount = bf.bitset.getPageCount();
        dos.writeInt(bf.getHashCount());
        dos.writeInt(bitLength);
        for (int p = 0; p < pageCount; ++p) {
            long[] bits = bf.bitset.getPage(p);
            for (int i = 0; i < pageSize && bitLength-- > 0; ++i) {
                dos.writeLong(bits[i]);
            }
        }
    }

    @Override
    public BloomFilter deserialize(DataInput dis) throws IOException {
        int hashes = dis.readInt();
        long bitLength = dis.readInt();
        OpenBitSet bs = new OpenBitSet(bitLength << 6);
        int pageSize = bs.getPageSize();
        int pageCount = bs.getPageCount();
        for (int p = 0; p < pageCount; ++p) {
            long[] bits = bs.getPage(p);
            for (int i = 0; i < pageSize && bitLength-- > 0L; ++i) {
                bits[i] = dis.readLong();
            }
        }
        return this.createFilter(hashes, bs);
    }

    protected abstract BloomFilter createFilter(int var1, OpenBitSet var2);

    @Override
    public long serializedSize(BloomFilter bf, TypeSizes typeSizes) {
        int bitLength = bf.bitset.getNumWords();
        int pageSize = bf.bitset.getPageSize();
        int pageCount = bf.bitset.getPageCount();
        int size = 0;
        size += typeSizes.sizeof(bf.getHashCount());
        size += typeSizes.sizeof(bitLength);
        for (int p = 0; p < pageCount; ++p) {
            long[] bits = bf.bitset.getPage(p);
            for (int i = 0; i < pageSize && bitLength-- > 0; ++i) {
                size += typeSizes.sizeof(bits[i]);
            }
        }
        return size;
    }
}

