/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ServerConnection;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.jboss.netty.buffer.ChannelBuffer;

public class PrepareMessage
extends Message.Request {
    public static final Message.Codec<PrepareMessage> codec = new Message.Codec<PrepareMessage>(){

        @Override
        public PrepareMessage decode(ChannelBuffer body) {
            String query = CBUtil.readLongString(body);
            return new PrepareMessage(query);
        }

        @Override
        public ChannelBuffer encode(PrepareMessage msg) {
            return CBUtil.longStringToCB(msg.query);
        }
    };
    private final String query;

    public PrepareMessage(String query) {
        super(Message.Type.PREPARE);
        this.query = query;
    }

    @Override
    public ChannelBuffer encode() {
        return codec.encode(this);
    }

    @Override
    public Message.Response execute() {
        try {
            return QueryProcessor.prepare(this.query, ((ServerConnection)this.connection).clientState());
        }
        catch (Exception e) {
            return ErrorMessage.fromException(e);
        }
    }

    public String toString() {
        return "PREPARE " + this.query;
    }
}

