/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;

public class ServerConnection
extends Connection {
    public static final Connection.Factory FACTORY = new Connection.Factory(){

        @Override
        public Connection newConnection(Connection.Tracker tracker) {
            return new ServerConnection(tracker);
        }
    };
    private final ClientState clientState = new ClientState();
    private volatile State state = State.UNINITIALIZED;

    public ServerConnection(Connection.Tracker tracker) {
        super(tracker);
    }

    public ClientState clientState() {
        return this.clientState;
    }

    public void validateNewMessage(Message.Type type) {
        switch (this.state) {
            case UNINITIALIZED: {
                if (type == Message.Type.STARTUP || type == Message.Type.OPTIONS) break;
                throw new ProtocolException(String.format("Unexpected message %s, expecting STARTUP or OPTIONS", new Object[]{type}));
            }
            case AUTHENTICATION: {
                if (type == Message.Type.CREDENTIALS) break;
                throw new ProtocolException(String.format("Unexpected message %s, needs authentication through CREDENTIALS message", new Object[]{type}));
            }
            case READY: {
                if (type != Message.Type.STARTUP) break;
                throw new ProtocolException("Unexpected message STARTUP, the connection is already initialized");
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public void applyStateTransition(Message.Type requestType, Message.Type responseType) {
        switch (this.state) {
            case UNINITIALIZED: {
                if (requestType != Message.Type.STARTUP) break;
                if (responseType == Message.Type.AUTHENTICATE) {
                    this.state = State.AUTHENTICATION;
                    break;
                }
                if (responseType != Message.Type.READY) break;
                this.state = State.READY;
                break;
            }
            case AUTHENTICATION: {
                assert (requestType == Message.Type.CREDENTIALS);
                if (responseType == Message.Type.READY) {
                    this.state = State.READY;
                }
            }
            case READY: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private static enum State {
        UNINITIALIZED,
        AUTHENTICATION,
        READY;

    }
}

