/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.columniterator.IdentityQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.net.IAsyncResult;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.AbstractRowResolver;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.FBUtilities;

public class RowRepairResolver
extends AbstractRowResolver {
    protected int maxLiveColumns = 0;
    public List<IAsyncResult> repairResults = Collections.emptyList();

    public RowRepairResolver(String table, ByteBuffer key) {
        super(key, table);
    }

    @Override
    public Row resolve() throws DigestMismatchException, IOException {
        ColumnFamily resolved;
        if (logger.isDebugEnabled()) {
            logger.debug("resolving " + this.replies.size() + " responses");
        }
        long startTime = System.currentTimeMillis();
        if (this.replies.size() > 1) {
            ArrayList<ColumnFamily> versions = new ArrayList<ColumnFamily>(this.replies.size());
            ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(this.replies.size());
            for (MessageIn message : this.replies) {
                ReadResponse response = (ReadResponse)message.payload;
                ColumnFamily cf = response.row().cf;
                assert (!response.isDigestQuery()) : "Received digest response to repair read from " + message.from;
                versions.add(cf);
                endpoints.add(message.from);
                int liveColumns = cf == null ? 0 : cf.getLiveColumnCount();
                if (liveColumns <= this.maxLiveColumns) continue;
                this.maxLiveColumns = liveColumns;
            }
            resolved = RowRepairResolver.resolveSuperset(versions);
            if (logger.isDebugEnabled()) {
                logger.debug("versions merged");
            }
            if (resolved != null) {
                this.repairResults = RowRepairResolver.scheduleRepairs(resolved, this.table, this.key, versions, endpoints);
            }
        } else {
            resolved = ((ReadResponse)((MessageIn)this.replies.iterator().next()).payload).row().cf;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("resolve: " + (System.currentTimeMillis() - startTime) + " ms.");
        }
        return new Row(this.key, resolved);
    }

    public static List<IAsyncResult> scheduleRepairs(ColumnFamily resolved, String table, DecoratedKey key, List<ColumnFamily> versions, List<InetAddress> endpoints) {
        ArrayList<IAsyncResult> results = new ArrayList<IAsyncResult>(versions.size());
        for (int i = 0; i < versions.size(); ++i) {
            ColumnFamily diffCf = ColumnFamily.diff(versions.get(i), resolved);
            if (diffCf == null) continue;
            RowMutation rowMutation = new RowMutation(table, key.key);
            rowMutation.add(diffCf);
            MessageOut<RowMutation> repairMessage = rowMutation.createMessage(MessagingService.Verb.READ_REPAIR);
            results.add(MessagingService.instance().sendRR(repairMessage, endpoints.get(i)));
        }
        return results;
    }

    static ColumnFamily resolveSuperset(Iterable<ColumnFamily> versions) {
        assert (Iterables.size(versions) > 0);
        ColumnFamily resolved = null;
        for (ColumnFamily cf : versions) {
            if (cf == null) continue;
            if (resolved == null) {
                resolved = cf.cloneMeShallow();
                continue;
            }
            resolved.delete(cf);
        }
        if (resolved == null) {
            return null;
        }
        QueryFilter filter = new QueryFilter(null, new QueryPath(resolved.metadata().cfName), new IdentityQueryFilter());
        ArrayList<CloseableIterator<IColumn>> iters = new ArrayList<CloseableIterator<IColumn>>();
        for (ColumnFamily version : versions) {
            if (version == null) continue;
            iters.add(FBUtilities.closeableIterator(version.iterator()));
        }
        filter.collateColumns(resolved, iters, Integer.MIN_VALUE);
        return ColumnFamilyStore.removeDeleted(resolved, Integer.MIN_VALUE);
    }

    @Override
    public Row getData() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDataPresent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxLiveColumns() {
        return this.maxLiveColumns;
    }
}

