/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import org.apache.cassandra.net.CallbackInfo;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IAsyncResult;
import org.apache.cassandra.net.IMessageCallback;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseVerbHandler
implements IVerbHandler {
    private static final Logger logger = LoggerFactory.getLogger(ResponseVerbHandler.class);

    public void doVerb(MessageIn message, String id) {
        long latency = System.currentTimeMillis() - MessagingService.instance().getRegisteredCallbackAge(id);
        CallbackInfo callbackInfo = MessagingService.instance().removeRegisteredCallback(id);
        if (callbackInfo == null) {
            logger.debug("Callback already removed for {}", (Object)id);
            return;
        }
        IMessageCallback cb = callbackInfo.callback;
        MessagingService.instance().maybeAddLatency(cb, message.from, latency);
        if (cb instanceof IAsyncCallback) {
            if (logger.isDebugEnabled()) {
                logger.debug("Processing response on a callback from " + id + "@" + message.from);
            }
            ((IAsyncCallback)cb).response(message);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Processing response on an async result from " + id + "@" + message.from);
            }
            ((IAsyncResult)cb).result(message);
        }
    }
}

