/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Objects;
import java.io.File;
import java.util.EnumSet;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.utils.Pair;

public class Component {
    public static final char separator = '-';
    static final EnumSet<Type> TYPES = EnumSet.allOf(Type.class);
    public static final Component DATA = new Component(Type.DATA, -1);
    public static final Component PRIMARY_INDEX = new Component(Type.PRIMARY_INDEX, -1);
    public static final Component FILTER = new Component(Type.FILTER, -1);
    public static final Component COMPACTED_MARKER = new Component(Type.COMPACTED_MARKER, -1);
    public static final Component COMPRESSION_INFO = new Component(Type.COMPRESSION_INFO, -1);
    public static final Component STATS = new Component(Type.STATS, -1);
    public static final Component DIGEST = new Component(Type.DIGEST, -1);
    public static final Component SUMMARY = new Component(Type.SUMMARY, -1);
    public final Type type;
    public final int id;
    public final int hashCode;

    public Component(Type type) {
        this(type, -1);
    }

    public Component(Type type, int id) {
        this.type = type;
        this.id = id;
        this.hashCode = Objects.hashCode((Object[])new Object[]{type, id});
    }

    public String name() {
        return this.type.repr;
    }

    public static Pair<Descriptor, Component> fromFilename(File directory, String name) {
        Component component;
        Pair<Descriptor, String> path = Descriptor.fromFilename(directory, name);
        Type type = Type.fromRepresentation((String)path.right);
        switch (type) {
            case DATA: {
                component = DATA;
                break;
            }
            case PRIMARY_INDEX: {
                component = PRIMARY_INDEX;
                break;
            }
            case FILTER: {
                component = FILTER;
                break;
            }
            case COMPACTED_MARKER: {
                component = COMPACTED_MARKER;
                break;
            }
            case COMPRESSION_INFO: {
                component = COMPRESSION_INFO;
                break;
            }
            case STATS: {
                component = STATS;
                break;
            }
            case DIGEST: {
                component = DIGEST;
                break;
            }
            case SUMMARY: {
                component = SUMMARY;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Pair.create(path.left, component);
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Component)) {
            return false;
        }
        Component that = (Component)o;
        return this.type == that.type && this.id == that.id;
    }

    public int hashCode() {
        return this.hashCode;
    }

    static enum Type {
        DATA("Data.db"),
        PRIMARY_INDEX("Index.db"),
        FILTER("Filter.db"),
        COMPACTED_MARKER("Compacted"),
        COMPRESSION_INFO("CompressionInfo.db"),
        STATS("Statistics.db"),
        DIGEST("Digest.sha1"),
        SUMMARY("Summary.db");

        final String repr;

        private Type(String repr) {
            this.repr = repr;
        }

        static Type fromRepresentation(String repr) {
            for (Type type : TYPES) {
                if (!repr.equals(type.repr)) continue;
                return type;
            }
            throw new RuntimeException("Invalid SSTable component: '" + repr + "'");
        }
    }
}

