/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.columniterator.ISSTableColumnIterator;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.columniterator.SSTableSliceIterator;
import org.apache.cassandra.db.filter.ColumnCounter;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceQueryFilter
implements IFilter {
    private static final Logger logger = LoggerFactory.getLogger(SliceQueryFilter.class);
    public static final Serializer serializer = new Serializer();
    public final ColumnSlice[] slices;
    public final boolean reversed;
    public volatile int count;
    private final int compositesToGroup;
    private final int countMutliplierForCompatibility;
    private ColumnCounter columnCounter;

    public SliceQueryFilter(ByteBuffer start, ByteBuffer finish, boolean reversed, int count) {
        this(new ColumnSlice[]{new ColumnSlice(start, finish)}, reversed, count);
    }

    public SliceQueryFilter(ColumnSlice[] slices, boolean reversed, int count) {
        this(slices, reversed, count, -1, 1);
    }

    public SliceQueryFilter(ColumnSlice[] slices, boolean reversed, int count, int compositesToGroup, int countMutliplierForCompatibility) {
        this.slices = slices;
        this.reversed = reversed;
        this.count = count;
        this.compositesToGroup = compositesToGroup;
        this.countMutliplierForCompatibility = countMutliplierForCompatibility;
    }

    public SliceQueryFilter withUpdatedCount(int newCount) {
        return new SliceQueryFilter(this.slices, this.reversed, newCount, this.compositesToGroup, this.countMutliplierForCompatibility);
    }

    @Override
    public OnDiskAtomIterator getMemtableColumnIterator(ColumnFamily cf, DecoratedKey key) {
        return Memtable.getSliceIterator(key, cf, this);
    }

    @Override
    public ISSTableColumnIterator getSSTableColumnIterator(SSTableReader sstable, DecoratedKey key) {
        return new SSTableSliceIterator(sstable, key, this.slices, this.reversed);
    }

    @Override
    public ISSTableColumnIterator getSSTableColumnIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry) {
        return new SSTableSliceIterator(sstable, file, key, this.slices, this.reversed, indexEntry);
    }

    @Override
    public SuperColumn filterSuperColumn(SuperColumn superColumn, int gcBefore) {
        Comparator<ByteBuffer> comparator;
        Iterator<IColumn> subcolumns;
        SuperColumn scFiltered = superColumn.cloneMeShallow();
        if (this.reversed) {
            ArrayList<IColumn> columnsAsList = new ArrayList<IColumn>(superColumn.getSubColumns());
            subcolumns = Lists.reverse(columnsAsList).iterator();
        } else {
            subcolumns = superColumn.getSubColumns().iterator();
        }
        Comparator<ByteBuffer> comparator2 = comparator = this.reversed ? superColumn.getComparator().reverseComparator : superColumn.getComparator();
        while (subcolumns.hasNext()) {
            IColumn column = subcolumns.next();
            if (comparator.compare(column.name(), this.start()) < 0) continue;
            subcolumns = Iterators.concat((Iterator)Iterators.singletonIterator((Object)column), subcolumns);
            break;
        }
        this.collectReducedColumns(scFiltered, subcolumns, gcBefore);
        return scFiltered;
    }

    @Override
    public Comparator<IColumn> getColumnComparator(AbstractType<?> comparator) {
        return this.reversed ? comparator.columnReverseComparator : comparator.columnComparator;
    }

    @Override
    public void collectReducedColumns(IColumnContainer container, Iterator<IColumn> reducedColumns, int gcBefore) {
        AbstractType<?> comparator = container.getComparator();
        this.columnCounter = this.compositesToGroup < 0 ? new ColumnCounter() : (this.compositesToGroup == 0 ? new ColumnCounter.GroupByPrefix(null, 0) : new ColumnCounter.GroupByPrefix((CompositeType)comparator, this.compositesToGroup));
        while (reducedColumns.hasNext()) {
            IColumn column = reducedColumns.next();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("collecting %s of %s: %s", this.columnCounter.live(), this.count, column.getString(comparator)));
            }
            this.columnCounter.count(column, container);
            if (this.columnCounter.live() > this.count) {
                logger.debug("Read %s live columns and %s tombstoned", (Object)this.columnCounter.live(), (Object)this.columnCounter.ignored());
                break;
            }
            if (!QueryFilter.isRelevant(column, container, gcBefore)) continue;
            container.addColumn(column);
        }
    }

    public ByteBuffer start() {
        return this.slices[0].start;
    }

    public ByteBuffer finish() {
        return this.slices[this.slices.length - 1].finish;
    }

    public void setStart(ByteBuffer start) {
        assert (this.slices.length == 1);
        this.slices[0] = new ColumnSlice(start, this.slices[0].finish);
    }

    public int lastCounted() {
        return this.columnCounter == null ? 0 : this.columnCounter.live();
    }

    public String toString() {
        return "SliceQueryFilter [reversed=" + this.reversed + ", slices=" + Arrays.toString(this.slices) + ", count=" + this.count + "]";
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void updateColumnsLimit(int newLimit) {
        this.count = newLimit;
    }

    public boolean includes(Comparator<ByteBuffer> cmp, ByteBuffer name) {
        for (ColumnSlice slice : this.slices) {
            if (!slice.includes(cmp, name)) continue;
            return true;
        }
        return false;
    }

    public static class Serializer
    implements IVersionedSerializer<SliceQueryFilter> {
        @Override
        public void serialize(SliceQueryFilter f, DataOutput dos, int version) throws IOException {
            if (version < 5) {
                ColumnSlice slice = new ColumnSlice(f.start(), f.finish());
                ColumnSlice.serializer.serialize(slice, dos, version);
            } else {
                dos.writeInt(f.slices.length);
                for (ColumnSlice slice : f.slices) {
                    ColumnSlice.serializer.serialize(slice, dos, version);
                }
            }
            dos.writeBoolean(f.reversed);
            int count = f.count;
            if (f.compositesToGroup > 0 && version < 5) {
                count *= f.countMutliplierForCompatibility;
            }
            dos.writeInt(count);
            if (version < 5) {
                return;
            }
            dos.writeInt(f.compositesToGroup);
        }

        @Override
        public SliceQueryFilter deserialize(DataInput dis, int version) throws IOException {
            ColumnSlice[] slices;
            if (version < 5) {
                slices = new ColumnSlice[]{ColumnSlice.serializer.deserialize(dis, version)};
            } else {
                slices = new ColumnSlice[dis.readInt()];
                for (int i = 0; i < slices.length; ++i) {
                    slices[i] = ColumnSlice.serializer.deserialize(dis, version);
                }
            }
            boolean reversed = dis.readBoolean();
            int count = dis.readInt();
            int compositesToGroup = -1;
            if (version >= 5) {
                compositesToGroup = dis.readInt();
            }
            return new SliceQueryFilter(slices, reversed, count, compositesToGroup, 1);
        }

        @Override
        public long serializedSize(SliceQueryFilter f, int version) {
            TypeSizes sizes = TypeSizes.NATIVE;
            int size = 0;
            if (version < 5) {
                size = (int)((long)size + ColumnSlice.serializer.serializedSize(new ColumnSlice(f.start(), f.finish()), version));
            } else {
                size += sizes.sizeof(f.slices.length);
                for (ColumnSlice slice : f.slices) {
                    size = (int)((long)size + ColumnSlice.serializer.serializedSize(slice, version));
                }
            }
            size += sizes.sizeof(f.reversed);
            size += sizes.sizeof(f.count);
            if (version >= 5) {
                size += sizes.sizeof(f.compositesToGroup);
            }
            return size;
        }
    }
}

