/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.ISSTableSerializer;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.IntervalTree;

public class DeletionInfo {
    private static final Serializer serializer = new Serializer();
    private final DeletionTime topLevel;
    private final IntervalTree<ByteBuffer, DeletionTime, RangeTombstone> ranges;
    public static final DeletionInfo LIVE = new DeletionInfo(DeletionTime.LIVE, IntervalTree.<ByteBuffer, DeletionTime, RangeTombstone>emptyTree());

    public DeletionInfo(long markedForDeleteAt, int localDeletionTime) {
        this(new DeletionTime(markedForDeleteAt, localDeletionTime == Integer.MIN_VALUE ? Integer.MAX_VALUE : localDeletionTime), IntervalTree.emptyTree());
    }

    public DeletionInfo(ByteBuffer start, ByteBuffer end, Comparator<ByteBuffer> comparator, long markedForDeleteAt, int localDeletionTime) {
        this(new RangeTombstone(start, end, new DeletionTime(markedForDeleteAt, localDeletionTime)), comparator);
    }

    public DeletionInfo(RangeTombstone rangeTombstone, Comparator<ByteBuffer> comparator) {
        this(DeletionTime.LIVE, IntervalTree.build(Collections.singletonList(rangeTombstone), comparator));
        assert (comparator != null);
    }

    private DeletionInfo(DeletionTime topLevel, IntervalTree<ByteBuffer, DeletionTime, RangeTombstone> ranges) {
        this.topLevel = topLevel;
        this.ranges = ranges;
    }

    public static Serializer serializer() {
        return serializer;
    }

    public boolean isLive() {
        return this.topLevel.markedForDeleteAt == Long.MIN_VALUE && this.topLevel.localDeletionTime == Integer.MAX_VALUE && this.ranges.isEmpty();
    }

    public boolean isDeleted(IColumn column) {
        return this.isDeleted(column.name(), column.mostRecentLiveChangeAt());
    }

    public boolean isDeleted(ByteBuffer name, long timestamp) {
        if (this.isLive()) {
            return false;
        }
        if (timestamp <= this.topLevel.markedForDeleteAt) {
            return true;
        }
        for (DeletionTime d : this.ranges.search(name)) {
            if (timestamp > d.markedForDeleteAt) continue;
            return true;
        }
        return false;
    }

    public DeletionInfo purge(int gcBefore) {
        if (this.ranges.isEmpty()) {
            return this.topLevel.localDeletionTime < gcBefore ? LIVE : this;
        }
        ArrayList<RangeTombstone> nonExpired = new ArrayList<RangeTombstone>();
        for (RangeTombstone range : this.ranges) {
            if (((DeletionTime)range.data).localDeletionTime < gcBefore) continue;
            nonExpired.add(range);
        }
        IntervalTree<ByteBuffer, DeletionTime, RangeTombstone> newRanges = nonExpired.size() == this.ranges.intervalCount() ? this.ranges : IntervalTree.build(nonExpired, this.ranges.comparator());
        return this.topLevel.localDeletionTime < gcBefore ? new DeletionInfo(DeletionTime.LIVE, newRanges) : new DeletionInfo(this.topLevel, newRanges);
    }

    public DeletionInfo add(DeletionInfo newInfo) {
        if (this.ranges.isEmpty()) {
            return this.topLevel.markedForDeleteAt < newInfo.topLevel.markedForDeleteAt ? newInfo : (newInfo.ranges.isEmpty() ? this : new DeletionInfo(this.topLevel, newInfo.ranges));
        }
        if (newInfo.ranges.isEmpty()) {
            return this.topLevel.markedForDeleteAt < newInfo.topLevel.markedForDeleteAt ? new DeletionInfo(newInfo.topLevel, this.ranges) : this;
        }
        HashSet merged = new HashSet();
        Iterables.addAll(merged, (Iterable)Iterables.concat(this.ranges, newInfo.ranges));
        return new DeletionInfo(this.topLevel.markedForDeleteAt < newInfo.topLevel.markedForDeleteAt ? newInfo.topLevel : this.topLevel, IntervalTree.build(merged, this.ranges.comparator()));
    }

    public long maxTimestamp() {
        long maxTimestamp = this.topLevel.markedForDeleteAt;
        for (RangeTombstone i : this.ranges) {
            maxTimestamp = Math.max(maxTimestamp, ((DeletionTime)i.data).markedForDeleteAt);
        }
        return maxTimestamp;
    }

    public DeletionTime getTopLevelDeletion() {
        return this.topLevel;
    }

    public Iterator<RangeTombstone> rangeIterator() {
        return this.ranges.iterator();
    }

    public int dataSize() {
        int size = TypeSizes.NATIVE.sizeof(this.topLevel.markedForDeleteAt);
        for (RangeTombstone r : this.ranges) {
            size += ((ByteBuffer)r.min).remaining() + ((ByteBuffer)r.max).remaining();
            size += TypeSizes.NATIVE.sizeof(((DeletionTime)r.data).markedForDeleteAt);
        }
        return size;
    }

    public String toString() {
        if (this.ranges.isEmpty()) {
            return String.format("{%s}", this.topLevel);
        }
        return String.format("{%s, ranges=%s}", this.topLevel, this.rangesAsString());
    }

    private String rangesAsString() {
        assert (!this.ranges.isEmpty());
        StringBuilder sb = new StringBuilder();
        AbstractType at = (AbstractType)this.ranges.comparator();
        assert (at != null);
        for (RangeTombstone i : this.ranges) {
            sb.append("[");
            sb.append(at.getString((ByteBuffer)i.min)).append("-");
            sb.append(at.getString((ByteBuffer)i.max)).append(", ");
            sb.append(i.data);
            sb.append("]");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeletionInfo)) {
            return false;
        }
        DeletionInfo that = (DeletionInfo)o;
        return this.topLevel.equals(that.topLevel) && this.ranges.equals(that.ranges);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.topLevel, this.ranges});
    }

    public static class Serializer
    implements IVersionedSerializer<DeletionInfo>,
    ISSTableSerializer<DeletionInfo> {
        private static final ISerializer<ByteBuffer> bbSerializer = new ISerializer<ByteBuffer>(){

            @Override
            public void serialize(ByteBuffer bb, DataOutput dos) throws IOException {
                ByteBufferUtil.writeWithShortLength(bb, dos);
            }

            @Override
            public ByteBuffer deserialize(DataInput dis) throws IOException {
                return ByteBufferUtil.readWithShortLength(dis);
            }

            @Override
            public long serializedSize(ByteBuffer bb, TypeSizes typeSizes) {
                int bbSize = bb.remaining();
                return typeSizes.sizeof((short)bbSize) + bbSize;
            }
        };
        private static final IntervalTree.Serializer<ByteBuffer, DeletionTime, RangeTombstone> itSerializer;

        @Override
        public void serialize(DeletionInfo info, DataOutput out, int version) throws IOException {
            DeletionTime.serializer.serialize(info.topLevel, out);
            if (version < 5) {
                if (!info.ranges.isEmpty()) {
                    throw new RuntimeException("Cannot send range tombstone to pre-1.2 node. You should upgrade all node to Cassandra 1.2+ before using range tombstone.");
                }
            } else {
                itSerializer.serialize(info.ranges, out, version);
            }
        }

        @Override
        public void serializeForSSTable(DeletionInfo info, DataOutput out) throws IOException {
            DeletionTime.serializer.serialize(info.topLevel, out);
        }

        @Override
        public DeletionInfo deserialize(DataInput in, int version) throws IOException {
            throw new UnsupportedOperationException();
        }

        public DeletionInfo deserialize(DataInput in, int version, Comparator<ByteBuffer> comparator) throws IOException {
            assert (comparator != null);
            DeletionTime topLevel = DeletionTime.serializer.deserialize(in);
            if (version < 5) {
                return new DeletionInfo(topLevel, IntervalTree.emptyTree());
            }
            IntervalTree<ByteBuffer, DeletionTime, RangeTombstone> ranges = itSerializer.deserialize(in, version, comparator);
            return new DeletionInfo(topLevel, ranges);
        }

        @Override
        public DeletionInfo deserializeFromSSTable(DataInput in, Descriptor.Version version) throws IOException {
            DeletionTime topLevel = DeletionTime.serializer.deserialize(in);
            return new DeletionInfo(topLevel, IntervalTree.emptyTree());
        }

        public long serializedSize(DeletionInfo info, TypeSizes typeSizes, int version) {
            long size = DeletionTime.serializer.serializedSize(info.topLevel, typeSizes);
            if (version < 5) {
                return size;
            }
            return size + itSerializer.serializedSize(info.ranges, typeSizes, version);
        }

        @Override
        public long serializedSize(DeletionInfo info, int version) {
            return this.serializedSize(info, TypeSizes.NATIVE, version);
        }

        static {
            try {
                Constructor constructor = RangeTombstone.class.getConstructor(ByteBuffer.class, ByteBuffer.class, DeletionTime.class);
                itSerializer = IntervalTree.serializer(bbSerializer, DeletionTime.serializer, constructor);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

