/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.operations;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.operations.Operation;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;

public class ListOperation
implements Operation {
    private static final long REFERENCE_TIME = 1262304000000L;
    private static final AtomicReference<PrecisionTime> last = new AtomicReference<PrecisionTime>(new PrecisionTime(Long.MAX_VALUE, 0));
    private final List<Term> values;
    private final Kind kind;

    private static PrecisionTime getNextTime(long millis) {
        PrecisionTime next;
        PrecisionTime current;
        do {
            current = last.get();
            assert (millis <= current.millis);
        } while (!last.compareAndSet(current, next = millis < current.millis ? new PrecisionTime(millis, 0) : new PrecisionTime(millis, current.nanos + 1)));
        return next;
    }

    private ListOperation(List<Term> values, Kind kind) {
        this.values = Collections.unmodifiableList(values);
        this.kind = kind;
    }

    @Override
    public void execute(ColumnFamily cf, ColumnNameBuilder builder, CollectionType validator, UpdateParameters params, List<Pair<ByteBuffer, IColumn>> list) throws InvalidRequestException {
        if (validator.kind != CollectionType.Kind.LIST) {
            throw new InvalidRequestException("List operations are only supported on List typed columns, but " + validator + " given.");
        }
        switch (this.kind) {
            case SET: {
                cf.addAtom(params.makeTombstoneForOverwrite(builder.copy().build(), builder.copy().buildAsEndOfRange()));
                this.doAppend(cf, builder, validator, params);
                break;
            }
            case SET_IDX: {
                this.doSet(cf, builder, params, validator, list);
                break;
            }
            case APPEND: {
                this.doAppend(cf, builder, validator, params);
                break;
            }
            case PREPEND: {
                this.doPrepend(cf, builder, validator, params);
                break;
            }
            case DISCARD: {
                this.doDiscard(cf, validator, params, list);
                break;
            }
            case DISCARD_IDX: {
                this.doDiscardIdx(cf, params, list);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported List operation: " + (Object)((Object)this.kind)));
            }
        }
    }

    @Override
    public void execute(ColumnFamily cf, ColumnNameBuilder builder, AbstractType<?> validator, UpdateParameters params) throws InvalidRequestException {
        throw new InvalidRequestException("List operations are only supported on List typed columns, but " + validator + " given.");
    }

    private void doSet(ColumnFamily cf, ColumnNameBuilder builder, UpdateParameters params, CollectionType validator, List<Pair<ByteBuffer, IColumn>> list) throws InvalidRequestException {
        int idx = this.validateListIdx(this.values.get(0), list);
        Term value = this.values.get(1);
        ByteBuffer name = ((IColumn)list.get((int)idx).right).name();
        cf.addColumn(params.makeColumn(name, value.getByteBuffer(validator.valueComparator(), params.variables)));
    }

    private void doAppend(ColumnFamily cf, ColumnNameBuilder builder, CollectionType validator, UpdateParameters params) throws InvalidRequestException {
        for (int i = 0; i < this.values.size(); ++i) {
            ColumnNameBuilder b = i == this.values.size() - 1 ? builder : builder.copy();
            ByteBuffer uuid = ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes());
            ByteBuffer name = b.add(uuid).build();
            cf.addColumn(params.makeColumn(name, this.values.get(i).getByteBuffer(validator.valueComparator(), params.variables)));
        }
    }

    private void doPrepend(ColumnFamily cf, ColumnNameBuilder builder, CollectionType validator, UpdateParameters params) throws InvalidRequestException {
        long time = 1262304000000L - (System.currentTimeMillis() - 1262304000000L);
        for (int i = this.values.size() - 1; i >= 0; --i) {
            ColumnNameBuilder b = i == 0 ? builder : builder.copy();
            PrecisionTime pt = ListOperation.getNextTime(time);
            ByteBuffer uuid = ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes(pt.millis, pt.nanos));
            ByteBuffer name = b.add(uuid).build();
            cf.addColumn(params.makeColumn(name, this.values.get(i).getByteBuffer(validator.valueComparator(), params.variables)));
        }
    }

    private void doDiscard(ColumnFamily cf, CollectionType validator, UpdateParameters params, List<Pair<ByteBuffer, IColumn>> list) throws InvalidRequestException {
        if (list == null) {
            return;
        }
        HashSet<ByteBuffer> toDiscard = new HashSet<ByteBuffer>();
        for (Term term : this.values) {
            toDiscard.add(term.getByteBuffer(validator.valueComparator(), params.variables));
        }
        for (Pair pair : list) {
            IColumn c = (IColumn)pair.right;
            if (!toDiscard.contains(c.value())) continue;
            cf.addColumn(params.makeTombstone(c.name()));
        }
    }

    private void doDiscardIdx(ColumnFamily cf, UpdateParameters params, List<Pair<ByteBuffer, IColumn>> list) throws InvalidRequestException {
        int idx = this.validateListIdx(this.values.get(0), list);
        cf.addColumn(params.makeTombstone(((IColumn)list.get((int)idx).right).name()));
    }

    @Override
    public List<Term> getValues() {
        return this.values;
    }

    @Override
    public boolean requiresRead() {
        return this.kind == Kind.DISCARD || this.kind == Kind.DISCARD_IDX || this.kind == Kind.SET || this.kind == Kind.SET_IDX;
    }

    @Override
    public Operation.Type getType() {
        return Operation.Type.LIST;
    }

    public static Operation Set(List<Term> values) {
        return new ListOperation(values, Kind.SET);
    }

    public static Operation SetIndex(List<Term> values) {
        return new ListOperation(values, Kind.SET_IDX);
    }

    public static Operation Append(List<Term> values) {
        return new ListOperation(values, Kind.APPEND);
    }

    public static Operation Prepend(List<Term> values) {
        return new ListOperation(values, Kind.PREPEND);
    }

    public static Operation Discard(List<Term> values) {
        return new ListOperation(values, Kind.DISCARD);
    }

    public static Operation DiscardKey(List<Term> values) {
        return new ListOperation(values, Kind.DISCARD_IDX);
    }

    private int validateListIdx(Term value, List<Pair<ByteBuffer, IColumn>> list) throws InvalidRequestException {
        try {
            if (value.getType() != Term.Type.INTEGER) {
                throw new InvalidRequestException(String.format("Invalid argument %s for %s, must be an integer.", new Object[]{value.getText(), this.getType()}));
            }
            int idx = Integer.parseInt(value.getText());
            if (list == null || list.size() <= idx) {
                throw new InvalidRequestException(String.format("Invalid index %d, list has size %d", idx, list == null ? 0 : list.size()));
            }
            return idx;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException();
        }
    }

    static enum Kind {
        SET,
        SET_IDX,
        APPEND,
        PREPEND,
        DISCARD,
        DISCARD_IDX;

    }

    private static class PrecisionTime {
        public final long millis;
        public final int nanos;

        public PrecisionTime(long millis, int nanos) {
            this.millis = millis;
            this.nanos = nanos;
        }
    }
}

