/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import com.googlecode.concurrentlinkedhashmap.Weigher;
import java.io.IOException;
import java.util.Set;
import org.apache.cassandra.cache.FreeableMemory;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.MemoryInputStream;
import org.apache.cassandra.io.util.MemoryOutputStream;
import org.apache.cassandra.utils.vint.EncodedDataInputStream;
import org.apache.cassandra.utils.vint.EncodedDataOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializingCache<K, V>
implements ICache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(SerializingCache.class);
    private static final TypeSizes ENCODED_TYPE_SIZES = TypeSizes.VINT;
    private static final int DEFAULT_CONCURENCY_LEVEL = 64;
    private final ConcurrentLinkedHashMap<K, FreeableMemory> map;
    private final ISerializer<V> serializer;

    private SerializingCache(long capacity, Weigher<FreeableMemory> weigher, ISerializer<V> serializer) {
        this.serializer = serializer;
        EvictionListener listener = new EvictionListener<K, FreeableMemory>(){

            public void onEviction(K k, FreeableMemory mem) {
                mem.unreference();
            }
        };
        this.map = new ConcurrentLinkedHashMap.Builder().weigher(weigher).maximumWeightedCapacity(capacity).concurrencyLevel(64).listener(listener).build();
    }

    public static <K, V> SerializingCache<K, V> create(long weightedCapacity, Weigher<FreeableMemory> weigher, ISerializer<V> serializer) {
        return new SerializingCache<K, V>(weightedCapacity, weigher, serializer);
    }

    public static <K, V> SerializingCache<K, V> create(long weightedCapacity, ISerializer<V> serializer) {
        return SerializingCache.create(weightedCapacity, new Weigher<FreeableMemory>(){

            public int weightOf(FreeableMemory value) {
                long size = value.size();
                assert (size < Integer.MAX_VALUE) : "Serialized size cannot be more than 2GB";
                return (int)size;
            }
        }, serializer);
    }

    private V deserialize(FreeableMemory mem) {
        try {
            return this.serializer.deserialize(new EncodedDataInputStream(new MemoryInputStream(mem)));
        }
        catch (IOException e) {
            logger.debug("Cannot fetch in memory data, we will failback to read from disk ", (Throwable)e);
            return null;
        }
    }

    private FreeableMemory serialize(V value) {
        FreeableMemory freeableMemory;
        long serializedSize = this.serializer.serializedSize(value, ENCODED_TYPE_SIZES);
        if (serializedSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to allocate " + serializedSize + " bytes");
        }
        try {
            freeableMemory = new FreeableMemory(serializedSize);
        }
        catch (OutOfMemoryError e) {
            return null;
        }
        try {
            this.serializer.serialize(value, new EncodedDataOutputStream(new MemoryOutputStream(freeableMemory)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return freeableMemory;
    }

    @Override
    public long capacity() {
        return this.map.capacity();
    }

    @Override
    public void setCapacity(long capacity) {
        this.map.setCapacity(capacity);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public long weightedSize() {
        return this.map.weightedSize();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        FreeableMemory mem = (FreeableMemory)this.map.get(key);
        if (mem == null) {
            return null;
        }
        if (!mem.reference()) {
            return null;
        }
        try {
            V v = this.deserialize(mem);
            return v;
        }
        finally {
            mem.unreference();
        }
    }

    @Override
    public void put(K key, V value) {
        FreeableMemory mem = this.serialize(value);
        if (mem == null) {
            return;
        }
        FreeableMemory old = (FreeableMemory)this.map.put(key, (Object)mem);
        if (old != null) {
            old.unreference();
        }
    }

    @Override
    public boolean putIfAbsent(K key, V value) {
        FreeableMemory mem = this.serialize(value);
        if (mem == null) {
            return false;
        }
        FreeableMemory old = (FreeableMemory)this.map.putIfAbsent(key, (Object)mem);
        if (old != null) {
            mem.unreference();
        }
        return old == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldToReplace, V value) {
        boolean success;
        V oldValue;
        FreeableMemory old = (FreeableMemory)this.map.get(key);
        if (old == null) {
            return false;
        }
        FreeableMemory mem = this.serialize(value);
        if (mem == null) {
            return false;
        }
        if (!old.reference()) {
            return false;
        }
        try {
            oldValue = this.deserialize(old);
        }
        finally {
            old.unreference();
        }
        boolean bl = success = oldValue.equals(oldToReplace) && this.map.replace(key, (Object)old, (Object)mem);
        if (success) {
            old.unreference();
        } else {
            mem.unreference();
        }
        return success;
    }

    @Override
    public void remove(K key) {
        FreeableMemory mem = (FreeableMemory)this.map.remove(key);
        if (mem != null) {
            mem.unreference();
        }
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<K> hotKeySet(int n) {
        return this.map.descendingKeySetWithLimit(n);
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean isPutCopying() {
        return true;
    }
}

