/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.Arrays;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public class KeyCacheKey
implements CacheKey {
    public final Descriptor desc;
    public final byte[] key;

    public KeyCacheKey(Descriptor desc, ByteBuffer key) {
        this.desc = desc;
        this.key = ByteBufferUtil.getArray(key);
        assert (this.key != null);
    }

    @Override
    public Pair<String, String> getPathInfo() {
        return Pair.create(this.desc.ksname, this.desc.cfname);
    }

    public String toString() {
        try {
            return String.format("KeyCacheKey(descriptor:%s, key:%s)", this.desc, ByteBufferUtil.string(ByteBuffer.wrap(this.key)));
        }
        catch (CharacterCodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyCacheKey that = (KeyCacheKey)o;
        if (this.desc != null ? !this.desc.equals(that.desc) : that.desc != null) {
            return false;
        }
        return Arrays.equals(this.key, that.key);
    }

    public int hashCode() {
        int result = this.desc != null ? this.desc.hashCode() : 0;
        result = 31 * result + (this.key != null ? Arrays.hashCode(this.key) : 0);
        return result;
    }
}

