/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.util.Collections;
import java.util.List;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Pair;

public class Bounds<T extends RingPosition>
extends AbstractBounds<T> {
    public Bounds(T left, T right) {
        this(left, right, StorageService.getPartitioner());
    }

    Bounds(T left, T right, IPartitioner partitioner) {
        super(left, right, partitioner);
        assert (left.compareTo(right) <= 0 || right.isMinimum(partitioner)) : "[" + left + "," + right + "]";
    }

    @Override
    public boolean contains(T position) {
        return this.left.equals(position) || (this.right.isMinimum(this.partitioner) || !this.left.equals(this.right)) && Range.contains(this.left, this.right, position);
    }

    @Override
    public Pair<AbstractBounds<T>, AbstractBounds<T>> split(T position) {
        assert (this.contains(position));
        if (position.equals(this.right)) {
            return null;
        }
        Bounds<RingPosition> lb = new Bounds<RingPosition>(this.left, (RingPosition)position, this.partitioner);
        Range<RingPosition> rb = new Range<RingPosition>((RingPosition)position, this.right, this.partitioner);
        return new Pair<AbstractBounds<T>, AbstractBounds<T>>(lb, rb);
    }

    public boolean intersects(Bounds<T> that) {
        return this.contains(that.left) || this.contains(that.right) || that.contains(this.left);
    }

    @Override
    public List<? extends AbstractBounds<T>> unwrap() {
        return Collections.singletonList(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Bounds)) {
            return false;
        }
        Bounds rhs = (Bounds)o;
        return this.left.equals(rhs.left) && this.right.equals(rhs.right);
    }

    public String toString() {
        return "[" + this.left + "," + this.right + "]";
    }

    public static Bounds<RowPosition> makeRowBounds(Token left, Token right, IPartitioner partitioner) {
        return new Bounds<RowPosition>(left.minKeyBound(partitioner), right.maxKeyBound(partitioner), partitioner);
    }

    @Override
    public AbstractBounds<RowPosition> toRowBounds() {
        return this.left instanceof Token ? Bounds.makeRowBounds((Token)this.left, (Token)this.right, this.partitioner) : this;
    }

    @Override
    public AbstractBounds<Token> toTokenBounds() {
        return this.left instanceof RowPosition ? new Bounds<Token>(((RowPosition)this.left).getToken(), ((RowPosition)this.right).getToken(), this.partitioner) : this;
    }
}

