/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.cassandra.db.SnapshotCommandSerializer;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.FastByteArrayInputStream;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessageProducer;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public class SnapshotCommand
implements MessageProducer {
    private static final SnapshotCommandSerializer serializer = new SnapshotCommandSerializer();
    public final String keyspace;
    public final String column_family;
    public final String snapshot_name;
    public final boolean clear_snapshot;

    public SnapshotCommand(String keyspace, String columnFamily, String snapshotName, boolean clearSnapshot) {
        this.keyspace = keyspace;
        this.column_family = columnFamily;
        this.snapshot_name = snapshotName;
        this.clear_snapshot = clearSnapshot;
    }

    @Override
    public Message getMessage(Integer version) throws IOException {
        DataOutputBuffer dob = new DataOutputBuffer();
        serializer.serialize(this, (DataOutput)dob, (int)version);
        return new Message(FBUtilities.getBroadcastAddress(), StorageService.Verb.SNAPSHOT, Arrays.copyOf(dob.getData(), dob.getLength()), version);
    }

    public static SnapshotCommand read(Message message) throws IOException {
        byte[] bytes = message.getMessageBody();
        FastByteArrayInputStream bis = new FastByteArrayInputStream(bytes);
        return serializer.deserialize(new DataInputStream(bis), message.getVersion());
    }

    public String toString() {
        return "SnapshotCommand{keyspace='" + this.keyspace + '\'' + ", column_family='" + this.column_family + '\'' + ", snapshot_name=" + this.snapshot_name + ", clear_snapshot=" + this.clear_snapshot + '}';
    }
}

