/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.EnumMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.JMXConfigurableThreadPoolExecutor;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.config.DatabaseDescriptor;

public class StageManager {
    private static EnumMap<Stage, ThreadPoolExecutor> stages = new EnumMap(Stage.class);
    public static final long KEEPALIVE = 60L;
    public static final int MAX_REPLICATE_ON_WRITE_TASKS = 1024 * Runtime.getRuntime().availableProcessors();

    private static ThreadPoolExecutor multiThreadedStage(Stage stage, int numThreads) {
        return new JMXEnabledThreadPoolExecutor(numThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(stage.getJmxName()), stage.getJmxType());
    }

    private static ThreadPoolExecutor multiThreadedConfigurableStage(Stage stage, int numThreads) {
        return new JMXConfigurableThreadPoolExecutor(numThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(stage.getJmxName()), stage.getJmxType());
    }

    private static ThreadPoolExecutor multiThreadedConfigurableStage(Stage stage, int numThreads, int maxTasksBeforeBlock) {
        return new JMXConfigurableThreadPoolExecutor(numThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(maxTasksBeforeBlock), new NamedThreadFactory(stage.getJmxName()), stage.getJmxType());
    }

    public static ThreadPoolExecutor getStage(Stage stage) {
        return stages.get((Object)stage);
    }

    public static void shutdownNow() {
        for (Stage stage : Stage.values()) {
            stages.get((Object)stage).shutdownNow();
        }
    }

    static {
        stages.put(Stage.MUTATION, StageManager.multiThreadedConfigurableStage(Stage.MUTATION, DatabaseDescriptor.getConcurrentWriters()));
        stages.put(Stage.READ, StageManager.multiThreadedConfigurableStage(Stage.READ, DatabaseDescriptor.getConcurrentReaders()));
        stages.put(Stage.REQUEST_RESPONSE, StageManager.multiThreadedStage(Stage.REQUEST_RESPONSE, Runtime.getRuntime().availableProcessors()));
        stages.put(Stage.INTERNAL_RESPONSE, StageManager.multiThreadedStage(Stage.INTERNAL_RESPONSE, Runtime.getRuntime().availableProcessors()));
        stages.put(Stage.REPLICATE_ON_WRITE, StageManager.multiThreadedConfigurableStage(Stage.REPLICATE_ON_WRITE, DatabaseDescriptor.getConcurrentReplicators(), MAX_REPLICATE_ON_WRITE_TASKS));
        stages.put(Stage.STREAM, new JMXEnabledThreadPoolExecutor(Stage.STREAM));
        stages.put(Stage.GOSSIP, new JMXEnabledThreadPoolExecutor(Stage.GOSSIP));
        stages.put(Stage.ANTI_ENTROPY, new JMXEnabledThreadPoolExecutor(Stage.ANTI_ENTROPY));
        stages.put(Stage.MIGRATION, new JMXEnabledThreadPoolExecutor(Stage.MIGRATION));
        stages.put(Stage.MISC, new JMXEnabledThreadPoolExecutor(Stage.MISC));
        stages.put(Stage.READ_REPAIR, StageManager.multiThreadedStage(Stage.READ_REPAIR, Runtime.getRuntime().availableProcessors()));
    }
}

